/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@PluginTypeHandlerType(value="oauth2", position=ExtensionPointPositionEnum.ABILITY_TEST_POSITION)
public class Oauth2AbilityTestHandler
extends AbstractPluginHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(Oauth2AbilityTestHandler.class);

    public RspBO handleHeadInfo(Object o) throws ZTBusinessException {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Map appMap = (Map)o;
        if (StringUtils.isEmpty(appMap.get("appCode"))) {
            super.handleHeadInfo(o);
        }
        if (StringUtils.isEmpty(appMap.get("abilityPluginId"))) {
            super.handleHeadInfo(o);
        }
        String appCode = (String)appMap.get("appCode");
        String appSercret = (String)appMap.get("appSercret");
        Date date = new Date();
        String transId = Oauth2AbilityTestHandler.genTransId(date);
        String timestamp = String.valueOf(System.currentTimeMillis());
        TreeMap<String, String> paramTreeMap = new TreeMap<String, String>();
        paramTreeMap.put("appCode", appCode);
        paramTreeMap.put("transId", transId);
        paramTreeMap.put("timestamp", timestamp);
        paramTreeMap.put("appSecret", appSercret);
        log.info("paramTreeMap = {}", paramTreeMap);
        map.put("transId", transId);
        map.put("timestamp", timestamp);
        map.put("accessToken", "");
        return RspBO.success(map);
    }

    public static String genTransId(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return simpleDateFormat.format(date) + Oauth2AbilityTestHandler.getRandomNumberInRange(100000, 999999);
    }

    private static int getRandomNumberInRange(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }
}

