/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityProvideOauthMapper;
import com.ohaotian.plugin.model.bo.req.AbilityProvideOauth2ReqBo;
import com.ohaotian.plugin.model.bo.req.Oauth2ModifyUserReqBo;
import com.ohaotian.plugin.model.bo.req.Oauth2addUserReqBo;
import com.ohaotian.plugin.model.bo.req.RefreshTokenReqBo;
import com.ohaotian.plugin.model.bo.rsp.AbilityProvideOauth2RspBo;
import com.ohaotian.plugin.model.bo.rsp.Oauth2ModifyUserRspBo;
import com.ohaotian.plugin.model.bo.rsp.Oauth2addUserRspBo;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBo;
import com.ohaotian.plugin.model.po.AbilityProvideOauthPo;
import com.ohaotian.plugin.service.Oauth2PluginUserService;
import com.ohaotian.plugin.utils.Sequence;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class Oauth2PluginUserServiceImpl
implements Oauth2PluginUserService {
    private static final Logger log = LoggerFactory.getLogger(Oauth2PluginUserServiceImpl.class);
    @Resource
    private AbilityProvideOauthMapper abilityProvideOauthMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private AppAPI appApi;
    @Resource
    private AuthorityService authorityService;
    @Value(value="${ability.oauth.add.enabled:true}")
    private Boolean addUserEnabled;
    @Value(value="${ability.oauth.refresh.offset:60}")
    private int refreshOffset;
    @Value(value="${ability.oauth.refresh.stand.time:30}")
    private int reqRefreshStandTime;

    @Override
    public Oauth2addUserRspBo addUser(Oauth2addUserReqBo reqBo) {
        try {
            if (Boolean.FALSE.equals(this.addUserEnabled)) {
                throw new ZTBusinessException("\u7528\u6237\u521b\u5efa\u5f02\u5e38");
            }
            AbilityProvideOauthPo addPo = new AbilityProvideOauthPo();
            addPo.setOauthId(String.valueOf(Sequence.nextId()));
            addPo.setUsername(reqBo.getUsername());
            addPo.setClientId(reqBo.getClientId());
            addPo.setClusterId(reqBo.getClusterId());
            int randInt = RandomUtil.randomInt((int)9, (int)11);
            String clientSecret = RandomUtil.randomString((int)randInt);
            String clientSecretReal = StringUtils.leftPad((String)StringUtils.left((String)(clientSecret + reqBo.getClusterId() + reqBo.getUsername()), (int)16), (int)16, (String)"@");
            SM4 sm4 = SmUtil.sm4((byte[])clientSecretReal.getBytes(CharsetUtil.CHARSET_UTF_8));
            String password = sm4.encryptHex(reqBo.getPassword());
            addPo.setPassword(password);
            addPo.setClientSecret(clientSecret);
            addPo.setAccessTokenValidity(String.valueOf(86400));
            addPo.setStartSwitch(1);
            AbilityProvideOauthPo judgePo = new AbilityProvideOauthPo();
            judgePo.setUsername(reqBo.getUsername());
            judgePo.setClientId(reqBo.getClientId());
            judgePo.setClusterId(reqBo.getClusterId());
            judgePo = this.abilityProvideOauthMapper.selectByAllOne(judgePo);
            if (!ObjectUtils.isEmpty((Object)judgePo)) {
                throw new ZTBusinessException("\u7528\u6237\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            this.abilityProvideOauthMapper.insert(addPo);
            Oauth2addUserRspBo rspBo = new Oauth2addUserRspBo();
            rspBo.setSuccess(Boolean.TRUE);
            rspBo.setResultCode("0000");
            rspBo.setResultMessage("\u7528\u6237\u521b\u5efa\u6210\u529f");
            rspBo.setResult(clientSecret);
            try {
                RspBO checkAppCode = this.appApi.checkAppCode(null, reqBo.getClientId());
                if (Boolean.TRUE.equals(checkAppCode.getData())) {
                    JSONObject addAppUserJson = Oauth2PluginUserServiceImpl.getAddAppUser(reqBo);
                    RspBO addResult = this.appApi.appRegiste((Object)addAppUserJson);
                    if (Boolean.TRUE.equals(addResult.getData())) {
                        rspBo.setResultMessage(rspBo.getResultMessage() + ",\u8ba2\u8d2d\u5e94\u7528\u521b\u5efa\u5b8c\u6210");
                    } else {
                        rspBo.setResultMessage(rspBo.getResultMessage() + ",\u8ba2\u8d2d\u5e94\u7528\u521b\u5efa\u5931\u8d25");
                    }
                } else {
                    rspBo.setResultMessage(rspBo.getResultMessage() + ",\u8ba2\u8d2d\u5e94\u7528\u5df2\u5b58\u5728\uff01");
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                rspBo.setResultMessage(rspBo.getResultMessage() + ",\u8ba2\u8d2d\u5e94\u7528\u521b\u5efa\u5931\u8d25\uff01" + e.getMessage());
            }
            return rspBo;
        }
        catch (Exception e) {
            Oauth2addUserRspBo rspBo = new Oauth2addUserRspBo();
            rspBo.setSuccess(Boolean.FALSE);
            rspBo.setResultCode("9999");
            rspBo.setResultMessage("\u521b\u5efa\u5931\u8d25");
            rspBo.setResult(e.getMessage());
            return rspBo;
        }
    }

    private static JSONObject getAddAppUser(Oauth2addUserReqBo reqBo) {
        JSONObject addAppUserJson = new JSONObject();
        addAppUserJson.put("appCode", (Object)reqBo.getClientId());
        addAppUserJson.put("appContact", (Object)"Oauth2\u63d2\u4ef6");
        addAppUserJson.put("appName", (Object)reqBo.getUsername());
        addAppUserJson.put("appPhone", (Object)"12345678900");
        addAppUserJson.put("isProvider", (Object)"0");
        addAppUserJson.put("remark", (Object)"\u521b\u5efa\u8ba2\u8d2d\u7528\u6237");
        JSONObject appExtColumnReqBo = new JSONObject();
        appExtColumnReqBo.put("appFive", (Object)"\u9ed8\u8ba4");
        appExtColumnReqBo.put("appFour", (Object)"\u9ed8\u8ba4");
        appExtColumnReqBo.put("appOne", (Object)"\u9ed8\u8ba4");
        appExtColumnReqBo.put("appThree", (Object)"\u9ed8\u8ba4");
        appExtColumnReqBo.put("appTwo", (Object)"\u9ed8\u8ba4");
        addAppUserJson.put("appExtColumnReqBO", (Object)appExtColumnReqBo);
        return addAppUserJson;
    }

    @Override
    public RefreshTokenRspBo accessToken(RefreshTokenReqBo reqBo) {
        try {
            if (Boolean.FALSE.equals(this.checkTime(reqBo))) {
                throw new ZTBusinessException("\u65f6\u95f4\u6233\u5df2\u8fc7\u671f\uff01");
            }
            AbilityProvideOauthPo abilityProvideOauthPo = new AbilityProvideOauthPo();
            abilityProvideOauthPo.setUsername(reqBo.getUserName());
            abilityProvideOauthPo.setClientId(reqBo.getClientId());
            abilityProvideOauthPo.setStartSwitch(1);
            String timeFormat = reqBo.getTimestamp().replace(":", "").replace(" ", "");
            SM4 sm4 = SmUtil.sm4((byte[])timeFormat.getBytes(CharsetUtil.CHARSET_UTF_8));
            String clientSecret = sm4.decryptStr(reqBo.getClientSecret(), CharsetUtil.CHARSET_UTF_8);
            abilityProvideOauthPo.setClientSecret(clientSecret);
            abilityProvideOauthPo = this.abilityProvideOauthMapper.selectByAllOne(abilityProvideOauthPo);
            if (ObjectUtils.isEmpty((Object)abilityProvideOauthPo)) {
                RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
                rspBo.setSuccess(Boolean.FALSE);
                rspBo.setResultCode("9999");
                rspBo.setResultMessage("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
                return rspBo;
            }
            String password = sm4.decryptStr(reqBo.getUserPassword(), CharsetUtil.CHARSET_UTF_8);
            String clientSecretReal = StringUtils.leftPad((String)StringUtils.left((String)(clientSecret + abilityProvideOauthPo.getClusterId() + reqBo.getUserName()), (int)16), (int)16, (String)"@");
            SM4 clientSecretSm4 = SmUtil.sm4((byte[])clientSecretReal.getBytes(CharsetUtil.CHARSET_UTF_8));
            if (!abilityProvideOauthPo.getPassword().equals(clientSecretSm4.encryptHex(password, CharsetUtil.CHARSET_UTF_8))) {
                RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
                rspBo.setSuccess(Boolean.FALSE);
                rspBo.setResultCode("9999");
                rspBo.setResultMessage("\u9274\u6743\u5931\u8d25\uff01");
                return rspBo;
            }
            ArrayList<String> roles = new ArrayList<String>();
            roles.add(reqBo.getClientId());
            String token = this.createToken(reqBo.getUserName(), clientSecret, roles, Long.parseLong(abilityProvideOauthPo.getAccessTokenValidity()) * 1000L);
            AbilityProvideOauthPo tokenPo = new AbilityProvideOauthPo();
            tokenPo.setOauthId(abilityProvideOauthPo.getOauthId());
            tokenPo.setAccessToken(token);
            this.abilityProvideOauthMapper.updateByPrimaryKeySelective(tokenPo);
            String oldToken = "atp-" + abilityProvideOauthPo.getClusterId() + "-" + abilityProvideOauthPo.getAccessToken();
            Object obj = this.cacheClient.get(oldToken);
            if (!ObjectUtils.isEmpty((Object)obj)) {
                this.cacheClient.expire(oldToken, this.refreshOffset);
                log.info("\u7528\u6237\uff1a{} \u5386\u53f2token\uff1a{}  {}s\u540e\u5931\u6548...", new Object[]{reqBo.getUserName(), abilityProvideOauthPo.getAccessToken(), this.refreshOffset});
            }
            String tokenKey = "atp-" + abilityProvideOauthPo.getClusterId() + "-" + token;
            this.cacheClient.set(tokenKey, (Object)reqBo.getClientId(), Integer.parseInt(abilityProvideOauthPo.getAccessTokenValidity()));
            RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
            rspBo.setSuccess(Boolean.TRUE);
            rspBo.setResultCode("0000");
            rspBo.setResultMessage("\u5237\u65b0\u6210\u529f");
            RefreshTokenRspBo.TokenRspBO tokenRspBo = new RefreshTokenRspBo.TokenRspBO();
            tokenRspBo.setAccess_token(token);
            tokenRspBo.setRefresh_token(token);
            tokenRspBo.setTime(com.ohaotian.portalcommon.util.DateUtil.getCurrentDateTime());
            tokenRspBo.setExpires_in(Long.parseLong(abilityProvideOauthPo.getAccessTokenValidity()));
            rspBo.setResult(tokenRspBo);
            return rspBo;
        }
        catch (ZTBusinessException zte) {
            log.error(zte.getMessage(), (Throwable)zte);
            RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
            rspBo.setSuccess(Boolean.FALSE);
            rspBo.setResultCode("9999");
            rspBo.setResultMessage(zte.getMessage());
            return rspBo;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
            rspBo.setSuccess(Boolean.FALSE);
            rspBo.setResultCode("9999");
            rspBo.setResultMessage("\u7cfb\u7edf\u5f02\u5e38!");
            return rspBo;
        }
    }

    @Override
    public RspBO<RspPage<AbilityProvideOauth2RspBo>> selectUserList(AbilityProvideOauth2ReqBo reqBo) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        StringBuilder order = new StringBuilder();
        if (reqBo.getSortName() != null) {
            order.append(reqBo.getSortName());
            if (reqBo.getSortOrder() != null) {
                order.append(" ");
                order.append(reqBo.getSortOrder());
            }
        } else {
            order.append("CREATED_TIME DESC");
        }
        Page page = PageMethod.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize(), (String)order.toString());
        AbilityProvideOauthPo po = (AbilityProvideOauthPo)BeanMapper.map((Object)reqBo, AbilityProvideOauthPo.class);
        List<AbilityProvideOauthPo> abilityProvideOauthPoList = this.abilityProvideOauthMapper.selectByAll(po);
        List rspList = BeanMapper.mapList(abilityProvideOauthPoList, AbilityProvideOauth2RspBo.class);
        rspList.forEach(abilityProvideOauth2RspBo -> {
            String token = "atp-" + abilityProvideOauth2RspBo.getClusterId() + "-" + abilityProvideOauth2RspBo.getAccessToken();
            if (ObjectUtils.isEmpty((Object)this.cacheClient.get(token))) {
                abilityProvideOauth2RspBo.setAccessTokenExpiresIn("\u5df2\u5931\u6548");
            } else {
                abilityProvideOauth2RspBo.setAccessTokenExpiresIn(this.cacheClient.getExpireTimeByKey(token) + "(\u79d2)");
            }
            abilityProvideOauth2RspBo.setAppCode(abilityProvideOauth2RspBo.getClientId());
            AppBO appBo = this.appApi.queryAppByAppCode(tenantId, abilityProvideOauth2RspBo.getClientId());
            abilityProvideOauth2RspBo.setAppId(appBo.getAppId());
        });
        RspPage rspPage = new RspPage(Integer.valueOf(reqBo.getPageSize()), Integer.valueOf(reqBo.getPageNo()), rspList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public Oauth2ModifyUserRspBo modifyUserPassword(Oauth2ModifyUserReqBo reqBo) {
        AbilityProvideOauthPo judgePo = this.checkAuthId(reqBo.getOauthId());
        String clientSecretReal = StringUtils.leftPad((String)StringUtils.left((String)(judgePo.getClientSecret() + judgePo.getClusterId() + judgePo.getUsername()), (int)16), (int)16, (String)"@");
        SM4 sm4 = SmUtil.sm4((byte[])clientSecretReal.getBytes(CharsetUtil.CHARSET_UTF_8));
        String password = sm4.encryptHex(reqBo.getOldPassword());
        if (!Objects.equals(password, judgePo.getPassword())) {
            throw new ZTBusinessException("\u5386\u53f2\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
        }
        password = sm4.encryptHex(reqBo.getNewPassword());
        AbilityProvideOauthPo modifyPo = new AbilityProvideOauthPo();
        modifyPo.setOauthId(reqBo.getOauthId());
        modifyPo.setPassword(password);
        this.abilityProvideOauthMapper.updateByPrimaryKeySelective(modifyPo);
        Oauth2ModifyUserRspBo rspBo = new Oauth2ModifyUserRspBo();
        rspBo.setSuccess(Boolean.TRUE);
        rspBo.setResultCode("0000");
        rspBo.setResultMessage("\u5bc6\u7801\u4fee\u6539\u6210\u529f");
        return rspBo;
    }

    @Override
    public RspBO<String> checkOut(Oauth2ModifyUserReqBo reqBo) {
        this.checkAuthId(reqBo.getOauthId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        AbilityProvideOauthPo modifyPo = new AbilityProvideOauthPo();
        modifyPo.setOauthId(reqBo.getOauthId());
        modifyPo.setStartSwitch(0);
        this.abilityProvideOauthMapper.updateByPrimaryKeySelective(modifyPo);
        modifyPo = this.abilityProvideOauthMapper.selectByAllOne(modifyPo);
        String token = "atp-" + modifyPo.getClusterId() + "-" + modifyPo.getAccessToken();
        this.cacheClient.delete(token);
        AppBO appBo = this.appApi.queryAppByAppCode(tenantId, modifyPo.getClientId());
        ArrayList<Long> appIds = new ArrayList<Long>();
        appIds.add(appBo.getAppId());
        RspBO updateAttendOutRsp = this.appApi.updateAttendOut(appIds);
        log.info("\u7528\u6237\u8ba2\u8d2d\u5e94\u7528\u7b7e\u9000 {}", (Object)updateAttendOutRsp);
        return RspBO.success((Object)"\u7b7e\u9000\u6210\u529f");
    }

    @Override
    public RspBO<String> checkIn(Oauth2ModifyUserReqBo reqBo) {
        this.checkAuthId(reqBo.getOauthId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        AbilityProvideOauthPo modifyPo = new AbilityProvideOauthPo();
        modifyPo.setOauthId(reqBo.getOauthId());
        modifyPo.setStartSwitch(1);
        this.abilityProvideOauthMapper.updateByPrimaryKeySelective(modifyPo);
        modifyPo = this.abilityProvideOauthMapper.selectByAllOne(modifyPo);
        AppBO appBo = this.appApi.queryAppByAppCode(tenantId, modifyPo.getClientId());
        ArrayList<Long> appIds = new ArrayList<Long>();
        appIds.add(appBo.getAppId());
        RspBO updateAttendOutRsp = this.appApi.updateAttendIn(appIds);
        log.info("\u7528\u6237\u8ba2\u8d2d\u5e94\u7528\u7b7e\u5230 {}", (Object)updateAttendOutRsp);
        return RspBO.success((Object)"\u7b7e\u5230\u6210\u529f");
    }

    @Override
    public RspBO<String> deleteUser(Oauth2ModifyUserReqBo reqBo) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        AbilityProvideOauthPo modifyPo = this.checkAuthId(reqBo.getOauthId());
        if (!Objects.equals(modifyPo.getStartSwitch(), 0)) {
            return RspBO.error((String)"\u975e\u7b7e\u9000\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        AppBO appBo = this.appApi.queryAppByAppCode(tenantId, modifyPo.getClientId());
        if (!ObjectUtils.isEmpty((Object)appBo)) {
            JSONObject qryAppSubscribeListReq = new JSONObject();
            qryAppSubscribeListReq.put("pageNo", (Object)1);
            qryAppSubscribeListReq.put("pageSize", (Object)Integer.MAX_VALUE);
            qryAppSubscribeListReq.put("appId", (Object)appBo.getAppId());
            List qryAppSubscribeListRspPage = this.appApi.qryAppSubscribeListPageByCond(qryAppSubscribeListReq);
            ArrayList deleteAppSubscribeList = new ArrayList();
            qryAppSubscribeListRspPage.forEach(qryAppSubscribeRspBo -> {
                JSONObject one = new JSONObject();
                one.put("abilityAppId", qryAppSubscribeRspBo.get((Object)"abilityAppId"));
                one.put("subscribeDeployId", qryAppSubscribeRspBo.get((Object)"subscribeDeployId"));
                deleteAppSubscribeList.add(one);
            });
            if (!CollectionUtils.isEmpty(deleteAppSubscribeList)) {
                RspBO rsp = this.appApi.deleteAppSubscribe(deleteAppSubscribeList);
                log.info("\u7528\u6237\u8ba2\u8d2d\u80fd\u529b\u9000\u8ba2 {}", (Object)rsp);
            }
            RspBO deleteAppRsp = this.appApi.deleteApp(appBo.getAppId());
            log.info("\u7528\u6237\u8ba2\u8d2d\u5e94\u7528\u5220\u9664 {}", (Object)deleteAppRsp);
        }
        this.abilityProvideOauthMapper.deleteByPrimaryKey(reqBo.getOauthId());
        return RspBO.success((Object)"\u5220\u9664\u7528\u6237\u6210\u529f");
    }

    private String createToken(String username, String secretKey, List<String> roles, long validityInMs) {
        Claims claims = Jwts.claims().setSubject(username);
        claims.put((Object)"roles", roles);
        Date now = new Date();
        Date validity = new Date(now.getTime() + validityInMs);
        return Jwts.builder().setClaims(claims).setIssuedAt(now).setExpiration(validity).signWith(SignatureAlgorithm.HS256, secretKey).compact();
    }

    private Boolean checkTime(RefreshTokenReqBo reqBo) {
        DateTime reqTime = DateUtil.parse((CharSequence)reqBo.getTimestamp());
        Date nowTime = new Date();
        long day = DateUtil.between((Date)reqTime, (Date)nowTime, (DateUnit)DateUnit.DAY);
        long minute = DateUtil.between((Date)reqTime, (Date)nowTime, (DateUnit)DateUnit.MINUTE) - day * 24L * 60L;
        return minute > (long)this.reqRefreshStandTime ? Boolean.FALSE : Boolean.TRUE;
    }

    private AbilityProvideOauthPo checkAuthId(String oauthId) {
        AbilityProvideOauthPo judgePo = new AbilityProvideOauthPo();
        judgePo.setOauthId(oauthId);
        judgePo = this.abilityProvideOauthMapper.selectByAllOne(judgePo);
        if (ObjectUtils.isEmpty((Object)judgePo)) {
            throw new ZTBusinessException("\u8d26\u53f7\u67e5\u8be2\u5f02\u5e38\uff01");
        }
        return judgePo;
    }
}

