/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.piscesplatform.config;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadDocxListener
extends AnalysisEventListener<Object> {
    private static final Logger log = LoggerFactory.getLogger(ReadDocxListener.class);
    private List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
    private List<Integer> indexList = new ArrayList<Integer>();
    private Map<String, Map<String, JSONObject>> abilityResult = new HashMap<String, Map<String, JSONObject>>();
    private JSONObject tempObject = new JSONObject();
    public static final String ORIGIN_FIELD = "originField";
    public static final String TARGET_FIELD = "targetField";
    public static final String DESCRIPTION = "description";
    public static final String TYPE = "type";
    public static final String NOT_NULL = "notNull";
    public static final String DEFAULT_VALUE = "defaultValue";
    public static final String PROPERTIES = "properties";
    public static final String ITEMS = "items";
    public static final String CLASS = "class";
    public static final String[] TYPE_LIST = new String[]{"Integer", "String", "BigDecimal", "Boolean", "Long", "Double", "Array"};

    public void invoke(Object object, AnalysisContext analysisContext) {
        this.dataList.add((Map<String, Object>)JSON.parseObject((String)JSON.toJSONString((Object)object), (Feature[])new Feature[]{Feature.OrderedField}));
    }

    public void extra(CellExtra extra, AnalysisContext context) {
        this.indexList.add(extra.getRowIndex());
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        this.indexList.sort(Comparator.comparing(Integer::intValue));
        int totalCount = 0;
        totalCount = this.indexList.isEmpty() ? this.dataList.size() : this.indexList.get(0) - 1;
        for (int rowIndex = 0; rowIndex < totalCount; ++rowIndex) {
            JSONObject fieldInfo = this.getFieldInfo(rowIndex);
            this.tempObject.put(this.dataList.get(rowIndex).get("1").toString(), (Object)fieldInfo);
        }
    }

    public JSONObject getFieldInfo(int rowIndex) {
        JSONObject fieldDetails = new JSONObject();
        String type = this.dataList.get(rowIndex).get("3").toString();
        if (Boolean.FALSE.equals(Arrays.asList(TYPE_LIST).contains(type))) {
            if (type.contains("List")) {
                type = type.substring(5, type.length() - 1);
                fieldDetails.put(TYPE, (Object)"Array");
                fieldDetails.put(ITEMS, (Object)this.getItems(type, rowIndex));
            } else {
                fieldDetails.put(TYPE, (Object)"Object");
                fieldDetails.put(PROPERTIES, (Object)this.getProperties(type));
            }
        } else {
            fieldDetails.put(TYPE, this.dataList.get(rowIndex).get("3"));
        }
        if (Boolean.FALSE.equals(fieldDetails.get((Object)TYPE).equals("Array"))) {
            fieldDetails.put(ORIGIN_FIELD, this.dataList.get(rowIndex).get("0"));
            fieldDetails.put(DESCRIPTION, this.dataList.get(rowIndex).get("2"));
            fieldDetails.put(NOT_NULL, (Object)"\u662f".equals(this.dataList.get(rowIndex).get("4")));
            fieldDetails.put(DEFAULT_VALUE, this.dataList.get(rowIndex).get("5"));
        }
        return fieldDetails;
    }

    public JSONObject getProperties(String parentType) {
        JSONObject jsonObject = new JSONObject();
        int indexListSize = this.indexList.size();
        for (int i = 0; i < indexListSize; ++i) {
            Map<String, Object> objectMap = this.dataList.get(this.indexList.get(i) - 1);
            if (!objectMap.get(0).equals(parentType)) continue;
            int startRow = this.indexList.get(i);
            int endRow = this.dataList.size();
            if (i + 1 != indexListSize) {
                endRow = this.indexList.get(i + 1) - 1;
            }
            while (startRow < endRow) {
                JSONObject fieldInfo = this.getFieldInfo(startRow);
                jsonObject.put(this.dataList.get(startRow).get(1).toString(), (Object)fieldInfo);
                ++startRow;
            }
        }
        return jsonObject;
    }

    public JSONObject getItems(String itemsType, int rowIndex) {
        JSONObject itemDetails = new JSONObject();
        if (Boolean.FALSE.equals(Arrays.asList(TYPE_LIST).contains(itemsType))) {
            itemDetails.put(TYPE, (Object)"Object");
            itemDetails.put(PROPERTIES, (Object)this.getProperties(itemsType));
        } else {
            itemDetails.put(TYPE, (Object)itemsType);
        }
        itemDetails.put(ORIGIN_FIELD, this.dataList.get(rowIndex).get("0"));
        itemDetails.put(DESCRIPTION, this.dataList.get(rowIndex).get("2"));
        itemDetails.put(NOT_NULL, (Object)"\u662f".equals(this.dataList.get(rowIndex).get("4")));
        itemDetails.put(DEFAULT_VALUE, this.dataList.get(rowIndex).get("5"));
        return itemDetails;
    }

    public void initResult() {
        this.abilityResult.put("req", new HashMap());
        this.abilityResult.put("rsp", new HashMap());
    }

    public Map<String, Map<String, JSONObject>> getDocxResult() {
        return this.abilityResult;
    }

    public void putObjectWithName(String name) {
        String[] split = name.split("-");
        String abilityEname = split[0];
        String reqOrRsp = split[1];
        JSONObject object = new JSONObject();
        object.put(TYPE, (Object)"object");
        object.put("title", (Object)(abilityEname + "\u80fd\u529b\u8be6\u7ec6\u4fe1\u606f"));
        object.put(ORIGIN_FIELD, null);
        object.put(PROPERTIES, (Object)JSON.parseObject((String)JSON.toJSONString((Object)this.tempObject), (Feature[])new Feature[]{Feature.OrderedField}));
        this.abilityResult.get(reqOrRsp).put(abilityEname, object);
        this.tempObject.clear();
        this.indexList.clear();
        this.dataList.clear();
    }
}

