/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.piscesplatform.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.model.baseEnum.BaseAttributes;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.util.GeneralUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class RuleToXmlUtil {
    private static final Logger log = LoggerFactory.getLogger(RuleToXmlUtil.class);
    public static final String TAG_REPLACE = "##";
    public static final String LIST_REPLACE = "**";
    public static final String RETURN_REPLACE = "&&";
    public static final String INTERFACE_TEMPLATE = BaseTags.TAG_INTERFACE.getTemplate();
    public static final String VALUATION_TEMPLATE = BaseTags.TAG_VALUATION.getTemplate();
    public static final String VARIABLE_TEMPLATE = BaseTags.TAG_VARIABLE.getTemplate();
    public static final String IF_TEMPLATE = BaseTags.TAG_IF.getTemplate();
    public static final String FOR_TEMPLATE = BaseTags.TAG_FOR.getTemplate();
    public static final String CLASS_TEMPLATE = BaseTags.TAG_CLASS.getTemplate();
    public static final String PARAM_TEMPLATE = BaseTags.TAG_PARAM.getTemplate();
    public static final String PRINT_TEMPLATE = BaseTags.TAG_PRINT.getTemplate();
    public static final String ROOT_PATH = "$.system.variable.";
    public static final String REQ_PATH = "$.system.variable.reqText.";
    public static final String TARGET_REQ_PATH = "$.system.variable.targetReqText.";
    public static final String CHILD_RETURN_PATH = "$.system.variable.defaultReturn.";
    public static String listName;
    public static Map<String, String> originListNameMap;

    public static String ruleToXmlUtil(String docx, String rule) {
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)docx)) && Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)rule))) {
            return null;
        }
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)docx))) {
            return RuleToXmlUtil.formatXml(INTERFACE_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(rule)), 4, false);
        }
        try {
            listName = "I";
            StringBuilder xml = new StringBuilder();
            JSONObject docxJson = JSON.parseObject((String)docx, (Feature[])new Feature[]{Feature.OrderedField});
            int abilityCount = 0;
            for (Map.Entry abilityJson : docxJson.entrySet()) {
                String abilityEname = (String)abilityJson.getKey();
                String abilityXml = RuleToXmlUtil.getPropertiesXml((JSONObject)JSON.toJSON((Object)((JSONObject)JSON.toJSON(abilityJson.getValue())).get((Object)"properties")), TARGET_REQ_PATH + abilityEname);
                if (abilityXml != null) {
                    xml.append(abilityXml);
                }
                if (docxJson.size() != ++abilityCount) {
                    xml.append(RuleToXmlUtil.getInvokeXml(abilityEname));
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)rule)) {
                    xml.append(rule);
                }
                xml.append(RuleToXmlUtil.getValuationXml(RETURN_REPLACE + abilityEname, "String", REQ_PATH.substring(0, REQ_PATH.length() - 1)));
            }
            xml = new StringBuilder(INTERFACE_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(xml.toString())));
            return RuleToXmlUtil.formatXml(xml.toString(), 4, false);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public static String getJSONObjectXml(JSONObject jsonObject, String parentField) {
        StringBuilder xml = new StringBuilder();
        Map<String, String> properties = RuleToXmlUtil.getProperties(jsonObject);
        if ("JSONArray".equals(properties.get("type"))) {
            String itemsXml = RuleToXmlUtil.getItemsXml(JSON.parseObject((String)properties.get("items")), parentField);
            if (itemsXml != null) {
                xml.append(itemsXml);
            }
            return xml.toString();
        }
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)properties.get("defaultValue")) || StringUtils.isNotBlank((CharSequence)properties.get("originField")) || StringUtils.isNotBlank((CharSequence)properties.get("properties")) || StringUtils.isNotBlank((CharSequence)properties.get("class")))) {
            return null;
        }
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)properties.get("type")))) {
            throw new ZTBusinessException("\u6709\u5b57\u6bb5type\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7ed3\u6784!");
        }
        if (properties.get("description") != null) {
            xml.append(RuleToXmlUtil.getDescriptionXml(properties.get("description")));
        }
        if (properties.get("defaultValue") != null) {
            xml.append(RuleToXmlUtil.getDefaultValueXml(properties.get("defaultValue"), properties.get("type"), parentField));
        }
        if (StringUtils.isNotBlank((CharSequence)properties.get("class"))) {
            xml.append(RuleToXmlUtil.getClassXml(properties.get("class"), properties.get("type"), parentField));
            if (properties.get("notNull") != null && "true".equals(properties.get("notNull"))) {
                xml.append(RuleToXmlUtil.getNotNullXml(parentField));
            }
            return xml.toString();
        }
        if (StringUtils.isNotBlank((CharSequence)properties.get("originField"))) {
            xml.append(RuleToXmlUtil.getValuationXml(properties.get("originField"), properties.get("type"), parentField));
            if (properties.get("notNull") != null && "true".equals(properties.get("notNull"))) {
                xml.append(RuleToXmlUtil.getNotNullXml(parentField));
            }
            return xml.toString();
        }
        if ("JSONObject".equals(properties.get("type"))) {
            if (StringUtils.isNotBlank((CharSequence)properties.get("properties"))) {
                String propertiesXml = RuleToXmlUtil.getPropertiesXml(JSON.parseObject((String)properties.get("properties"), (Feature[])new Feature[]{Feature.OrderedField}), parentField);
                if (propertiesXml != null) {
                    xml.append(propertiesXml);
                }
            } else {
                log.warn(parentField + "\u76ee\u6807\u5b57\u6bb5\u7684\u5b69\u5b50\u8282\u70b9\u6570\u636e\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f");
            }
        }
        if (properties.get("notNull") != null && "true".equals(properties.get("notNull"))) {
            xml.append(RuleToXmlUtil.getNotNullXml(parentField));
        }
        return xml.toString();
    }

    public static String getPropertiesXml(JSONObject jsonObject, String parentField) {
        StringBuilder xml = new StringBuilder();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String jsonObjectXml = RuleToXmlUtil.getJSONObjectXml((JSONObject)JSON.toJSON(value), parentField + "." + key);
            if (jsonObjectXml == null) continue;
            xml.append(jsonObjectXml);
        }
        return xml.toString();
    }

    public static String getItemsXml(JSONObject jsonObject, String parentField) {
        StringBuilder xml = new StringBuilder();
        String tempListName = listName;
        Map<String, String> properties = RuleToXmlUtil.getProperties(jsonObject);
        if (StringUtils.isNotBlank((CharSequence)properties.get("originField")) && "JSONObject".equals(properties.get("type")) && StringUtils.isNotBlank((CharSequence)properties.get("properties"))) {
            String[] originFields = properties.get("originField").split("\\.");
            originListNameMap.put(originFields[originFields.length - 1] + "[**]", tempListName);
        }
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)properties.get("defaultValue")) || StringUtils.isNotBlank((CharSequence)properties.get("properties")))) {
            return null;
        }
        if (properties.get("description") != null) {
            xml.append(RuleToXmlUtil.getDescriptionXml(properties.get("description")));
        }
        if (properties.get("defaultValue") != null) {
            if ("JSONObject".equals(properties.get("type"))) {
                xml.append(RuleToXmlUtil.getDefaultValueXml(properties.get("defaultValue"), properties.get("type"), parentField));
            } else {
                String[] defaultListValue = properties.get("defaultValue").split(",");
                String defaultListType = properties.get("type");
                ArrayList<Object> defaultList = new ArrayList<Object>();
                for (String s : defaultListValue) {
                    Object objectByType = GeneralUtils.getObjectByType((String)defaultListType, (Object)s);
                    defaultList.add(objectByType);
                }
                xml.append(RuleToXmlUtil.getDefaultValueXml(((Object)defaultList).toString(), "JSONArray", parentField));
            }
        }
        listName = listName + "I";
        if (StringUtils.isNotBlank((CharSequence)properties.get("properties"))) {
            String propertiesXml = RuleToXmlUtil.getPropertiesXml(JSON.parseObject((String)properties.get("properties"), (Feature[])new Feature[]{Feature.OrderedField}), parentField + "[*" + tempListName + "*]");
            if (StringUtils.isNotBlank((CharSequence)propertiesXml)) {
                String stopCountField = properties.get("originField");
                stopCountField = ObjectUtils.isEmpty((Object)stopCountField) ? "1" : (stopCountField.contains(TAG_REPLACE) ? RuleToXmlUtil.arrayItemConversion(CHILD_RETURN_PATH + stopCountField.substring(2) + ".length()") : RuleToXmlUtil.arrayItemConversion(REQ_PATH + stopCountField + ".length()"));
                String forXml = FOR_TEMPLATE.replaceFirst(TAG_REPLACE, "0");
                forXml = forXml.replaceFirst(TAG_REPLACE, "&lt;");
                forXml = forXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(stopCountField));
                forXml = forXml.replaceFirst(TAG_REPLACE, "++");
                forXml = forXml.replaceFirst(TAG_REPLACE, tempListName);
                forXml = forXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(propertiesXml));
                xml.append(forXml);
            } else if (properties.get("originField") != null) {
                xml.append(RuleToXmlUtil.getValuationXml(properties.get("originField"), "JSONArray", parentField));
            } else if (properties.get("defaultValue") == null) {
                log.warn(parentField + "\u76ee\u6807\u5b57\u6bb5\u4e2d\uff0c\u6ca1\u6709\u6e90\u5b57\u6bb5\u548c\u9ed8\u8ba4\u503c\u7684\u4fe1\u606f");
            }
        }
        if (properties.get("notNull") != null && "true".equals(properties.get("notNull"))) {
            xml.append(RuleToXmlUtil.getNotNullXml(parentField));
        }
        return xml.toString();
    }

    public static Map<String, String> getProperties(JSONObject jsonObject) {
        HashMap<String, String> properties = new HashMap<String, String>(7);
        block10: for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            switch (key) {
                case "type": {
                    if ("Object".equals(value.toString())) {
                        properties.put("type", "JSONObject");
                        continue block10;
                    }
                    if ("Array".equals(value.toString())) {
                        properties.put("type", "JSONArray");
                        continue block10;
                    }
                    properties.put("type", value.toString());
                    continue block10;
                }
                case "class": 
                case "properties": 
                case "items": {
                    properties.put(key, JSON.toJSONString(value));
                    continue block10;
                }
            }
            properties.put(key, value.toString());
        }
        return properties;
    }

    public static String getInvokeXml(String abilityEname) {
        String invokeJsonString = "{\"method\":\"Ability.invoke(msgContext, svcName, version, reqData, inputProtocol)\",\"param\":[{\"type\":\"Object\",\"originField\":\"$.system.base\"},{\"type\":\"String\",\"defaultValue\":\"" + abilityEname + "\"},{\"type\":\"String\",\"defaultValue\":\"v1\"},{\"type\":\"String\",\"originField\":\"" + TARGET_REQ_PATH + abilityEname + "\"}]}";
        String returnType = "JSONObject";
        String returnField = CHILD_RETURN_PATH + abilityEname;
        return RuleToXmlUtil.getClassXml(invokeJsonString, returnType, returnField);
    }

    public static String getDescriptionXml(String description) {
        return "<!-- " + description + " -->";
    }

    public static String getDefaultValueXml(String defaultValue, String type, String parentField) {
        defaultValue = defaultValue.replace("\"", "&quot;");
        String defaultValueXml = VALUATION_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(parentField));
        defaultValueXml = defaultValueXml.replaceFirst(TAG_REPLACE, type);
        defaultValueXml = defaultValueXml.replaceFirst(TAG_REPLACE, defaultValue);
        return defaultValueXml;
    }

    public static String getValuationXml(String originField, String type, String parentField) {
        String inPath = RuleToXmlUtil.conversionOriginFiled(originField);
        String valuationXml = VALUATION_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(parentField));
        valuationXml = valuationXml.replaceFirst(TAG_REPLACE, type);
        valuationXml = valuationXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(inPath));
        return valuationXml;
    }

    public static String conversionOriginFiled(String originField) {
        if ((originField = RuleToXmlUtil.arrayItemConversion(originField)).contains(RETURN_REPLACE)) {
            originField = originField.replace(RETURN_REPLACE, TARGET_REQ_PATH);
        } else if (originField.contains(TAG_REPLACE)) {
            originField = CHILD_RETURN_PATH + originField.substring(2);
        } else if (originField.length() != 0) {
            originField = REQ_PATH + originField;
        }
        return originField;
    }

    public static String arrayItemConversion(String originField) {
        if (originField.contains(LIST_REPLACE)) {
            String[] originFields = originField.split("\\.");
            originField = "";
            for (String field : originFields) {
                String listName = originListNameMap.get(field);
                originField = originField + field.replace(LIST_REPLACE, "*" + listName + "*");
                originField = originField + ".";
            }
            if (originField.endsWith(".")) {
                originField = originField.substring(0, originField.length() - 1);
            }
        }
        return originField;
    }

    public static String getNotNullXml(String parentField) {
        String printXml = PRINT_TEMPLATE.replaceFirst(TAG_REPLACE, "");
        printXml = printXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(parentField + "\u76ee\u6807\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u62a5\u6587"));
        String ifXml = IF_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(parentField));
        ifXml = ifXml.replaceFirst(TAG_REPLACE, "==");
        ifXml = ifXml.replaceFirst(TAG_REPLACE, "null");
        ifXml = ifXml.replaceFirst(TAG_REPLACE, "null");
        ifXml = ifXml.replaceFirst(TAG_REPLACE, "");
        ifXml = ifXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(printXml));
        return ifXml;
    }

    public static String getClassXml(String classString, String type, String returnField) {
        JSONObject classObject = JSON.parseObject((String)classString);
        String inPath = "";
        if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)classObject.get((Object)BaseAttributes.ATTRIBUTE_INPATH.getCode())))) {
            inPath = RuleToXmlUtil.conversionOriginFiled(classObject.get((Object)BaseAttributes.ATTRIBUTE_INPATH.getCode()).toString());
        }
        String method = classObject.get((Object)BaseAttributes.ATTRIBUTE_METHOD.getCode()).toString();
        JSONArray params = (JSONArray)classObject.get((Object)BaseTags.TAG_PARAM.getCode().toLowerCase());
        String[] paramAndValuation = BaseMethods.getWithCode((String)method).getTemplate().split(",");
        String[] paramCounts = paramAndValuation[0].split(":");
        boolean checkParamCount = Boolean.FALSE;
        for (String paramCount : paramCounts) {
            if (!paramCount.equals(params.size() + "")) continue;
            checkParamCount = Boolean.TRUE;
        }
        if (Boolean.FALSE.equals(checkParamCount)) {
            throw new ZTBusinessException("\u6267\u884c\u65b9\u6cd5" + method + "\u7684\u65f6\u5019\uff0c\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String valuationCount = paramAndValuation[1];
        String classXml = CLASS_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(inPath));
        classXml = classXml.replaceFirst(TAG_REPLACE, method);
        String methodXml = "";
        for (Object param : params) {
            JSONObject paramMap = (JSONObject)param;
            String paramXml = "";
            if (ObjectUtils.isEmpty((Object)paramMap.get((Object)"originField")) && Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)paramMap.get((Object)"defaultValue")))) {
                paramXml = PARAM_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(paramMap.get((Object)"defaultValue").toString()));
            } else if (ObjectUtils.isEmpty((Object)paramMap.get((Object)"defaultValue")) && Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)paramMap.get((Object)"originField")))) {
                paramXml = PARAM_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(paramMap.get((Object)"originField").toString()));
            } else {
                throw new ZTBusinessException(method + "\u65b9\u6cd5\u4e2d\u6ca1\u6307\u5b9a\u5165\u53c2");
            }
            paramXml = paramXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(paramMap.get((Object)"type").toString()));
            methodXml = methodXml + paramXml;
        }
        if (Boolean.FALSE.equals("0".equals(valuationCount))) {
            methodXml = methodXml + RuleToXmlUtil.getValuationXml("", type, returnField);
        }
        classXml = classXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(methodXml));
        return classXml;
    }

    public static String formatXml(String xmlString, int indent, boolean ignoreDeclaration) {
        try {
            InputSource src = new InputSource(new StringReader(xmlString));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", ignoreDeclaration ? "yes" : "no");
            transformer.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u683c\u5f0f\u5316xml\u51fa\u9519:\n" + xmlString);
        }
    }

    static {
        originListNameMap = new HashMap<String, String>();
    }
}

