/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.piscesplatform.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.piscesplatform.config.ReadDocxListener;
import com.ohaotian.piscesplatform.mapper.AbilityInterfaceTaskMapper;
import com.ohaotian.piscesplatform.mapper.AbilityInterfaceTaskVersionBindMapper;
import com.ohaotian.piscesplatform.mapper.AbilityInterfaceTaskVersionMapper;
import com.ohaotian.piscesplatform.model.bo.AbilityInterfaceTaskVersionReqBo;
import com.ohaotian.piscesplatform.model.bo.AbilityInterfaceTaskVersionRspBo;
import com.ohaotian.piscesplatform.model.bo.EnumRspBo;
import com.ohaotian.piscesplatform.model.bo.ImportDocxReqBo;
import com.ohaotian.piscesplatform.model.bo.InsertTaskReqBo;
import com.ohaotian.piscesplatform.model.po.AbilityInterfaceTaskPo;
import com.ohaotian.piscesplatform.model.po.AbilityInterfaceTaskVersionBindPo;
import com.ohaotian.piscesplatform.model.po.AbilityInterfaceTaskVersionPo;
import com.ohaotian.piscesplatform.service.AbilityInterfaceTaskVersionService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AbilityInterfaceTaskVersionServiceImpl
implements AbilityInterfaceTaskVersionService {
    @Resource
    private AbilityInterfaceTaskVersionMapper abilityInterfaceTaskVersionMapper;
    @Resource
    private AbilityInterfaceTaskMapper abilityInterfaceTaskMapper;
    @Resource
    private AbilityInterfaceTaskVersionBindMapper abilityInterfaceTaskVersionBindMapper;

    @Override
    public RspBO<InsertTaskReqBo> queryByTaskVersionId(Long taskVersionId) {
        AbilityInterfaceTaskVersionPo queryByTaskVersionInfo = this.abilityInterfaceTaskVersionMapper.queryByTaskVersionId(taskVersionId);
        if (ObjectUtils.isEmpty((Object)queryByTaskVersionInfo)) {
            throw new ZTBusinessException("\u8f93\u5165\u7684\u4efb\u52a1\u7248\u672cid\u6ca1\u6709\u6570\u636e\uff01");
        }
        AbilityInterfaceTaskPo abilityInterfaceTaskPo = new AbilityInterfaceTaskPo();
        abilityInterfaceTaskPo.setTaskId(queryByTaskVersionInfo.getTaskId());
        AbilityInterfaceTaskPo taskPo = this.abilityInterfaceTaskMapper.queryByTaskInfo(abilityInterfaceTaskPo);
        InsertTaskReqBo taskRspBo = (InsertTaskReqBo)BeanMapper.map((Object)taskPo, InsertTaskReqBo.class);
        taskRspBo.setTaskVersionInfo((AbilityInterfaceTaskVersionReqBo)BeanMapper.map((Object)queryByTaskVersionInfo, AbilityInterfaceTaskVersionReqBo.class));
        AbilityInterfaceTaskVersionBindPo taskVersionBindPo = new AbilityInterfaceTaskVersionBindPo();
        taskVersionBindPo.setTaskVersionId(queryByTaskVersionInfo.getTaskVersionId());
        List<AbilityInterfaceTaskVersionBindPo> taskVersionBindPoList = this.abilityInterfaceTaskVersionBindMapper.queryByCond(taskVersionBindPo);
        List<Long> abilityList = taskVersionBindPoList.stream().map(AbilityInterfaceTaskVersionBindPo::getAbilityId).collect(Collectors.toList());
        taskRspBo.getTaskVersionInfo().setAbilityIdList(abilityList);
        return RspBO.success((Object)taskRspBo);
    }

    @Override
    public RspBO<RspPage<List<AbilityInterfaceTaskVersionRspBo>>> queryByCond(AbilityInterfaceTaskVersionReqBo abilityInterfaceTaskVersionReqBo) {
        Page page = PageMethod.startPage((int)abilityInterfaceTaskVersionReqBo.getPageNo(), (int)abilityInterfaceTaskVersionReqBo.getPageSize());
        List<AbilityInterfaceTaskVersionPo> abilityInterfaceTaskVersionPoList = this.abilityInterfaceTaskVersionMapper.queryByCond(abilityInterfaceTaskVersionReqBo.getTaskId());
        List abilityInterfaceTaskVersionRspBoList = abilityInterfaceTaskVersionPoList.stream().map(rspBo -> (AbilityInterfaceTaskVersionRspBo)BeanMapper.map((Object)rspBo, AbilityInterfaceTaskVersionRspBo.class)).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(abilityInterfaceTaskVersionReqBo.getPageSize()), Integer.valueOf(abilityInterfaceTaskVersionReqBo.getPageNo()), abilityInterfaceTaskVersionRspBoList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    @Transactional
    public RspBO<Integer> insert(AbilityInterfaceTaskVersionReqBo abilityInterfaceTaskVersionReqBo) {
        AbilityInterfaceTaskVersionPo abilityInterfaceTaskVersionPo = (AbilityInterfaceTaskVersionPo)BeanMapper.map((Object)abilityInterfaceTaskVersionReqBo, AbilityInterfaceTaskVersionPo.class);
        return RspBO.success((Object)this.abilityInterfaceTaskVersionMapper.insert(abilityInterfaceTaskVersionPo));
    }

    @Override
    @Transactional
    public RspBO<String> update(Long taskVersionId) {
        AbilityInterfaceTaskVersionPo taskVersionPo = this.abilityInterfaceTaskVersionMapper.queryByTaskVersionId(taskVersionId);
        AbilityInterfaceTaskVersionPo updateTaskVersionPo = new AbilityInterfaceTaskVersionPo();
        updateTaskVersionPo.setTaskId(taskVersionPo.getTaskId());
        updateTaskVersionPo.setStatus(0);
        this.abilityInterfaceTaskVersionMapper.updateWithTaskId(updateTaskVersionPo);
        taskVersionPo.setStatus(1);
        this.abilityInterfaceTaskVersionMapper.update(taskVersionPo);
        return RspBO.success((Object)"\u66f4\u65b0\u7248\u672c\u72b6\u6001\u6210\u529f\uff01");
    }

    @Override
    @Transactional
    public RspBO<String> deleteByTaskVersionId(Long taskVersionId) {
        int abilityCount = this.abilityInterfaceTaskVersionBindMapper.deleteByTaskVersionId(taskVersionId);
        this.abilityInterfaceTaskVersionMapper.deleteByTaskVersionId(taskVersionId);
        return RspBO.success((Object)("\u5220\u9664\u5f53\u524d\u7248\u672c\u6210\u529f\uff0c\u5171\u5220\u9664" + abilityCount + "\u4e2a\u5b50\u80fd\u529b\uff01"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RspBO importDocx(ImportDocxReqBo importDocxReqBo) {
        ValidBatchUtils.isNotEmpty((Object)importDocxReqBo, (String[])new String[]{"file"});
        MultipartFile excel = importDocxReqBo.getFile();
        String filename = excel.getOriginalFilename();
        if (filename == null) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e3a\u7a7a\uff01");
        }
        if (!filename.toLowerCase().endsWith(".xls") && !filename.toLowerCase().endsWith(".xlsx")) {
            throw new ZTBusinessException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01");
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(excel.getInputStream());){
            ReadDocxListener docxListener = new ReadDocxListener();
            ExcelReader excelReader = EasyExcel.read((InputStream)inputStream, (ReadListener)docxListener).extraRead(CellExtraTypeEnum.MERGE).build();
            docxListener.initResult();
            List readSheetList = excelReader.excelExecutor().sheetList();
            for (ReadSheet readSheet : readSheetList) {
                excelReader.read(new ReadSheet[]{readSheet});
                docxListener.putObjectWithName(readSheet.getSheetName());
            }
            excelReader.finish();
            JSONObject resultObject = JSON.parseObject((String)JSON.toJSONString(docxListener.getDocxResult()));
            for (Map.Entry entry : resultObject.entrySet()) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(entry.getValue()));
                for (Map.Entry abilityEntry : jsonObject.entrySet()) {
                    JSONObject abilityObject = JSON.parseObject((String)JSON.toJSONString(abilityEntry.getValue()));
                    abilityObject.put("abilityId", (Object)this.abilityInterfaceTaskVersionMapper.getAbilityIdByAbilityEname((String)abilityEntry.getKey()));
                    jsonObject.put((String)abilityEntry.getKey(), (Object)abilityObject);
                }
                resultObject.put((String)entry.getKey(), (Object)jsonObject);
            }
            RspBO rspBO = RspBO.success((Object)resultObject);
            return rspBO;
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25\uff01");
        }
    }

    @Override
    public RspBO getType() {
        ArrayList<EnumRspBo> docxTypeList = new ArrayList<EnumRspBo>();
        for (String s : ReadDocxListener.TYPE_LIST) {
            EnumRspBo type = new EnumRspBo();
            type.setLabel(s.toUpperCase());
            type.setValue(s);
            docxTypeList.add(type);
        }
        EnumRspBo object = new EnumRspBo();
        object.setLabel("OBJECT");
        object.setValue("Object");
        docxTypeList.add(object);
        ArrayList<EnumRspBo> advancedTypeList = new ArrayList<EnumRspBo>();
        for (BaseObjects baseObject : EnumSet.allOf(BaseObjects.class)) {
            advancedTypeList.add(EnumRspBo.builder().value(baseObject.getCode()).label(baseObject.getLabel()).build());
        }
        HashMap<String, ArrayList<EnumRspBo>> resultMap = new HashMap<String, ArrayList<EnumRspBo>>();
        resultMap.put("docxTypeList", docxTypeList);
        resultMap.put("advancedTypeList", advancedTypeList);
        return RspBO.success(resultMap);
    }
}

