/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.piscesplatform.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.piscesplatform.util.RuleToXmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.Test;

public class AdvancedJsonToXmlUtil {
    public static String advancedJsonToXml(String jsonString) {
        JSONArray jsonArray = JSON.parseArray((String)jsonString);
        String xml = AdvancedJsonToXmlUtil.getChildXmlWithArray(jsonArray);
        xml = "<INTERFACE>" + xml + "</INTERFACE>";
        return RuleToXmlUtil.formatXml(xml, 4, false);
    }

    public static String getChildXmlWithArray(JSONArray jsonArray) {
        String xml = "";
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String tag = jsonObject.get((Object)"tag").toString();
            String tagXml = "<" + tag + " ";
            String childXml = "";
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                if ("tag".equals(key) || "id".equals(key) || "label".equals(key) || "disabled".equals(key)) continue;
                Object value = entry.getValue();
                if ("child".equals(key)) {
                    childXml = AdvancedJsonToXmlUtil.getChildXmlWithArray((JSONArray)value);
                    continue;
                }
                tagXml = tagXml + key + "=\"" + AdvancedJsonToXmlUtil.getConvertValue(value.toString()) + "\" ";
            }
            tagXml = tagXml + ">" + childXml + "</" + tag + ">";
            xml = xml + tagXml;
        }
        return xml;
    }

    public static String getConvertValue(String value) {
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("'", "&apo;");
        value = value.replaceAll("\"", "&quot;");
        return value;
    }

    @Test
    public void test() throws IOException {
        File file = new File("E:\\Tydic\\Git\\Ability\\ability-base\\ability-admin-plugin\\admin-pisces-platform\\src\\main\\java\\com\\ohaotian\\piscesplatform\\util\\testAdvanced.xml");
        String s = FileUtils.readFileToString((File)file, (String)"UTF-8");
        String s1 = AdvancedJsonToXmlUtil.advancedJsonToXml(s);
        System.out.println();
        System.out.println(s1);
        File writeFile = new File("E:\\Tydic\\Git\\Ability\\ability-base\\ability-admin-plugin\\admin-pisces-platform\\src\\main\\java\\com\\ohaotian\\piscesplatform\\util\\testAdvanced.json");
        FileOutputStream fos = new FileOutputStream(writeFile, false);
        fos.write(s1.getBytes());
        fos.close();
    }
}

