/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.enums.PriorityEnum;
import com.ohaotian.plugin.mapper.PluginPriorityMapper;
import com.ohaotian.plugin.model.bo.PluginPriorityBO;
import com.ohaotian.plugin.model.po.PluginPriorityPO;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.enums.StepEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.AbilityPluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.QryPluginJsonService;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
@PluginTypeHandlerType(value="priority", position=ExtensionPointPositionEnum.ABILITY_POSITION)
public class PriorityPluginHandler
extends AbstractPluginHandler<Object> {
    private static final Logger log = LogManager.getLogger(PriorityPluginHandler.class);
    private static final String URL = "/ability/updatePluginPriority";
    private static final String TITLE = "\u4f18\u5148\u7ea7\u7ed1\u5b9a\u5173\u7cfb\u6269\u5c55\u4fe1\u606f";
    private static final String COMPONENT_TYPE = "plugin-binding-priority";
    @Resource
    private QryPluginJsonService qryPluginJsonService;
    @Resource
    private PluginPriorityMapper pluginPriorityMapper;
    @Resource
    private AuthorityService authorityService;
    @Value(value="classpath:static/data/ability-plugin-priority.json")
    private org.springframework.core.io.Resource priorityJson;

    public RspBO handleAdd(Object object) throws ZTBusinessException {
        Long userId = Long.valueOf(UserHolder.getUserId());
        try {
            log.debug("PriorityPluginHandler.handleAdd\uff1a" + object);
            Map objectMap = (Map)object;
            String abilityPluginDeployId = objectMap.get("abilityPluginDeployId") + "";
            PluginPriorityPO pluginPriorityPO = new PluginPriorityPO();
            pluginPriorityPO.setAbilityPluginDeployId(Long.valueOf(abilityPluginDeployId));
            pluginPriorityPO.setPriority(PriorityEnum.PRIORITY_LOW.getCode());
            pluginPriorityPO.setCreateTime(new Date());
            pluginPriorityPO.setUpdateTime(new Date());
            pluginPriorityPO.setCreateUserId(userId);
            pluginPriorityPO.setUpdateUserId(userId);
            this.pluginPriorityMapper.insertSelective(pluginPriorityPO);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO handleModify(Object object) throws ZTBusinessException {
        Long userId = Long.valueOf(UserHolder.getUserId());
        try {
            log.debug("PriorityPluginHandler.handleModify\uff1a" + object);
            PluginPriorityBO pluginPriorityBO = (PluginPriorityBO)object;
            ValidBatchUtils.isNotEmpty((Object)pluginPriorityBO, (String[])new String[]{"priority", "abilityPluginDeployIds"});
            for (Long abilityPluginDeployId : pluginPriorityBO.getAbilityPluginDeployIds()) {
                PluginPriorityPO pluginPriorityPO = (PluginPriorityPO)BeanMapper.map((Object)pluginPriorityBO, PluginPriorityPO.class);
                pluginPriorityPO.setAbilityPluginDeployId(abilityPluginDeployId);
                pluginPriorityPO.setUpdateTime(new Date());
                pluginPriorityPO.setUpdateUserId(userId);
                this.pluginPriorityMapper.updatePluginPriorityByAbilityPluginDeployId(pluginPriorityPO);
            }
            return RspBO.success((Object)new AbilityPluginRspBO(StepEnum.END.getCode()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleDelete(Object object) throws ZTBusinessException {
        try {
            Long abilityPluginDeployId = (Long)object;
            this.pluginPriorityMapper.deletePriorityByPluginDeployId(abilityPluginDeployId);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        log.debug("\u67e5\u8be2\u80fd\u529b\u4f18\u5148\u7ea7\u63d2\u4ef6\u4fe1\u606f");
        String template = this.qryPluginJsonService.getAbilityPlugin(abilityPluginReqBO, this.priorityJson);
        HashMap jsonMap = Maps.newHashMap();
        jsonMap.put("pluginName", abilityPluginReqBO.getPluginName());
        jsonMap.put("abilityName", abilityPluginReqBO.getAbilityName());
        if (!StringUtils.isEmpty((Object)abilityPluginReqBO.getAbilityPluginDeployId())) {
            PluginPriorityPO pluginPriorityPO = new PluginPriorityPO();
            pluginPriorityPO.setAbilityPluginDeployId(abilityPluginReqBO.getAbilityPluginDeployId());
            PluginPriorityPO pluginPriorityPO1 = this.pluginPriorityMapper.queryLimitOne(pluginPriorityPO);
            jsonMap.put("priority", pluginPriorityPO1.getPriority() + "");
            ArrayList list = Lists.newArrayList();
            list.add(abilityPluginReqBO.getAbilityPluginDeployId());
            abilityPluginReqBO.setAbilityPluginDeployIds((List)list);
        } else {
            jsonMap.put("priority", "");
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("abilityPluginDeployIds", abilityPluginReqBO.getAbilityPluginDeployIds());
        return RspBO.success((Object)new AbilityPluginRspBO(TITLE, StepEnum.NEXT.getCode(), URL, (Map)paramMap, (Map)jsonMap, COMPONENT_TYPE));
    }
}

