/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.google.common.collect.Maps;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.PluginRouteExtMapper;
import com.ohaotian.plugin.mapper.PluginRouteMapper;
import com.ohaotian.plugin.model.bo.req.PluginRouteExtBO;
import com.ohaotian.plugin.model.po.PluginRouteExtPO;
import com.ohaotian.plugin.model.po.PluginRoutePO;
import com.ohaotian.plugin.service.PluginRouteService;
import com.ohaotian.plugin.service.RoutePluginHandler;
import com.ohaotian.portalcommon.enums.StepEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.AbilityPluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.QryPluginJsonService;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PluginRouteServiceImpl
implements PluginRouteService {
    private static final Logger log = LogManager.getLogger(RoutePluginHandler.class);
    private static final String URL = "/ability/updatePluginRouteExt";
    private static final String TITLE = "\u8def\u7531\u6269\u5c55\u4fe1\u606f";
    private static final String STEP_TWO = "plugin-binding-route-step-two";
    @Resource
    private QryPluginJsonService qryPluginJsonService;
    @Value(value="classpath:static/data/ability-plugin-route-ext.json")
    private org.springframework.core.io.Resource routeJson;
    @Resource
    PluginRouteMapper pluginRouteMapper;
    @Resource
    PluginRouteExtMapper pluginRouteExtMapper;

    @Override
    public Long insertSelective(PluginRoutePO entity) {
        return this.pluginRouteMapper.insertSelective(entity);
    }

    @Override
    public int insertRecords(List<PluginRoutePO> records) {
        return this.pluginRouteMapper.insertRecords(records);
    }

    @Override
    public PluginRoutePO queryLimitOne(PluginRoutePO entity) {
        return this.pluginRouteMapper.queryLimitOne(entity);
    }

    @Override
    public List<PluginRoutePO> queryByRouteIds(List<Long> routeIds) {
        return this.pluginRouteMapper.queryByRouteIds(routeIds);
    }

    @Override
    public List<PluginRoutePO> queryByCond(PluginRoutePO entity) {
        return this.pluginRouteMapper.queryByCond(entity);
    }

    @Override
    public PluginRoutePO queryByRouteId(Long routeId) {
        return this.pluginRouteMapper.queryByRouteId(routeId);
    }

    @Override
    public int updatePluginRouteByRouteId(PluginRoutePO entity) {
        return this.pluginRouteMapper.updatePluginRouteByRouteId(entity);
    }

    @Override
    public int deletePluginRouteByRouteId(Long routeId) {
        return this.pluginRouteMapper.deletePluginRouteByRouteId(routeId);
    }

    @Override
    public int deletePluginRouteByIds(List<Long> routeIds) {
        return this.pluginRouteMapper.deletePluginRouteByIds(routeIds);
    }

    @Override
    public int deletePluginRouteByPluginId(Long pluginId) {
        return this.pluginRouteMapper.deletePluginRouteByPluginId(pluginId);
    }

    @Override
    public RspBO qryAbilityRouteExtPlugin(AbilityPluginReqBO abilityPluginReqBO) {
        log.debug("PluginRouteServiceImpl.qryAbilityRouteExtPlugin\uff1a" + abilityPluginReqBO);
        String template = this.qryPluginJsonService.getAbilityPlugin(abilityPluginReqBO, this.routeJson);
        HashMap jsonMap = Maps.newHashMap();
        if (!StringUtils.isEmpty((Object)abilityPluginReqBO.getAbilityPluginDeployId())) {
            PluginRouteExtPO pluginRouteExtPO = new PluginRouteExtPO();
            pluginRouteExtPO.setAbilityPluginDeployId(abilityPluginReqBO.getAbilityPluginDeployId());
            PluginRouteExtPO pluginRouteExtPO1 = this.pluginRouteExtMapper.queryLimitOne(pluginRouteExtPO);
            jsonMap.put("extKey", org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pluginRouteExtPO1.getExtKey()) ? "" : pluginRouteExtPO1.getExtKey());
            jsonMap.put("extValue", org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pluginRouteExtPO1.getExtValue()) ? "" : pluginRouteExtPO1.getExtValue());
        } else {
            jsonMap.put("extKey", "");
            jsonMap.put("extValue", "");
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("abilityPluginDeployIds", abilityPluginReqBO.getAbilityPluginDeployIds());
        return RspBO.success((Object)new AbilityPluginRspBO(TITLE, StepEnum.NEXT.getCode(), URL, (Map)paramMap, (Map)jsonMap, STEP_TWO));
    }

    @Override
    public RspBO updatePluginRouteExtByAbilityPluginDeployId(PluginRouteExtBO pluginRouteExtBO) {
        log.debug("PluginRouteServiceImpl.updatePluginRouteExtByAbilityPluginDeployId\uff1a" + pluginRouteExtBO);
        ValidBatchUtils.isNotEmpty((Object)pluginRouteExtBO, (String[])new String[]{"extKey", "extValue", "abilityPluginDeployIds"});
        for (Long abilityPluginDeployId : pluginRouteExtBO.getAbilityPluginDeployIds()) {
            PluginRouteExtPO pluginRouteExtPO = (PluginRouteExtPO)BeanMapper.map((Object)pluginRouteExtBO, PluginRouteExtPO.class);
            pluginRouteExtPO.setAbilityPluginDeployId(abilityPluginDeployId);
            this.pluginRouteExtMapper.updatePluginRouteExtByAbilityPluginDeployId(pluginRouteExtPO);
        }
        return RspBO.success((Object)new AbilityPluginRspBO(StepEnum.END.getCode()));
    }
}

