/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.PluginRouteColumnMapper;
import com.ohaotian.plugin.mapper.PluginRouteExtMapper;
import com.ohaotian.plugin.mapper.PluginRouteMapper;
import com.ohaotian.plugin.model.bo.req.PluginRouteColumnBO;
import com.ohaotian.plugin.model.bo.req.RouteColumnsBO;
import com.ohaotian.plugin.model.po.PluginRouteColumnPO;
import com.ohaotian.plugin.model.po.PluginRouteExtPO;
import com.ohaotian.plugin.model.po.PluginRoutePO;
import com.ohaotian.plugin.service.PluginRouteService;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.enums.StepEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.AbilityPluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.QryPluginJsonService;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@PluginTypeHandlerType(value="route", position=ExtensionPointPositionEnum.ABILITY_POSITION)
public class RoutePluginHandler
extends AbstractPluginHandler<Object> {
    private static final Logger log = LogManager.getLogger(RoutePluginHandler.class);
    private static final String URL = "/ability/updatePluginRouteColumn";
    private static final String TITLE = "\u8def\u7531\u7ed1\u5b9a\u5173\u7cfb\u6269\u5c55\u4fe1\u606f";
    private static final String STEP_ONE = "plugin-binding-route-step-one";
    @Resource
    private PluginRouteMapper pluginRouteMapper;
    @Resource
    private PluginRouteColumnMapper pluginRouteColumnMapper;
    @Resource
    private PluginRouteExtMapper pluginRouteExtMapper;
    @Resource
    private QryPluginJsonService qryPluginJsonService;
    @Resource
    private PluginRouteService pluginRouteService;
    @Value(value="classpath:static/data/ability-plugin-route.json")
    private org.springframework.core.io.Resource routeJson;

    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO handleAdd(Object object) throws ZTBusinessException {
        try {
            PluginRouteColumnPO pluginRouteColumnPO;
            log.debug("RoutePluginHandler.handleAdd\uff1a" + object);
            Map objectMap = (Map)object;
            String abilityPluginDeployId = objectMap.get("abilityPluginDeployId") + "";
            String pluginId = objectMap.get("pluginId") + "";
            PluginRoutePO pluginRoutePO = new PluginRoutePO();
            pluginRoutePO.setPluginId(Long.valueOf(pluginId));
            PluginRoutePO pluginRoutePO1 = this.pluginRouteMapper.queryLimitOne(pluginRoutePO);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsFirst())) {
                pluginRouteColumnPO = new PluginRouteColumnPO();
                pluginRouteColumnPO.setAbilityPluginDeployId(Long.valueOf(abilityPluginDeployId));
                this.pluginRouteColumnMapper.insertSelective(pluginRouteColumnPO);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsSecond())) {
                pluginRouteColumnPO = new PluginRouteColumnPO();
                pluginRouteColumnPO.setAbilityPluginDeployId(Long.valueOf(abilityPluginDeployId));
                this.pluginRouteColumnMapper.insertSelective(pluginRouteColumnPO);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsThird())) {
                pluginRouteColumnPO = new PluginRouteColumnPO();
                pluginRouteColumnPO.setAbilityPluginDeployId(Long.valueOf(abilityPluginDeployId));
                this.pluginRouteColumnMapper.insertSelective(pluginRouteColumnPO);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsFourth())) {
                pluginRouteColumnPO = new PluginRouteColumnPO();
                pluginRouteColumnPO.setAbilityPluginDeployId(Long.valueOf(abilityPluginDeployId));
                this.pluginRouteColumnMapper.insertSelective(pluginRouteColumnPO);
            }
            PluginRouteExtPO pluginRouteExtPO = new PluginRouteExtPO();
            pluginRouteExtPO.setAbilityPluginDeployId(Long.valueOf(abilityPluginDeployId));
            this.pluginRouteExtMapper.insertSelective(pluginRouteExtPO);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO handleModify(Object object) throws ZTBusinessException {
        try {
            if (Objects.isNull(object)) {
                throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
            }
            Map map = (Map)object;
            log.debug("RoutePluginHandler.handleModify\uff1a" + map);
            List abilityPluginDeployIds = JSON.parseArray((String)(map.get("abilityPluginDeployIds") + ""), Long.class);
            if (CollectionUtils.isEmpty((Collection)abilityPluginDeployIds)) {
                throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
            }
            map.remove("abilityPluginDeployIds");
            PluginRouteColumnBO pluginRouteColumnBO = new PluginRouteColumnBO();
            ArrayList routeColumnsBOList = Lists.newArrayList();
            for (Map.Entry entry : map.entrySet()) {
                RouteColumnsBO routeColumnsBO = new RouteColumnsBO();
                routeColumnsBO.setColumnKey((String)entry.getKey());
                routeColumnsBO.setColumnPath(entry.getValue() + "");
                routeColumnsBOList.add(routeColumnsBO);
            }
            pluginRouteColumnBO.setRouteColumnsBOList(routeColumnsBOList);
            pluginRouteColumnBO.setAbilityPluginDeployIds(abilityPluginDeployIds);
            AbilityPluginReqBO abilityPluginReqBO = new AbilityPluginReqBO();
            for (Long abilityPluginDeployId : pluginRouteColumnBO.getAbilityPluginDeployIds()) {
                PluginRouteColumnPO pluginRouteColumnPO1 = new PluginRouteColumnPO();
                pluginRouteColumnPO1.setAbilityPluginDeployId(abilityPluginDeployId);
                List<PluginRouteColumnPO> pluginRouteColumnPOList = this.pluginRouteColumnMapper.queryByCond(pluginRouteColumnPO1);
                if (CollectionUtils.isEmpty(pluginRouteColumnPOList)) {
                    throw new ZTBusinessException("\u67e5\u8be2\u8def\u7531\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a");
                }
                String columnKey = pluginRouteColumnPOList.get(0).getColumnKey();
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)columnKey)) {
                    abilityPluginReqBO.setAbilityPluginDeployId(abilityPluginDeployId);
                }
                for (RouteColumnsBO routeColumnsBO : pluginRouteColumnBO.getRouteColumnsBOList()) {
                    PluginRouteColumnPO pluginRouteColumnPO;
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)columnKey)) {
                        pluginRouteColumnPO = (PluginRouteColumnPO)BeanMapper.map((Object)routeColumnsBO, PluginRouteColumnPO.class);
                        pluginRouteColumnPO.setAbilityPluginDeployId(abilityPluginDeployId);
                        this.pluginRouteColumnMapper.updatePluginRouteColumnByAbilityPluginDeployId(pluginRouteColumnPO);
                        continue;
                    }
                    pluginRouteColumnPO = new PluginRouteColumnPO();
                    pluginRouteColumnPO.setAbilityPluginDeployId(pluginRouteColumnPO1.getAbilityPluginDeployId());
                    PluginRouteColumnPO pluginRouteColumnPO2 = this.pluginRouteColumnMapper.queryLimitOne(pluginRouteColumnPO);
                    PluginRouteColumnPO pluginRouteColumnPO3 = (PluginRouteColumnPO)BeanMapper.map((Object)routeColumnsBO, PluginRouteColumnPO.class);
                    pluginRouteColumnPO3.setRouteColumnId(pluginRouteColumnPO2.getRouteColumnId());
                    this.pluginRouteColumnMapper.updatePluginRouteColumnByRouteColumnId(pluginRouteColumnPO3);
                }
            }
            abilityPluginReqBO.setAbilityPluginDeployIds(pluginRouteColumnBO.getAbilityPluginDeployIds());
            return this.pluginRouteService.qryAbilityRouteExtPlugin(abilityPluginReqBO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleDelete(Object object) throws ZTBusinessException {
        try {
            Long abilityPluginDeployId = (Long)object;
            PluginRouteExtPO pluginRouteExtPO = new PluginRouteExtPO();
            pluginRouteExtPO.setAbilityPluginDeployId(abilityPluginDeployId);
            this.pluginRouteExtMapper.deletePluginRouteExtByPluginDeployId(pluginRouteExtPO);
            PluginRouteColumnPO pluginRouteColumnPO = new PluginRouteColumnPO();
            pluginRouteColumnPO.setAbilityPluginDeployId(abilityPluginDeployId);
            this.pluginRouteColumnMapper.deletePluginRouteColumnByPluginDeployId(pluginRouteColumnPO);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        HashMap map;
        log.debug("RoutePluginHandler.handleGetAbilityPlugin\uff1a" + abilityPluginReqBO);
        PluginRoutePO pluginRoutePO = new PluginRoutePO();
        pluginRoutePO.setPluginId(abilityPluginReqBO.getPluginId());
        PluginRoutePO pluginRoutePO1 = this.pluginRouteMapper.queryLimitOne(pluginRoutePO);
        String template = this.qryPluginJsonService.getAbilityPlugin(abilityPluginReqBO, this.routeJson);
        HashMap jsonMap = Maps.newHashMap();
        jsonMap.put("pluginName", abilityPluginReqBO.getPluginName());
        jsonMap.put("abilityName", abilityPluginReqBO.getAbilityName());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsFirst())) {
            jsonMap.put("argsFirst", pluginRoutePO1.getArgsFirst());
            jsonMap.put("argsFirstHidden", false);
            jsonMap.put("argsFirstRequired", true);
        } else {
            jsonMap.put("argsFirstHidden", true);
            jsonMap.put("argsFirstRequired", false);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsSecond())) {
            jsonMap.put("argsSecond", pluginRoutePO1.getArgsSecond());
            jsonMap.put("argsSecondHidden", false);
            jsonMap.put("argsSecondRequired", true);
        } else {
            jsonMap.put("argsSecondHidden", true);
            jsonMap.put("argsSecondRequired", false);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsThird())) {
            jsonMap.put("argsThird", pluginRoutePO1.getArgsThird());
            jsonMap.put("argsThirdHidden", false);
            jsonMap.put("argsThirdRequired", true);
        } else {
            jsonMap.put("argsThirdHidden", true);
            jsonMap.put("argsThirdRequired", false);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsFourth())) {
            jsonMap.put("argsFourth", pluginRoutePO1.getArgsFourth());
            jsonMap.put("argsFourthHidden", false);
            jsonMap.put("argsFourthRequired", true);
        } else {
            jsonMap.put("argsFourthHidden", true);
            jsonMap.put("argsFourthRequired", false);
        }
        if (!StringUtils.isEmpty((Object)abilityPluginReqBO.getAbilityPluginDeployId())) {
            PluginRouteColumnPO pluginRouteColumnPO = new PluginRouteColumnPO();
            pluginRouteColumnPO.setAbilityPluginDeployId(abilityPluginReqBO.getAbilityPluginDeployId());
            List<PluginRouteColumnPO> pluginRouteColumnPOList = this.pluginRouteColumnMapper.queryByCond(pluginRouteColumnPO);
            for (PluginRouteColumnPO pluginRouteColumnPO1 : pluginRouteColumnPOList) {
                String columnKey = pluginRouteColumnPO1.getColumnKey();
                String columnPath = pluginRouteColumnPO1.getColumnPath();
                if (columnKey == null) {
                    jsonMap.put("argsFirstValue", "");
                    jsonMap.put("argsSecondValue", "");
                    jsonMap.put("argsThirdValue", "");
                    jsonMap.put("argsFourthValue", "");
                    continue;
                }
                if (pluginRoutePO1.getArgsFirst().equals(columnKey)) {
                    jsonMap.put("argsFirstValue", columnPath);
                    continue;
                }
                if (pluginRoutePO1.getArgsSecond().equals(columnKey)) {
                    jsonMap.put("argsSecondValue", columnPath);
                    continue;
                }
                if (pluginRoutePO1.getArgsThird().equals(columnKey)) {
                    jsonMap.put("argsThirdValue", columnPath);
                    continue;
                }
                if (!pluginRoutePO1.getArgsFourth().equals(columnKey)) continue;
                jsonMap.put("argsFourthValue", columnPath);
            }
            ArrayList list = Lists.newArrayList();
            list.add(abilityPluginReqBO.getAbilityPluginDeployId());
            abilityPluginReqBO.setAbilityPluginDeployIds((List)list);
        } else {
            jsonMap.put("argsFirstValue", "");
            jsonMap.put("argsSecondValue", "");
            jsonMap.put("argsThirdValue", "");
            jsonMap.put("argsFourthValue", "");
        }
        ArrayList list = Lists.newArrayList();
        if (pluginRoutePO1.getArgsFirst() != null && pluginRoutePO1.getArgsFirst().length() > 0) {
            map = Maps.newHashMap();
            map.put("key", pluginRoutePO1.getArgsFirst());
            map.put("label", pluginRoutePO1.getArgsFirst() + "\u8def\u5f84");
            map.put("value", (String)jsonMap.get("argsFirstValue"));
            list.add(map);
        }
        if (pluginRoutePO1.getArgsSecond() != null && pluginRoutePO1.getArgsSecond().length() > 0) {
            map = Maps.newHashMap();
            map.put("key", pluginRoutePO1.getArgsSecond());
            map.put("label", pluginRoutePO1.getArgsSecond() + "\u8def\u5f84");
            map.put("value", (String)jsonMap.get("argsSecondValue"));
            list.add(map);
        }
        if (pluginRoutePO1.getArgsThird() != null && pluginRoutePO1.getArgsThird().length() > 0) {
            map = Maps.newHashMap();
            map.put("key", pluginRoutePO1.getArgsThird());
            map.put("label", pluginRoutePO1.getArgsThird() + "\u8def\u5f84");
            map.put("value", (String)jsonMap.get("argsThirdValue"));
            list.add(map);
        }
        if (pluginRoutePO1.getArgsFourth() != null && pluginRoutePO1.getArgsFourth().length() > 0) {
            map = Maps.newHashMap();
            map.put("key", pluginRoutePO1.getArgsFourth());
            map.put("label", pluginRoutePO1.getArgsFourth() + "\u8def\u5f84");
            map.put("value", (String)jsonMap.get("argsFourthValue"));
            list.add(map);
        }
        jsonMap.put("routeRenderConf", list);
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("abilityPluginDeployIds", abilityPluginReqBO.getAbilityPluginDeployIds());
        return RspBO.success((Object)new AbilityPluginRspBO(TITLE, StepEnum.NEXT.getCode(), URL, (Map)paramMap, (Map)jsonMap, STEP_ONE));
    }
}

