/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.model.po.PluginRoutePO;
import com.ohaotian.plugin.service.GetStaticJsonService;
import com.ohaotian.plugin.service.PluginRouteService;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@PluginTypeHandlerType(value="route", position=ExtensionPointPositionEnum.PLUGIN_POSITION)
public class RoutePluginExtHandler
extends AbstractPluginHandler<Map> {
    private static final Logger log = LogManager.getLogger(RoutePluginExtHandler.class);
    @Resource
    private GetStaticJsonService getStaticJsonService;
    @Resource
    private PluginRouteService pluginRouteService;

    public RspBO handleAdd(Map pluginRouteMap) throws ZTBusinessException {
        try {
            PluginRoutePO pluginRoutePO = (PluginRoutePO)BeanMapper.map((Object)pluginRouteMap, PluginRoutePO.class);
            ValidBatchUtils.isNotEmpty((Object)pluginRoutePO, (String[])new String[]{"routeLogic", "priority"});
            log.debug("\u5904\u7406route\u63d2\u4ef6\u6dfb\u52a0\u64cd\u4f5c\uff1a" + pluginRouteMap);
            log.debug("\u5904\u7406route\u63d2\u4ef6\u6dfb\u52a0\u64cd\u4f5c\uff1a" + pluginRoutePO.toString());
            this.pluginRouteService.insertSelective(pluginRoutePO);
            return RspBO.success(null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleModify(Map pluginRouteMap) throws ZTBusinessException {
        try {
            log.debug("\u5904\u7406route\u63d2\u4ef6\u4fee\u6539\u64cd\u4f5c\uff1a" + pluginRouteMap);
            return RspBO.success((Object)pluginRouteMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleDelete(Map pluginRouteMap) throws ZTBusinessException {
        try {
            PluginRoutePO pluginRoutePO = (PluginRoutePO)BeanMapper.map((Object)pluginRouteMap, PluginRoutePO.class);
            ValidBatchUtils.isNotEmpty((Object)pluginRoutePO, (String[])new String[]{"pluginId"});
            log.debug("\u5904\u7406route\u63d2\u4ef6\u5220\u9664\u64cd\u4f5c\uff1a" + pluginRouteMap);
            this.pluginRouteService.deletePluginRouteByPluginId(pluginRoutePO.getPluginId());
            return RspBO.success((Object)pluginRouteMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleGetInfo() throws ZTBusinessException {
        log.debug("\u67e5\u8be2\u8def\u7531\u63d2\u4ef6\u4fe1\u606f");
        String content = this.getStaticJsonService.getExtInfo();
        Object parse = JSON.parse((String)content);
        return RspBO.success((Object)parse);
    }
}

