/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.model.bo.req.PluginRouteExtReqBO;
import com.ohaotian.plugin.model.bo.rsp.PluginRouteExtRspBO;
import com.ohaotian.plugin.model.po.PluginRoutePO;
import com.ohaotian.plugin.service.PluginRouteService;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/route"})
public class RouteController {
    private static Logger logger = LogManager.getLogger(RouteController.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    PluginRouteService pluginRouteService;

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfo"})
    @BusiResponseBody
    public RspBO getPluginExtInfo(@RequestBody PluginReqBO pluginReqBO) {
        RspBO rspBO;
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRoutePO pluginRoutePO = new PluginRoutePO();
        pluginRoutePO.setPluginId(pluginReqBO.getPluginId());
        pluginRoutePO = this.pluginRouteService.queryLimitOne(pluginRoutePO);
        if (pluginRoutePO != null) {
            PluginRouteExtRspBO pluginRouteBO = (PluginRouteExtRspBO)BeanMapper.map((Object)pluginRoutePO, PluginRouteExtRspBO.class);
            rspBO = RspBO.success((Object)pluginRouteBO);
        } else {
            rspBO = RspBO.success(null);
        }
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/modPluginExt"})
    @BusiResponseBody
    public RspBO modPluginExt(@RequestBody PluginRouteExtReqBO pluginRouteExtReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginRouteExtReqBO);
        if (StringUtils.isEmpty((Object)pluginRouteExtReqBO.getRouteId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (StringUtils.isEmpty((Object)pluginRouteExtReqBO.getPriority())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u4f18\u5148\u7ea7");
        }
        if (StringUtils.isEmpty((Object)pluginRouteExtReqBO.getRouteLogic())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8def\u6709\u903b\u8f91");
        }
        PluginRoutePO pluginRoutePO = (PluginRoutePO)BeanMapper.map((Object)pluginRouteExtReqBO, PluginRoutePO.class);
        Integer count = this.pluginRouteService.updatePluginRouteByRouteId(pluginRoutePO);
        if (count < 1) {
            throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25");
        }
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }
}

