/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.PluginRouteColumnMapper;
import com.ohaotian.plugin.mapper.PluginRouteExtMapper;
import com.ohaotian.plugin.mapper.PluginRouteMapper;
import com.ohaotian.plugin.model.bo.rsp.SyncPluginRouteBO;
import com.ohaotian.plugin.service.RouteSyncDataService;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.bo.SyncDataReqBO;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RouteSyncDataServiceImpl
implements RouteSyncDataService {
    private Logger log = LogManager.getLogger(RouteSyncDataServiceImpl.class);
    private static final String PLUGIN_ROUTE = "plugin_route";
    private static final String PLUGIN_ROUTE_COLUMN = "plugin_route_column";
    private static final String PLUGIN_ROUTE_EXT = "plugin_route_ext";
    @Resource
    PluginAPI pluginAPI;
    @Resource
    private PluginRouteMapper pluginRouteMapper;
    @Resource
    private PluginRouteColumnMapper pluginRouteColumnMapper;
    @Resource
    private PluginRouteExtMapper pluginRouteExtMapper;

    @Override
    public RspBO syncAllData(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{"clusterId", "hirerId", "firstLevel", "secondLevel"});
        Map<String, Object> map = this.qryPlugin(syncDataBO, 0);
        return RspBO.success(map);
    }

    private Map<String, Object> qryPlugin(SyncDataReqBO syncDataBO, int type) {
        HashMap map = Maps.newHashMap();
        String firstLevel = syncDataBO.getFirstLevel();
        String secondLevel = syncDataBO.getSecondLevel();
        Long primaryId = syncDataBO.getPrimaryId();
        if (FisrtLevelEnum.PLUGIN.getCode().equals(firstLevel) && SecondLevelEnum.PLUGIN_PLUGIN.getCode().equals(secondLevel)) {
            List<SyncPluginRouteBO> pluginRouteBOList;
            List pluginIds = this.pluginAPI.getPluginIds(syncDataBO);
            if (type == 0) {
                this.log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)PLUGIN_ROUTE);
            } else {
                this.log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)PLUGIN_ROUTE, (Object)primaryId);
            }
            if (!CollectionUtils.isEmpty((Collection)pluginIds) && !CollectionUtils.isEmpty(pluginRouteBOList = this.pluginRouteMapper.queryPluginRouteByPluginIds(pluginIds))) {
                map.put(PLUGIN_ROUTE, pluginRouteBOList);
            }
        } else if (FisrtLevelEnum.PLUGIN.getCode().equals(firstLevel) && SecondLevelEnum.PLUGIN_PLUGIN_EXT.getCode().equals(secondLevel)) {
            List<Serializable> list;
            List abilityPluginDeployIds = null;
            if (type == 1 || type == 0) {
                abilityPluginDeployIds = this.pluginAPI.getAbilityPluginDeployIds(syncDataBO.getClusterId(), syncDataBO.getHirerId(), null, syncDataBO.getPrimaryId());
            } else if (type == 2) {
                abilityPluginDeployIds = this.pluginAPI.getAbilityPluginDeployIds(syncDataBO.getClusterId(), syncDataBO.getHirerId(), syncDataBO.getPrimaryId(), null);
            }
            if (type == 0) {
                this.log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)PLUGIN_ROUTE_COLUMN);
            } else {
                this.log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)PLUGIN_ROUTE_COLUMN, (Object)primaryId);
            }
            if (!CollectionUtils.isEmpty((Collection)abilityPluginDeployIds) && !CollectionUtils.isEmpty(list = this.pluginRouteColumnMapper.queryPluginRouteColumnByPluginIds(abilityPluginDeployIds))) {
                map.put(PLUGIN_ROUTE_COLUMN, list);
            }
            if (type == 0) {
                this.log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)PLUGIN_ROUTE_EXT);
            } else {
                this.log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)PLUGIN_ROUTE_EXT, (Object)primaryId);
            }
            if (!CollectionUtils.isEmpty((Collection)abilityPluginDeployIds) && !CollectionUtils.isEmpty(list = this.pluginRouteExtMapper.queryPluginRouteExtByPluginIds(abilityPluginDeployIds))) {
                map.put(PLUGIN_ROUTE_EXT, list);
            }
        } else {
            this.log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)firstLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{firstLevel}).getMessage());
        }
        return map;
    }

    @Override
    public RspBO syncIncrementData(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{"clusterId", "hirerId", "firstLevel", "secondLevel", "primaryId"});
        Map<String, Object> map = this.qryPlugin(syncDataBO, 1);
        return RspBO.success(map);
    }

    @Override
    public RspBO syncIncrementDataByAbility(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{"clusterId", "hirerId", "firstLevel", "secondLevel", "primaryId"});
        Map<String, Object> map = this.qryPlugin(syncDataBO, 2);
        return RspBO.success(map);
    }
}

