/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.alibaba.excel.metadata.Sheet;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.PluginRouteColumnMapper;
import com.ohaotian.plugin.mapper.PluginRouteExtMapper;
import com.ohaotian.plugin.model.po.PluginRouteColumnPO;
import com.ohaotian.plugin.model.po.PluginRouteExtPO;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.ExportBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
@PluginTypeHandlerType(value="route", position=ExtensionPointPositionEnum.EXPORT_POSITION)
public class RouteExportHandler
extends AbstractPluginHandler<List<ExportBO>> {
    @Resource
    private PluginRouteColumnMapper pluginRouteColumnMapper;
    @Resource
    private PluginRouteExtMapper pluginRouteExtMapper;

    public RspBO<List<ExportBO>> handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        ArrayList exportBOList = Lists.newArrayList();
        List abilityPluginDeployIds = abilityPluginReqBO.getAbilityPluginDeployIds();
        List<PluginRouteColumnPO> pluginRouteColumnPOList = this.pluginRouteColumnMapper.queryPluginByPluginDeployIds(abilityPluginDeployIds);
        ArrayList provideDeployRows = Lists.newArrayList();
        Sheet sheet = new Sheet(1, 3);
        sheet.setSheetName("plugin_route_column");
        sheet.setAutoWidth(Boolean.TRUE);
        ArrayList header = Lists.newArrayList();
        ArrayList strs = Lists.newArrayList();
        strs.add("routeColumnId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("abilityPluginDeployId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("columnPath");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("columnKey");
        header.add(strs);
        sheet.setHead((List)header);
        for (PluginRouteColumnPO pluginRouteColumnPO : pluginRouteColumnPOList) {
            ArrayList objs = Lists.newArrayList();
            objs.add(pluginRouteColumnPO.getRouteColumnId());
            objs.add(pluginRouteColumnPO.getAbilityPluginDeployId());
            objs.add(pluginRouteColumnPO.getColumnPath());
            objs.add(pluginRouteColumnPO.getColumnKey());
            provideDeployRows.add(objs);
        }
        ExportBO exportBO = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
        exportBOList.add(exportBO);
        List<PluginRouteExtPO> pluginRouteExtPOList = this.pluginRouteExtMapper.queryPluginByPluginDeployIds(abilityPluginDeployIds);
        sheet = new Sheet(2, 3);
        sheet.setSheetName("plugin_route_ext");
        sheet.setAutoWidth(Boolean.TRUE);
        header = Lists.newArrayList();
        strs = Lists.newArrayList();
        strs.add("routeExtId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("routeExtDesc");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("extKey");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("extValue");
        header.add(strs);
        sheet.setHead((List)header);
        provideDeployRows = Lists.newArrayList();
        for (PluginRouteExtPO pluginRouteExtPO : pluginRouteExtPOList) {
            ArrayList objs = Lists.newArrayList();
            objs.add(pluginRouteExtPO.getRouteExtId());
            objs.add(pluginRouteExtPO.getAbilityPluginDeployId());
            objs.add(pluginRouteExtPO.getRouteExtDesc());
            objs.add(pluginRouteExtPO.getExtKey());
            objs.add(pluginRouteExtPO.getExtValue());
            provideDeployRows.add(objs);
        }
        ExportBO PluginRouteExt = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
        exportBOList.add(PluginRouteExt);
        return RspBO.success((Object)exportBOList);
    }
}

