/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginJwtMapper;
import com.ohaotian.plugin.model.bo.req.AbilityPluginJwtBO;
import com.ohaotian.plugin.model.po.AbilityPluginJwtPO;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.enums.StepEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.AbilityPluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.QryPluginJsonService;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
@PluginTypeHandlerType(value="token", position=ExtensionPointPositionEnum.ABILITY_POSITION)
public class TokenPluginHandler
extends AbstractPluginHandler<Object> {
    private static final Logger log = LogManager.getLogger(TokenPluginHandler.class);
    private static final String URL = "/ability/updatePluginToken";
    private static final String TITLE = "jwt\u7ed1\u5b9a\u5173\u7cfb\u6269\u5c55\u4fe1\u606f";
    private static final String COMPONENT_TYPE = "plugin-binding-jwt";
    @Resource
    private QryPluginJsonService qryPluginJsonService;
    @Value(value="classpath:static/data/ability-plugin-token.json")
    private org.springframework.core.io.Resource tokenJson;
    @Resource
    private AbilityPluginJwtMapper abilityPluginJwtMapper;

    public RspBO handleAdd(Object object) throws ZTBusinessException {
        try {
            Long userId = Long.valueOf(UserHolder.getUserId());
            log.debug("TokenPluginHandler.handleAdd\uff1a" + object);
            Map objectMap = (Map)object;
            String abilityPluginDeployId = objectMap.get("abilityPluginDeployId") + "";
            AbilityPluginJwtPO abilityPluginJwtPO = new AbilityPluginJwtPO();
            abilityPluginJwtPO.setAbilityPluginDeployId(Long.valueOf(abilityPluginDeployId));
            abilityPluginJwtPO.setCreateTime(new Date());
            abilityPluginJwtPO.setUpdateTime(new Date());
            abilityPluginJwtPO.setCreateUserId(userId);
            abilityPluginJwtPO.setUpdateUserId(userId);
            abilityPluginJwtPO.setEnhancedValidation(0);
            this.abilityPluginJwtMapper.insertSelective(abilityPluginJwtPO);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO handleModify(Object object) throws ZTBusinessException {
        Long userId = Long.valueOf(UserHolder.getUserId());
        try {
            log.debug("PriorityPluginHandler.handleModify\uff1a" + object);
            AbilityPluginJwtBO abilityPluginJwtBO = (AbilityPluginJwtBO)object;
            ValidBatchUtils.isNotEmpty((Object)abilityPluginJwtBO, (String[])new String[]{"timestampPath", "transIdPath", "tokenPath", "abilityPluginDeployIds"});
            for (Long abilityPluginDeployId : abilityPluginJwtBO.getAbilityPluginDeployIds()) {
                AbilityPluginJwtPO abilityPluginJwtPO = (AbilityPluginJwtPO)BeanMapper.map((Object)abilityPluginJwtBO, AbilityPluginJwtPO.class);
                abilityPluginJwtPO.setAbilityPluginDeployId(abilityPluginDeployId);
                abilityPluginJwtPO.setUpdateTime(new Date());
                abilityPluginJwtPO.setUpdateUserId(userId);
                abilityPluginJwtPO.setEnhancedValidation(0);
                this.abilityPluginJwtMapper.updateAbilityPluginJwtByAbilityPluginDeployId(abilityPluginJwtPO);
            }
            return RspBO.success((Object)new AbilityPluginRspBO(StepEnum.END.getCode()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleDelete(Object object) throws ZTBusinessException {
        try {
            Long abilityPluginDeployId = (Long)object;
            this.abilityPluginJwtMapper.deleteAbilityPluginJwtByPluginDeployId(abilityPluginDeployId);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        log.debug("\u67e5\u8be2jwt\u63d2\u4ef6\u4fe1\u606f");
        String template = this.qryPluginJsonService.getAbilityPlugin(abilityPluginReqBO, this.tokenJson);
        HashMap jsonMap = Maps.newHashMap();
        jsonMap.put("pluginName", abilityPluginReqBO.getPluginName());
        jsonMap.put("abilityName", abilityPluginReqBO.getAbilityName());
        if (!StringUtils.isEmpty((Object)abilityPluginReqBO.getAbilityPluginDeployId())) {
            AbilityPluginJwtPO abilityPluginJwtPO = new AbilityPluginJwtPO();
            abilityPluginJwtPO.setAbilityPluginDeployId(abilityPluginReqBO.getAbilityPluginDeployId());
            AbilityPluginJwtPO abilityPluginJwtPO1 = this.abilityPluginJwtMapper.queryLimitOne(abilityPluginJwtPO);
            jsonMap.put("timestampPath", abilityPluginJwtPO1.getTimestampPath());
            jsonMap.put("transIdPath", abilityPluginJwtPO1.getTransIdPath());
            jsonMap.put("tokenPath", abilityPluginJwtPO1.getTokenPath());
            jsonMap.put("enhancedValidation", abilityPluginJwtPO1.getEnhancedValidation());
            ArrayList list = Lists.newArrayList();
            list.add(abilityPluginReqBO.getAbilityPluginDeployId());
            abilityPluginReqBO.setAbilityPluginDeployIds((List)list);
        } else {
            jsonMap.put("timestampPath", "");
            jsonMap.put("transIdPath", "");
            jsonMap.put("tokenPath", "");
            jsonMap.put("enhancedValidation", 0);
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("abilityPluginDeployIds", abilityPluginReqBO.getAbilityPluginDeployIds());
        return RspBO.success((Object)new AbilityPluginRspBO(TITLE, StepEnum.NEXT.getCode(), URL, (Map)paramMap, (Map)jsonMap, COMPONENT_TYPE));
    }
}

