/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.alibaba.excel.metadata.Sheet;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.AbilityPluginJwtMapper;
import com.ohaotian.plugin.model.po.AbilityPluginJwtPO;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.ExportBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@PluginTypeHandlerType(value="token", position=ExtensionPointPositionEnum.EXPORT_POSITION)
public class TokenExportHandler
extends AbstractPluginHandler<List<ExportBO>> {
    private static final Logger log = LogManager.getLogger(TokenExportHandler.class);
    @Resource
    private AbilityPluginJwtMapper abilityPluginJwtMapper;

    public RspBO<List<ExportBO>> handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        ArrayList exportBOList = Lists.newArrayList();
        List abilityPluginDeployIds = abilityPluginReqBO.getAbilityPluginDeployIds();
        List<AbilityPluginJwtPO> abilityPluginJwtPOList = this.abilityPluginJwtMapper.queryPluginJwtByPluginDeployIds(abilityPluginDeployIds);
        ArrayList provideDeployRows = Lists.newArrayList();
        Sheet sheet = new Sheet(1, 3);
        sheet.setSheetName("ability_plugin_jwt");
        sheet.setAutoWidth(Boolean.TRUE);
        ArrayList header = Lists.newArrayList();
        ArrayList strs = Lists.newArrayList();
        strs.add("pluginJwtId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("abilityPluginDeployId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("timestampPath");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("transIdPath");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("tokenPath");
        header.add(strs);
        sheet.setHead((List)header);
        for (AbilityPluginJwtPO abilityPluginJwtPO : abilityPluginJwtPOList) {
            ArrayList objs = Lists.newArrayList();
            objs.add(abilityPluginJwtPO.getPluginJwtId());
            objs.add(abilityPluginJwtPO.getAbilityPluginDeployId());
            objs.add(abilityPluginJwtPO.getTimestampPath());
            objs.add(abilityPluginJwtPO.getTransIdPath());
            objs.add(abilityPluginJwtPO.getTokenPath());
            provideDeployRows.add(objs);
        }
        ExportBO exportBO = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
        exportBOList.add(exportBO);
        return RspBO.success((Object)exportBOList);
    }
}

