/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.plugin.PluginA;
import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.util.GSCheckPluginKeyUtil;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="GSCheckPluginService")
public class GSCheckPluginService
implements PluginA {
    private static final Logger log = LogManager.getLogger(GSCheckPluginService.class);
    @Resource
    private CacheClient cacheClient;
    @Resource
    private NodeInfoConfig nodeInfoConfig;

    public void doService(MsgContext msgContext) throws AbilityException {
        AbilityPluginBO abilityPluginBO = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "GSCheck".equalsIgnoreCase(bo.getPluginType())).findAny().orElse(null);
        if (Objects.isNull(abilityPluginBO)) {
            log.debug("\u56fd\u91c7\u8ba4\u8bc1\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
            return;
        }
        Object reqObj = msgContext.getTlogReqHeader().getReqObj(msgContext);
        try {
            String token = (String)ReflectBeanValueUtil.getValue((Object)reqObj, (String)"token");
            if (StringUtils.isEmpty((Object)token)) {
                log.debug("\u56fd\u91c7\u8ba4\u8bc1\u672a\u901a\u8fc7-\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5\uff08token\uff09");
                throw new AbilityException("pluginError_GCCheck", "GSCheckPluginService >>> \u56fd\u91c7\u8ba4\u8bc1\u672a\u901a\u8fc7-\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            String supplierCode = (String)ReflectBeanValueUtil.getValue((Object)reqObj, (String)"supplierCode");
            if (StringUtils.isEmpty((Object)supplierCode)) {
                log.debug("\u56fd\u91c7\u8ba4\u8bc1\u672a\u901a\u8fc7-\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5\uff08supplierCode\uff09");
                throw new AbilityException("pluginError_GCCheck", "GSCheckPluginService >>> \u56fd\u91c7\u8ba4\u8bc1\u672a\u901a\u8fc7-\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            String key = GSCheckPluginKeyUtil.getTokenKey(token, this.nodeInfoConfig.getClusterId(), supplierCode);
            boolean b = ObjectUtils.isEmpty((Object)this.cacheClient.get(key));
            if (!b) {
                log.debug("\u56fd\u91c7\u8ba4\u8bc1\u672a\u901a\u8fc7-token\u5df2\u5931\u6548");
                throw new AbilityException("pluginError_GCCheck", "GSCheckPluginService >>> \u56fd\u91c7\u8ba4\u8bc1\u672a\u901a\u8fc7-token\u5df2\u5931\u6548");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new AbilityException("pluginError_GCCheck", "GSCheckPluginService >>>  \u56fd\u91c7\u8ba4\u8bc1\u672a\u901a-\u63d2\u4ef6\u6267\u884c\u5931\u8d25");
        }
    }
}

