/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Random;

public abstract class GSCheckPluginKeyUtil {
    private static final String REDIS_TOKEN_PREFIX = "gs_check_plugin_redis_token_";
    public static final String REDIS_TOKEN_KEY_PREFIX = "gs_check_plugin_redis_token_key_";
    private static final Random RANDOM = new Random();
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final String CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";

    public static String getTokenKey(String token, Long clusterId, String supplierCode) {
        StringBuilder key = new StringBuilder(REDIS_TOKEN_PREFIX);
        key.append(token);
        key.append('_');
        key.append(clusterId);
        key.append('_');
        key.append(supplierCode);
        return key.toString();
    }

    public static String createToken() throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append(CHARACTERS.charAt(RANDOM.nextInt(CHARACTERS.length())));
        }
        sb.append(RANDOM.nextInt(1000));
        sb.append(System.currentTimeMillis());
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(sb.toString().getBytes(StandardCharsets.UTF_8));
        return new BigInteger(1, messageDigest.digest()).toString(16);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        System.out.println(GSCheckPluginKeyUtil.createToken());
    }
}

