/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.config;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.redis.PubSubRedisBaseClient;
import com.ohaotian.abilitycommon.model.bo.PluginDataRspBO;
import com.ohaotian.abilitycommon.model.bo.RedisSyncDataBo;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.ValidBatchUtils;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.model.po.HpartyCheckTokenPO;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class HpartyCheckPubSubRedisClient
extends PubSubRedisBaseClient {
    private static final Logger log = LoggerFactory.getLogger(HpartyCheckPubSubRedisClient.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Resource
    HpartyCheckTokenMapper hpartyCheckTokenMapper;
    @Resource
    private CacheClient cacheClient;
    @Resource
    NodeInfoConfig nodeInfo;

    public void redisCoreNodeDeal(Message message) {
        log.info(message.toString());
        String key = "atp-push-" + this.nodeInfo.getNodeIp() + ":" + this.nodeInfo.getPort() + "-" + this.nodeInfo.getClusterId();
        RedisSyncDataBo redisSyncDataBo = (RedisSyncDataBo)GsonUtil.fromJson((String)this.cacheClient.get(key).toString(), RedisSyncDataBo.class);
        if (!ObjectUtils.isEmpty((Object)redisSyncDataBo)) {
            if (redisSyncDataBo.getCode().equals("PLUGIN")) {
                try {
                    log.info("\u63d2\u4ef6\u6570\u636e\u540c\u6b65\u4e2d...");
                    this.pluginDataSync(redisSyncDataBo.getPluginDataRspBO());
                    log.info("\u63d2\u4ef6\u6570\u636e\u540c\u6b65\u5b8c\u6210");
                }
                catch (Exception e) {
                    log.error("\u63d2\u4ef6\u6570\u636e\u540c\u6b65\u5931\u8d25\uff01");
                    e.printStackTrace();
                }
            } else if (redisSyncDataBo.getCode().equals("NOTIFY")) {
                log.info(redisSyncDataBo.getMsg());
            }
            if (!redisSyncDataBo.getCode().equals("PROCESSED")) {
                RedisSyncDataBo redisSyncProcessedDataBo = new RedisSyncDataBo();
                redisSyncProcessedDataBo.setCode("PROCESSED");
                redisSyncProcessedDataBo.setMsg(GsonUtil.toJson((Object)redisSyncDataBo));
                this.cacheClient.set(key, (Object)GsonUtil.toJson((Object)redisSyncProcessedDataBo));
                log.info("Redis\u8bb0\u5f55\u4fee\u6539\uff01");
            }
        } else {
            log.error("Redis\u6570\u636e\u83b7\u53d6\u5931\u8d25\uff01");
        }
    }

    private void pluginDataSync(PluginDataRspBO pluginDataRspBO) {
        if (!CollectionUtils.isEmpty((Collection)pluginDataRspBO.getClusterIds()) && pluginDataRspBO.getClusterIds().contains(this.nodeInfo.getClusterId()) && "hpartyCheck".equals(pluginDataRspBO.getPluginType()) && "refresh".equals(pluginDataRspBO.getOpr())) {
            String poStr = String.valueOf(pluginDataRspBO.getData());
            HpartyCheckTokenPO po = (HpartyCheckTokenPO)GsonUtil.fromJson((String)poStr, HpartyCheckTokenPO.class);
            ValidBatchUtils.isNotEmpty((Object)po, (String[])new String[]{"pluginId", "regionCode", "clientId", "accessToken", "callProtocol"});
            this.hpartyCheckTokenMapper.updateHpartyCheckTokenByCond(po);
            log.info("HpartyCheck\u5237\u65b0token\u6210\u529f:{}", (Object)poStr);
        }
    }
}

