/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.plugin.PluginC;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.cache.CacheClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="hpartyCheck")
public class HpartyCheckService
implements PluginC {
    private static final Logger log = LogManager.getLogger(HpartyCheckService.class);
    private static final String DAYAO = "dayao";
    @Resource
    private CacheClient cacheClient;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "hpartyCheck".equalsIgnoreCase(bo.getPluginType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(abilityPluginBOList)) {
                log.debug("hpartyCheck\u6821\u9a8c\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
                return;
            }
            RegionBO regionBO = msgContext.getSelfDefHeader().getRegionBO();
            String regionCode = regionBO.getRegionCode();
            log.debug("\u83b7\u53d6\u8def\u7531\u540e\u7684\u7f16\u7801\u4e3a:" + regionCode);
            String key = this.constantBaseVersion.getATP() + "hpartyCheck-" + this.nodeInfoConfig.getClusterId() + "-" + regionCode;
            Object data = this.cacheClient.get(key);
            if (ObjectUtils.isEmpty((Object)data)) {
                throw new AbilityException(CodeMsg.REDIS_TOKEN_ERROR);
            }
            AbilityRedisTokenDataBo abilityRedisTokenDataBo = (AbilityRedisTokenDataBo)GsonUtil.fromJson((String)data.toString(), AbilityRedisTokenDataBo.class);
            TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
            SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
            HashMap reqMap = Maps.newHashMap();
            Map req = this.json2Map(new String(tlogReqHeader.getReqData(), "UTF-8"));
            req.forEach((k, y) -> reqMap.put(k, y));
            List<String> appendList = Arrays.asList(abilityRedisTokenDataBo.getAppends().split(","));
            if (appendList.size() > 0) {
                appendList.stream().forEach(append -> {
                    if (StringUtils.isEmpty((Object)append)) {
                        throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{"\u83b7\u53d6\u53c2\u6570\u5f02\u5e38,\u9274\u6743\u914d\u7f6e\u9519\u8bef\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u53c2\u6570"}));
                    }
                    switch (append) {
                        case "appkey": {
                            reqMap.put("appkey", abilityRedisTokenDataBo.getClientId());
                            break;
                        }
                        case "token": {
                            if (regionCode.contains(DAYAO)) {
                                selfDefHeader.getSelfDefMap().put("Authorization", abilityRedisTokenDataBo.getToken());
                                break;
                            }
                            reqMap.put("token", abilityRedisTokenDataBo.getToken());
                            break;
                        }
                        case "type": {
                            try {
                                reqMap.put("type", ReflectBeanValueUtil.getValue((Object)tlogReqHeader.getReqObj(msgContext), (String)"type"));
                                break;
                            }
                            catch (IllegalAccessException e) {
                                log.error((Object)e);
                                throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{"\u83b7\u53d6token\u53c2\u6570\u5f02\u5e38,\u8bf7\u6c42\u62a5\u6587\u672a\u914d\u7f6e\u6b64\u53c2\u6570\uff1atype"}));
                            }
                            catch (NoSuchFieldException e) {
                                log.error((Object)e);
                                throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{"\u83b7\u53d6token\u53c2\u6570\u5f02\u5e38,\u6570\u636e\u672a\u914d\u7f6e\u6b64\u53c2\u6570\uff1atype"}));
                            }
                        }
                        case "username": {
                            msgContext.setAuthUserName(abilityRedisTokenDataBo.getAccName());
                            break;
                        }
                        default: {
                            log.debug("HpartyCheckService >>> \u53c2\u6570\u65e0\u6cd5\u8bc6\u522b\uff1a" + append);
                        }
                    }
                });
            }
            switch (abilityRedisTokenDataBo.getCallProtocol().toString()) {
                case "0": {
                    tlogReqHeader.setReqData(HpartyCheckService.map2Json(reqMap).getBytes("UTF-8"));
                    break;
                }
                case "1": {
                    tlogReqHeader.setReqData(HpartyCheckService.map2form(reqMap).getBytes("UTF-8"));
                    selfDefHeader.getSelfDefMap().put("Content-Type", "application/x-www-form-urlencoded");
                    break;
                }
                default: {
                    tlogReqHeader.setReqData(HpartyCheckService.map2Json(reqMap).getBytes("UTF-8"));
                }
            }
            log.debug("\u8c03\u7528\u843d\u5730\u62a5\u6587\u4e3a:" + new String(tlogReqHeader.getReqData(), "UTF-8"));
            msgContext.setIsAddToken(Boolean.TRUE);
            msgContext.setTlogReqHeader(tlogReqHeader);
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("HpartyCheck\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{"\u9274\u6743\u7ed1\u5b9a\u5f02\u5e38:"}) + e.getMessage());
        }
    }

    public static String map2Json(Map map) {
        return GsonUtil.toJson((Object)map);
    }

    public static String map2form(Map map) {
        StringBuffer s = new StringBuffer(16);
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                s.append(k).append("=").append(JSONObject.fromObject((Object)v)).append("&");
            } else if (v instanceof List) {
                s.append(k).append("=").append(JSONArray.fromObject((Object)v)).append("&");
            } else {
                s.append(k).append("=").append(v).append("&");
            }
        });
        return s.toString().substring(0, s.length() - 1);
    }

    private Map json2Map(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.readValue(json, Map.class);
        return map;
    }
}

