/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.sync;

import com.ohaotian.abilitycommon.config.system.SystemParam;
import com.ohaotian.abilitycommon.mapper.TableMapper;
import com.ohaotian.abilitycommon.model.bo.SyncDataBO;
import com.ohaotian.abilitycommon.plugin.PluginSyncData;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.JacksonUtil;
import com.ohaotian.plugin.mapper.HpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.model.po.HpartyCheckAppendPO;
import com.ohaotian.plugin.model.po.HpartyCheckTokenPO;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class HpartyCheckPluginSyncData
implements PluginSyncData {
    private static Logger logger = LogManager.getLogger(HpartyCheckPluginSyncData.class);
    private static final String TABLE_HPARTY_CHECK_TOKEN = "hparty_check_token";
    private static final String TABLE_HPARTY_CHECK_APPEND = "hparty_check_append";
    private static final String ADMIN_SYNC_ALL_PATH_CHECK = "/sync/hpartyCheck/syncAllData";
    private static final String ADMIN_SYNC_INCREMENT_PATH_CHECK = "/sync/hpartyCheck/syncIncrementData";
    private static final String ADMIN_SYNC_INCREMENT_PATH_CHECK_BY_ABILITY = "/sync/hpartyCheck/syncIncrementDataByAbility";
    @Resource
    TableMapper tableMapper;
    @Resource
    HpartyCheckAppendMapper hpartyCheckAppendMapper;
    @Resource
    HpartyCheckTokenMapper hpartyCheckTokenMapper;
    @Resource
    SystemParam systemParam;
    @Resource
    RestTemplate restTemplate;

    public void syncAll(List<SyncDataBO> list) throws Exception {
        try {
            for (SyncDataBO syncDataBO : list) {
                String rspJson = this.sentToAdmin(syncDataBO, 0);
                if (!StringUtils.isNotBlank((CharSequence)rspJson)) continue;
                this.syncData2H2(rspJson, 0);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public void syncIncrement(List<SyncDataBO> list) throws Exception {
        try {
            for (SyncDataBO syncDataBO : list) {
                String rspJson = this.sentToAdmin(syncDataBO, 1);
                if (!StringUtils.isNotBlank((CharSequence)rspJson)) continue;
                this.syncData2H2(rspJson, 1);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public void syncIncrementByAbilityId(SyncDataBO syncDataBO) throws Exception {
        String rspJson = this.sentToAdmin(syncDataBO, 2);
        if (StringUtils.isNotBlank((CharSequence)rspJson)) {
            this.syncData2H2(rspJson, 1);
        }
    }

    private String sentToAdmin(SyncDataBO syncDataBO, int type) throws Exception {
        String json = GsonUtil.toJson((Object)syncDataBO);
        String adminPath = this.systemParam.getAdminPath();
        String context = this.systemParam.getContext();
        StringBuilder sb = new StringBuilder(adminPath);
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            sb.append(context);
        }
        if (type == 0) {
            sb.append(ADMIN_SYNC_ALL_PATH_CHECK);
        } else if (type == 1) {
            sb.append(ADMIN_SYNC_INCREMENT_PATH_CHECK);
        } else {
            sb.append(ADMIN_SYNC_INCREMENT_PATH_CHECK_BY_ABILITY);
        }
        HttpHeaders headers = new HttpHeaders();
        MediaType mediaType = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(mediaType);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return (String)this.restTemplate.postForEntity(sb.toString(), (Object)new HttpEntity((Object)json, (MultiValueMap)headers), String.class, new Object[0]).getBody();
    }

    private void syncData2H2(String jsonStr, int type) throws IOException {
        Map jsonObject1 = JacksonUtil.toMap((String)jsonStr);
        String code = (String)jsonObject1.get("code");
        if (!"0".equals(code)) {
            logger.warn("\u5168\u91cf\u540c\u6b65\u95e8\u6237\u6570\u636e\u5931\u8d25");
            return;
        }
        Map jsonObject = (Map)jsonObject1.get("data");
        block8: for (String tableName : jsonObject.keySet()) {
            List tableValues1 = (List)jsonObject.get(tableName);
            int size = tableValues1.size();
            String tableValues = GsonUtil.toJson((Object)tableValues1);
            switch (tableName) {
                case "hparty_check_token": {
                    List<Long> ids;
                    if (type == 0) {
                        this.tableMapper.trucateTableByName(tableName);
                    }
                    if (Objects.isNull(tableValues) || size == 0) continue block8;
                    logger.info("\u540c\u6b65" + tableName + "\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65" + size + "\u6761\u6570\u636e");
                    List hpartyCheckTokenPOList = GsonUtil.fromList((String)tableValues, HpartyCheckTokenPO[].class);
                    if (type == 1) {
                        ids = hpartyCheckTokenPOList.stream().map(p -> p.getPluginId()).collect(Collectors.toList());
                        this.hpartyCheckTokenMapper.deleteEntityByPluginIds(ids);
                    }
                    this.hpartyCheckTokenMapper.insertRecords(hpartyCheckTokenPOList);
                    continue block8;
                }
                case "hparty_check_append": {
                    List<Long> ids;
                    if (type == 0) {
                        this.tableMapper.trucateTableByName(tableName);
                    }
                    if (Objects.isNull(tableValues) || size == 0) continue block8;
                    logger.info("\u540c\u6b65" + tableName + "\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65" + size + "\u6761\u6570\u636e");
                    List hpartyCheckAppendPOList = GsonUtil.fromList((String)tableValues, HpartyCheckAppendPO[].class);
                    if (type == 1) {
                        ids = hpartyCheckAppendPOList.stream().map(p -> p.getPluginId()).collect(Collectors.toList());
                        this.hpartyCheckAppendMapper.deleteEntityByPluginIds(ids);
                    }
                    this.hpartyCheckAppendMapper.insertRecords(hpartyCheckAppendPOList);
                    continue block8;
                }
            }
            logger.info("\u5168\u91cf\u540c\u6b65\u6570\u636e\uff0c\u8868\u540d{}\u4e0d\u5b58\u5728", (Object)tableName);
        }
    }
}

