/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.plugin.PluginA;
import com.ohaotian.plugin.mapper.AbilityPluginExtIpMapper;
import com.ohaotian.plugin.model.po.AbilityPluginExtIpPO;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="ipPluginService")
public class IpPluginService
implements PluginA {
    private static final Logger log = LogManager.getLogger(IpPluginService.class);
    @Resource
    NodeInfoConfig nodeInfoConfig;
    @Resource
    AbilityPluginExtIpMapper abilityPluginExtIpMapper;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            AbilityPluginBO abilityPluginBO = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "ip".equalsIgnoreCase(bo.getPluginType())).findAny().orElse(null);
            if (Objects.isNull(abilityPluginBO)) {
                log.debug("ip\u6821\u9a8c\u901a\u8fc7-\u672a\u8ba2\u8d2d");
                return;
            }
            AppBO appBO = msgContext.getSelfDefHeader().getApp();
            if (appBO != null) {
                String appCode = appBO.getAppCode();
                AbilityPluginExtIpPO abilityPluginExtIpPO = new AbilityPluginExtIpPO();
                abilityPluginExtIpPO.setPluginId(abilityPluginBO.getPluginId());
                abilityPluginExtIpPO.setAppCode(appCode);
                abilityPluginExtIpPO.setAppHirerId(this.nodeInfoConfig.getHireId());
                abilityPluginExtIpPO.setClusterId(this.nodeInfoConfig.getClusterId());
                abilityPluginExtIpPO = this.abilityPluginExtIpMapper.queryLimitOne(abilityPluginExtIpPO);
                if (abilityPluginExtIpPO == null || abilityPluginExtIpPO.getIpWhileList() == null || abilityPluginExtIpPO.getIpWhileList().length() == 0) {
                    log.debug("ip\u6821\u9a8c\u672a\u901a\u8fc7-\u4e0d\u5b58\u5728\u5408\u6cd5Ip");
                    throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":IpPluginService >>> ip\u6821\u9a8c\u672a\u901a\u8fc7-\u4e0d\u5b58\u5728\u5408\u6cd5Ip"}));
                }
                String ip = msgContext.getTlogReqHeader().getFromIp();
                String[] ips = abilityPluginExtIpPO.getIpWhileList().split(",");
                if (Arrays.asList(ips).contains(ip)) {
                    log.debug("ip\u6821\u9a8c\u901a\u8fc7-ip\u5408\u6cd5-ip: " + ip);
                    return;
                }
                log.debug("ip\u6821\u9a8c\u672a\u901a\u8fc7-ip\u4e0d\u5408\u6cd5-ip: " + ip);
                throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":IpPluginService >>> ip(" + ip + ")\u6821\u9a8c\u672a\u901a\u8fc7-ip\u4e0d\u5408\u6cd5"}));
            }
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("IP\u6821\u9a8c\u672a\u901a\u8fc7" + e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":IpPluginService >>> IP\u6821\u9a8c\u672a\u901a\u8fc7-IP\u6821\u9a8c\u5f02\u5e38"}));
        }
    }
}

