/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.plugin.PluginC;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="jdHpartyCheck")
public class JdHpartyCheckService
implements PluginC {
    private static final Logger log = LogManager.getLogger(JdHpartyCheckService.class);
    @Value(value="${jd.default.orgId:400000010000062675}")
    private String jdDefaultOrgid;
    @Value(value="${jd.default.param:orgId}")
    private String jdDefaultParam;
    @Resource
    private CacheClient cacheClient;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "jdHpartyCheck".equalsIgnoreCase(bo.getPluginType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(abilityPluginBOList)) {
                log.debug("jdHpartyCheck\u6821\u9a8c\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
                return;
            }
            TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
            String value = ReflectBeanValueUtil.getValue((Object)tlogReqHeader.getReqObj(msgContext), (String)"hsn") + "";
            if (!"null".equals(value) && !value.contains("jd")) {
                log.debug("jdHpartyCheckService : \u975e\u6b64\u5206\u533a\u63d2\u4ef6\uff01\uff01\uff01{}", (Object)value);
                return;
            }
            log.info("jdHpartyCheckService : \u6267\u884c\u5206\u533a\u63d2\u4ef6 --> {}", (Object)value);
            RegionBO regionBO = msgContext.getSelfDefHeader().getRegionBO();
            String regionCode = regionBO.getRegionCode();
            String pluginId = abilityPluginBOList.stream().map(a -> String.valueOf(a.getPluginId())).findFirst().get();
            JdHpartyCheckTokenPO queryCondition = new JdHpartyCheckTokenPO();
            queryCondition.setPluginId(StringUtils.isNotBlank((CharSequence)pluginId) ? Long.parseLong(pluginId) : 0L);
            SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
            HashMap reqMap = Maps.newHashMap();
            Map req = this.json2Map(new String(tlogReqHeader.getReqData(), "UTF-8"));
            Object o = req.get(this.jdDefaultParam);
            if (o != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(o))) {
                queryCondition.setOrgid(String.valueOf(o));
            } else {
                queryCondition.setOrgid(this.jdDefaultOrgid);
                req.put(this.jdDefaultParam, this.jdDefaultOrgid);
            }
            String key = this.constantBaseVersion.getATP() + "jdHpartyCheck-" + this.nodeInfoConfig.getClusterId() + "-" + queryCondition.getOrgid() + "-" + regionCode;
            Object data = this.cacheClient.get(key);
            if (ObjectUtils.isEmpty((Object)data)) {
                throw new AbilityException(CodeMsg.REDIS_TOKEN_ERROR.fillArgs(new Object[]{"region:" + regionCode + ",ordId:" + queryCondition.getOrgid()}));
            }
            AbilityRedisTokenDataBo abilityRedisTokenDataBo = (AbilityRedisTokenDataBo)GsonUtil.fromJson((String)data.toString(), AbilityRedisTokenDataBo.class);
            req.forEach((k, y) -> reqMap.put(k, y));
            reqMap.put("token", abilityRedisTokenDataBo.getToken());
            reqMap.put("appkey", abilityRedisTokenDataBo.getClientId());
            tlogReqHeader.setReqData(GsonUtil.toJson((Object)reqMap).getBytes("UTF-8"));
            selfDefHeader.getSelfDefMap().put("Content-Type", "application/x-www-form-urlencoded");
            log.debug("\u8c03\u7528\u843d\u5730\u62a5\u6587\u4e3a:" + new String(tlogReqHeader.getReqData(), "UTF-8"));
            msgContext.setIsAddToken(Boolean.TRUE);
            msgContext.setTlogReqHeader(tlogReqHeader);
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("JDhpartyCheck\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":JDhpartyCheckService >>> JDhpartyCheck\u63d2\u4ef6\u5f02\u5e38:"}) + e.getMessage());
        }
    }

    private String map2form(Map map) {
        StringBuffer s = new StringBuffer(16);
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                s.append(k).append("=").append(JSONObject.fromObject((Object)v)).append("&");
            } else if (v instanceof List) {
                s.append(k).append("=").append(JSONArray.fromObject((Object)v)).append("&");
            } else {
                s.append(k).append("=").append(v).append("&");
            }
        });
        return s.toString().substring(0, s.length() - 1);
    }

    private Map json2Map(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.readValue(json, Map.class);
        return map;
    }

    private void insertJDToken() {
        JdHpartyCheckTokenPO insetTokenPO = new JdHpartyCheckTokenPO();
        insetTokenPO.setAccessToken("2");
        insetTokenPO.setPluginId(5L);
        insetTokenPO.setClientId("1");
        insetTokenPO.setRegionCode("yaoayo1");
        insetTokenPO.setUserName("root");
    }

    public String getJdDefaultOrgid() {
        return this.jdDefaultOrgid;
    }

    public String getJdDefaultParam() {
        return this.jdDefaultParam;
    }

    public CacheClient getCacheClient() {
        return this.cacheClient;
    }

    public NodeInfoConfig getNodeInfoConfig() {
        return this.nodeInfoConfig;
    }

    public ConstantBaseVersion getConstantBaseVersion() {
        return this.constantBaseVersion;
    }

    public void setJdDefaultOrgid(String jdDefaultOrgid) {
        this.jdDefaultOrgid = jdDefaultOrgid;
    }

    public void setJdDefaultParam(String jdDefaultParam) {
        this.jdDefaultParam = jdDefaultParam;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public void setNodeInfoConfig(NodeInfoConfig nodeInfoConfig) {
        this.nodeInfoConfig = nodeInfoConfig;
    }

    public void setConstantBaseVersion(ConstantBaseVersion constantBaseVersion) {
        this.constantBaseVersion = constantBaseVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdHpartyCheckService)) {
            return false;
        }
        JdHpartyCheckService other = (JdHpartyCheckService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jdDefaultOrgid = this.getJdDefaultOrgid();
        String other$jdDefaultOrgid = other.getJdDefaultOrgid();
        if (this$jdDefaultOrgid == null ? other$jdDefaultOrgid != null : !this$jdDefaultOrgid.equals(other$jdDefaultOrgid)) {
            return false;
        }
        String this$jdDefaultParam = this.getJdDefaultParam();
        String other$jdDefaultParam = other.getJdDefaultParam();
        if (this$jdDefaultParam == null ? other$jdDefaultParam != null : !this$jdDefaultParam.equals(other$jdDefaultParam)) {
            return false;
        }
        CacheClient this$cacheClient = this.getCacheClient();
        CacheClient other$cacheClient = other.getCacheClient();
        if (this$cacheClient == null ? other$cacheClient != null : !this$cacheClient.equals(other$cacheClient)) {
            return false;
        }
        NodeInfoConfig this$nodeInfoConfig = this.getNodeInfoConfig();
        NodeInfoConfig other$nodeInfoConfig = other.getNodeInfoConfig();
        if (this$nodeInfoConfig == null ? other$nodeInfoConfig != null : !this$nodeInfoConfig.equals(other$nodeInfoConfig)) {
            return false;
        }
        ConstantBaseVersion this$constantBaseVersion = this.getConstantBaseVersion();
        ConstantBaseVersion other$constantBaseVersion = other.getConstantBaseVersion();
        return !(this$constantBaseVersion == null ? other$constantBaseVersion != null : !this$constantBaseVersion.equals(other$constantBaseVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdHpartyCheckService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jdDefaultOrgid = this.getJdDefaultOrgid();
        result = result * 59 + ($jdDefaultOrgid == null ? 43 : $jdDefaultOrgid.hashCode());
        String $jdDefaultParam = this.getJdDefaultParam();
        result = result * 59 + ($jdDefaultParam == null ? 43 : $jdDefaultParam.hashCode());
        CacheClient $cacheClient = this.getCacheClient();
        result = result * 59 + ($cacheClient == null ? 43 : $cacheClient.hashCode());
        NodeInfoConfig $nodeInfoConfig = this.getNodeInfoConfig();
        result = result * 59 + ($nodeInfoConfig == null ? 43 : $nodeInfoConfig.hashCode());
        ConstantBaseVersion $constantBaseVersion = this.getConstantBaseVersion();
        result = result * 59 + ($constantBaseVersion == null ? 43 : $constantBaseVersion.hashCode());
        return result;
    }

    public String toString() {
        return "JdHpartyCheckService(jdDefaultOrgid=" + this.getJdDefaultOrgid() + ", jdDefaultParam=" + this.getJdDefaultParam() + ", cacheClient=" + this.getCacheClient() + ", nodeInfoConfig=" + this.getNodeInfoConfig() + ", constantBaseVersion=" + this.getConstantBaseVersion() + ")";
    }
}

