/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.config;

import com.ohaotian.abilitylog.config.DatabaseInfo;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class MyJDBCTempLateFactory {
    private static Logger logger = LogManager.getLogger(MyJDBCTempLateFactory.class);
    private static HikariDataSource hikariDataSource;
    private static JdbcTemplate jdbcTemplate;
    @Resource
    DatabaseInfo databaseInfo;

    public MyJDBCTempLateFactory() {
        try {
            HikariDataSource dataSource;
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setJdbcUrl(this.databaseInfo.getJdbcUrl());
            hikariConfig.setDriverClassName(this.databaseInfo.getDriverClassName());
            hikariConfig.setUsername(this.databaseInfo.getUsername());
            hikariConfig.setPassword(this.databaseInfo.getPassword());
            hikariConfig.setMaximumPoolSize(this.databaseInfo.getMaxPoolSize().intValue());
            hikariConfig.setMinimumIdle(this.databaseInfo.getMinIdle().intValue());
            hikariConfig.setAutoCommit(this.databaseInfo.getAutoCommit().booleanValue());
            hikariConfig.setIdleTimeout(this.databaseInfo.getIdleTimeout().longValue());
            hikariConfig.setMaxLifetime(this.databaseInfo.getMaxLifetime().longValue());
            hikariConfig.setPoolName(this.databaseInfo.getPoolName());
            hikariConfig.setConnectionTimeout(this.databaseInfo.getConnectionTimeout().longValue());
            hikariConfig.setConnectionTestQuery(this.databaseInfo.getConnectionTestQuery());
            hikariConfig.setValidationTimeout(5000L);
            hikariConfig.setLeakDetectionThreshold(500000L);
            hikariDataSource = dataSource = new HikariDataSource(hikariConfig);
        }
        catch (Exception e) {
            logger.error("\u65e5\u5fd7\u5e93\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    public static JdbcTemplate getJdbcTemplate() {
        if (jdbcTemplate == null) {
            jdbcTemplate = new JdbcTemplate((DataSource)hikariDataSource);
        }
        return jdbcTemplate;
    }
}

