/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.util;

import com.ohaotian.abilitycommon.util.ExecutorServiceFactory;
import com.ohaotian.abilitylog.bo.TlogInfo;
import com.ohaotian.abilitylog.config.MyJDBCTempLateFactory;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;

public class TLogUtil {
    private static Logger logger = LogManager.getLogger(TLogUtil.class);
    private static ExecutorService service = ExecutorServiceFactory.getInstance().createCustomThreadPool();

    public static void requestInLog(TlogInfo tlogInfo) {
        service.execute(new SaveToDbThread("REQUEST_IN_SQL", tlogInfo));
    }

    public static void requestOutLog(TlogInfo tlogInfo) {
        service.execute(new SaveToDbThread("REQUEST_OUT_SQL", tlogInfo));
    }

    public static void respondInLog(TlogInfo tlogInfo) {
        service.execute(new SaveToDbThread("RESPOND_IN_SQL", tlogInfo));
    }

    public static void respondOutLog(TlogInfo tlogInfo) {
        service.execute(new SaveToDbThread("RESPOND_OUT_SQL", tlogInfo));
    }

    static class SaveToDbThread
    implements Runnable {
        private static final String REQUEST_IN_SQL = "INSERT INTO t_request_in( log_type, trace_id, success_flag, ability_ename, ability_name, ability_version, ext_one, ext_one_name, ext_two, ext_two_name, ext_three, ext_three_name, ext_four, ext_four_name, ext_five, ext_five_name, ext_six, ext_six_name, ext_seven, ext_seven_name, ext_eight, ext_eigit_name, ext_nine, ext_nine_name, ext_ten, ext_ten_name, cluster_id, join_time, send_time, receive_time, respond_time, request_ip, platform_ip, platform_port, request_method, input_protocal, output_protocal, cosumer_app_code, cosumer_app_name, cosumer_app_ext_one, cosumer_app_ext_one_name, cosumer_app_ext_two, cosumer_app_ext_two_name, cosumer_app_ext_three, cosumer_app_ext_three_name, cosumer_app_ext_four, cosumer_app_ext_four_name, cosumer_app_ext_five, cosumer_app_ext_five_name, provider_app_code, provider_app_name, provider_app_ext_one, provider_app_ext_one_name, provider_app_ext_two, provider_app_ext_two_name, provider_app_ext_three, provider_app_ext_three_name, provider_app_ext_four, provider_app_ext_four_name, provider_app_ext_five, provider_app_ext_five_name, region_code, region_name, drop_ip, drop_port, url, send_method, request_message, request_header_info, send_message, send_header_info, recieve_message, recieve_header_info, respond_message, respond_header_info, error_msg) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        private static final String REQUEST_OUT_SQL = "INSERT INTO t_request_out( log_type, trace_id, success_flag, ability_ename, ability_name, ability_version, ext_one, ext_one_name, ext_two, ext_two_name, ext_three, ext_three_name, ext_four, ext_four_name, ext_five, ext_five_name, ext_six, ext_six_name, ext_seven, ext_seven_name, ext_eight, ext_eigit_name, ext_nine, ext_nine_name, ext_ten, ext_ten_name, cluster_id, join_time, send_time, receive_time, respond_time, request_ip, platform_ip, platform_port, request_method, input_protocal, output_protocal, cosumer_app_code, cosumer_app_name, cosumer_app_ext_one, cosumer_app_ext_one_name, cosumer_app_ext_two, cosumer_app_ext_two_name, cosumer_app_ext_three, cosumer_app_ext_three_name, cosumer_app_ext_four, cosumer_app_ext_four_name, cosumer_app_ext_five, cosumer_app_ext_five_name, provider_app_code, provider_app_name, provider_app_ext_one, provider_app_ext_one_name, provider_app_ext_two, provider_app_ext_two_name, provider_app_ext_three, provider_app_ext_three_name, provider_app_ext_four, provider_app_ext_four_name, provider_app_ext_five, provider_app_ext_five_name, region_code, region_name, drop_ip, drop_port, url, send_method, request_message, request_header_info, send_message, send_header_info, recieve_message, recieve_header_info, respond_message, respond_header_info, error_msg) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        private static final String RESPOND_IN_SQL = "INSERT INTO t_respond_in( log_type, trace_id, success_flag, ability_ename, ability_name, ability_version, ext_one, ext_one_name, ext_two, ext_two_name, ext_three, ext_three_name, ext_four, ext_four_name, ext_five, ext_five_name, ext_six, ext_six_name, ext_seven, ext_seven_name, ext_eight, ext_eigit_name, ext_nine, ext_nine_name, ext_ten, ext_ten_name, cluster_id, join_time, send_time, receive_time, respond_time, request_ip, platform_ip, platform_port, request_method, input_protocal, output_protocal, cosumer_app_code, cosumer_app_name, cosumer_app_ext_one, cosumer_app_ext_one_name, cosumer_app_ext_two, cosumer_app_ext_two_name, cosumer_app_ext_three, cosumer_app_ext_three_name, cosumer_app_ext_four, cosumer_app_ext_four_name, cosumer_app_ext_five, cosumer_app_ext_five_name, provider_app_code, provider_app_name, provider_app_ext_one, provider_app_ext_one_name, provider_app_ext_two, provider_app_ext_two_name, provider_app_ext_three, provider_app_ext_three_name, provider_app_ext_four, provider_app_ext_four_name, provider_app_ext_five, provider_app_ext_five_name, region_code, region_name, drop_ip, drop_port, url, send_method, request_message, request_header_info, send_message, send_header_info, recieve_message, recieve_header_info, respond_message, respond_header_info, error_msg) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        private static final String RESPOND_OUT_SQL = "INSERT INTO t_respond_out( log_type, trace_id, success_flag, ability_ename, ability_name, ability_version, ext_one, ext_one_name, ext_two, ext_two_name, ext_three, ext_three_name, ext_four, ext_four_name, ext_five, ext_five_name, ext_six, ext_six_name, ext_seven, ext_seven_name, ext_eight, ext_eigit_name, ext_nine, ext_nine_name, ext_ten, ext_ten_name, cluster_id, join_time, send_time, receive_time, respond_time, request_ip, platform_ip, platform_port, request_method, input_protocal, output_protocal, cosumer_app_code, cosumer_app_name, cosumer_app_ext_one, cosumer_app_ext_one_name, cosumer_app_ext_two, cosumer_app_ext_two_name, cosumer_app_ext_three, cosumer_app_ext_three_name, cosumer_app_ext_four, cosumer_app_ext_four_name, cosumer_app_ext_five, cosumer_app_ext_five_name, provider_app_code, provider_app_name, provider_app_ext_one, provider_app_ext_one_name, provider_app_ext_two, provider_app_ext_two_name, provider_app_ext_three, provider_app_ext_three_name, provider_app_ext_four, provider_app_ext_four_name, provider_app_ext_five, provider_app_ext_five_name, region_code, region_name, drop_ip, drop_port, url, send_method, request_message, request_header_info, send_message, send_header_info, recieve_message, recieve_header_info, respond_message, respond_header_info, error_msg) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String sqlName;
        TlogInfo tlogInfo;

        public SaveToDbThread(String sqlName, TlogInfo tlogInfo) {
            this.sqlName = sqlName;
            this.tlogInfo = tlogInfo;
        }

        @Override
        public void run() {
            try {
                String sql;
                switch (this.sqlName) {
                    case "REQUEST_OUT_SQL": {
                        sql = REQUEST_OUT_SQL;
                        break;
                    }
                    case "RESPOND_IN_SQL": {
                        sql = RESPOND_IN_SQL;
                        break;
                    }
                    case "RESPOND_OUT_SQL": {
                        sql = RESPOND_OUT_SQL;
                        break;
                    }
                    default: {
                        sql = REQUEST_IN_SQL;
                    }
                }
                JdbcTemplate jdbcTemplate = MyJDBCTempLateFactory.getJdbcTemplate();
                jdbcTemplate.update(sql, new Object[]{this.tlogInfo.getLogType(), this.tlogInfo.getTraceId(), this.tlogInfo.getSuccessFlag(), this.tlogInfo.getAbilityEname(), this.tlogInfo.getAbilityName(), this.tlogInfo.getAbilityVersion(), this.tlogInfo.getExtOne(), this.tlogInfo.getExtOneName(), this.tlogInfo.getExtTwo(), this.tlogInfo.getExtTwoName(), this.tlogInfo.getExtThree(), this.tlogInfo.getExtThreeName(), this.tlogInfo.getExtFour(), this.tlogInfo.getExtFourName(), this.tlogInfo.getExtFive(), this.tlogInfo.getExtFiveName(), this.tlogInfo.getExtSix(), this.tlogInfo.getExtSixName(), this.tlogInfo.getExtSeven(), this.tlogInfo.getExtSevenName(), this.tlogInfo.getExtEight(), this.tlogInfo.getExtEightName(), this.tlogInfo.getExtNine(), this.tlogInfo.getExtNineName(), this.tlogInfo.getExtTen(), this.tlogInfo.getExtTenName(), this.tlogInfo.getClusterId(), this.tlogInfo.getJoinTime(), this.tlogInfo.getSendTime(), this.tlogInfo.getReceiveTime(), this.tlogInfo.getRespondTime(), this.tlogInfo.getRequestIp(), this.tlogInfo.getPlatformIp(), this.tlogInfo.getPlatformPort(), this.tlogInfo.getRequestMethod(), this.tlogInfo.getInputProtocal(), this.tlogInfo.getOutputProtocal(), this.tlogInfo.getCosumerAppCode(), this.tlogInfo.getCosumerAppName(), this.tlogInfo.getCosumerAppExtOne(), this.tlogInfo.getCosumerAppExtOneName(), this.tlogInfo.getCosumerAppExtTwo(), this.tlogInfo.getCosumerAppExtTwoName(), this.tlogInfo.getCosumerAppExtThree(), this.tlogInfo.getCosumerAppExtThreeName(), this.tlogInfo.getCosumerAppExtFour(), this.tlogInfo.getCosumerAppExtFourName(), this.tlogInfo.getCosumerAppExtFive(), this.tlogInfo.getCosumerAppExtFiveName(), this.tlogInfo.getProviderAppCode(), this.tlogInfo.getProviderAppName(), this.tlogInfo.getProviderAppExtOne(), this.tlogInfo.getProviderAppExtOneName(), this.tlogInfo.getProviderAppExtTwo(), this.tlogInfo.getProviderAppExtTwoName(), this.tlogInfo.getProviderAppExtThree(), this.tlogInfo.getProviderAppExtThreeName(), this.tlogInfo.getProviderAppExtFour(), this.tlogInfo.getProviderAppExtFourName(), this.tlogInfo.getProviderAppExtFive(), this.tlogInfo.getProviderAppExtFiveName(), this.tlogInfo.getRegionCode(), this.tlogInfo.getRegionName(), this.tlogInfo.getDropIp(), this.tlogInfo.getDropPort(), this.tlogInfo.getUrl(), this.tlogInfo.getSendMethod(), this.tlogInfo.getRequestMessage(), this.tlogInfo.getRequestHeaderInfo(), this.tlogInfo.getSendMessage(), this.tlogInfo.getSendHeaderInfo(), this.tlogInfo.getRecieveMessage(), this.tlogInfo.getRecieveHeaderInfo(), this.tlogInfo.getRespondMessage(), this.tlogInfo.getRespondHeaderInfo(), this.tlogInfo.getErrorMsg()});
            }
            catch (Exception e) {
                logger.error("\u65e5\u5fd7\u5165\u5e93\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

