/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.util;

import com.ohaotian.abilitylog.bo.TlogInfo;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TLogUtil {
    private static final Logger log = LoggerFactory.getLogger(TLogUtil.class);
    private static org.apache.logging.log4j.Logger requestInLog = LogManager.getLogger((String)"requestInESLog001");
    private static org.apache.logging.log4j.Logger requestOutLog = LogManager.getLogger((String)"requestOutESLog002");
    private static org.apache.logging.log4j.Logger respondInLog = LogManager.getLogger((String)"respondInESLog003");
    private static org.apache.logging.log4j.Logger respondOutLog = LogManager.getLogger((String)"respondOutESLog004");
    @Qualifier(value="esLog4jExecutorService")
    @Autowired
    private ExecutorService esLog4jExecutor;
    private static ExecutorService service;

    @PostConstruct
    public void initPrintLog() {
        log.info("\u521d\u59cb\u5316TLogUtil.......");
        service = this.esLog4jExecutor;
    }

    public static void requestInLog(TlogInfo tlogInfo) {
        service.execute(new SaveToESLocalThread(requestInLog, tlogInfo));
    }

    public static void requestOutLog(TlogInfo tlogInfo) {
        service.execute(new SaveToESLocalThread(requestOutLog, tlogInfo));
    }

    public static void respondInLog(TlogInfo tlogInfo) {
        service.execute(new SaveToESLocalThread(respondInLog, tlogInfo));
    }

    public static void respondOutLog(TlogInfo tlogInfo) {
        service.execute(new SaveToESLocalThread(respondOutLog, tlogInfo));
    }

    static class SaveToESLocalThread
    implements Runnable {
        org.apache.logging.log4j.Logger logger;
        TlogInfo tlogInfo;

        public SaveToESLocalThread(org.apache.logging.log4j.Logger logger, TlogInfo tlogInfo) {
            this.logger = logger;
            this.tlogInfo = tlogInfo;
        }

        @Override
        public void run() {
            this.logger.info(this.tlogInfo.toString());
        }
    }
}

