/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
public class EsToolThreadPollManager {
    private static final Logger log = LoggerFactory.getLogger(EsToolThreadPollManager.class);
    @Value(value="${es.executor.corePoolSize:50}")
    private int corePoolSize;
    @Value(value="${es.executor.maximumPoolSize:100}")
    private int maximumPoolSize;
    @Value(value="${es.executor.keepAliveTime:5}")
    private long keepAliveTime;
    @Value(value="${es.executor.queueCapacity:1000}")
    private int queueCapacity;

    @Bean(value={"esLog4jExecutorService"})
    public ExecutorService mqConsumerExecutorService() {
        log.info("initialization esLog4jExecutorService");
        return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.queueCapacity), new ThreadFactory(){
            final AtomicInteger sn = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("ES_LOG4J_THREAD-NO_" + this.sn.incrementAndGet());
                return t;
            }
        });
    }
}

