/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.util;

import com.ohaotian.abilitycommon.util.ExecutorServiceFactory;
import com.ohaotian.abilitylog.bo.TlogInfo;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TLogUtil {
    private static final Logger log = LoggerFactory.getLogger(TLogUtil.class);
    private static final org.apache.logging.log4j.Logger REQUEST_IN_LOG = LogManager.getLogger((String)"requestInLog001");
    private static final org.apache.logging.log4j.Logger REQUEST_OUT_LOG = LogManager.getLogger((String)"requestOutLog002");
    private static final org.apache.logging.log4j.Logger RESPOND_IN_LOG = LogManager.getLogger((String)"respondInLog003");
    private static final org.apache.logging.log4j.Logger RESPOND_OUT_LOG = LogManager.getLogger((String)"respondOutLog004");
    private static final ExecutorService SERVICE = ExecutorServiceFactory.getInstance().createCustomThreadPool();

    public static void requestInLog(TlogInfo tlogInfo) {
        SERVICE.execute(new SaveToFileThread(REQUEST_IN_LOG, tlogInfo));
    }

    public static void requestOutLog(TlogInfo tlogInfo) {
        SERVICE.execute(new SaveToFileThread(REQUEST_OUT_LOG, tlogInfo));
    }

    public static void respondInLog(TlogInfo tlogInfo) {
        SERVICE.execute(new SaveToFileThread(RESPOND_IN_LOG, tlogInfo));
    }

    public static void respondOutLog(TlogInfo tlogInfo) {
        SERVICE.execute(new SaveToFileThread(RESPOND_OUT_LOG, tlogInfo));
    }

    static class SaveToFileThread
    implements Runnable {
        org.apache.logging.log4j.Logger logger;
        TlogInfo tlogInfo;
        @Value(value="${vega.transaction.open:true}")
        private Boolean publicOpenLog;

        public SaveToFileThread(org.apache.logging.log4j.Logger logger, TlogInfo tlogInfo) {
            this.logger = logger;
            this.tlogInfo = tlogInfo;
        }

        @Override
        public void run() {
            this.logger.info(this.tlogInfo.toString());
            if (Boolean.TRUE.equals(this.publicOpenLog)) {
                log.info(this.tlogInfo.toString());
            }
        }
    }
}

