/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.service.impl;

import com.ohaotian.abilitylog.config.FileBeatYmlConfig;
import com.ohaotian.abilitylog.service.InitFileBeatYmlService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitFileBeatYmlServiceImpl
implements InitFileBeatYmlService {
    private static final Logger log = LoggerFactory.getLogger(InitFileBeatYmlServiceImpl.class);
    @Autowired
    private FileBeatYmlConfig fileBeatYmlConfig;

    @Override
    public void doService(String linuxPath, String rootPath) {
        HashMap<String, String> map;
        String source;
        String[] split;
        Template filebeatTemplate;
        Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        try {
            configuration.setDirectoryForTemplateLoading(new File(linuxPath));
        }
        catch (IOException e) {
            log.error("elasticsearch \u8bbe\u7f6e\u6a21\u677f\u6587\u4ef6\u6240\u5728\u76ee\u5f55 \u5f02\u5e38:{}", (Object)e.getMessage());
            return;
        }
        configuration.setDefaultEncoding("utf-8");
        try {
            filebeatTemplate = configuration.getTemplate("filebeat_elasticsearch.ftl");
        }
        catch (IOException e) {
            log.error("elasticsearch \u52a0\u8f7d\u6a21\u677f \u5f02\u5e38:{}", (Object)e.getMessage());
            return;
        }
        String[] inputs = this.fileBeatYmlConfig.getInputs().split(",");
        String includeLines = "";
        String excludeLines = "";
        if (this.fileBeatYmlConfig.getEsIncludeLines().length() != 0) {
            includeLines = "include_lines: ['\"" + this.fileBeatYmlConfig.getEsIncludeLines().replace(",", "\"', '\"") + "\"']";
        }
        if (this.fileBeatYmlConfig.getEsExcludeLines().length() != 0) {
            excludeLines = "exclude_lines: ['\"" + this.fileBeatYmlConfig.getEsExcludeLines().replace(",", "\"', '\"") + "\"']";
        }
        ArrayList inputList = new ArrayList();
        String hosts = this.fileBeatYmlConfig.getEsHosts();
        String username = this.fileBeatYmlConfig.getEsUserName();
        String password = this.fileBeatYmlConfig.getEsPassWord();
        String[] indices = this.fileBeatYmlConfig.getEsIndex().split(",");
        ArrayList indexList = new ArrayList();
        String indexTime = this.fileBeatYmlConfig.getIndexTime();
        String dataPath = linuxPath + "/data_elasticsearch";
        String logsPath = linuxPath + "/logs_elasticsearch";
        for (String input : inputs) {
            split = input.split(":");
            String path = rootPath + split[0];
            source = split[1];
            map = new HashMap<String, String>();
            map.put("path", path);
            map.put("includeLines", includeLines);
            map.put("excludeLines", excludeLines);
            map.put("source", source);
            inputList.add(map);
        }
        for (String index : indices) {
            split = index.split(":");
            String name = split[0];
            source = split[1];
            map = new HashMap();
            map.put("name", name);
            map.put("time", indexTime);
            map.put("source", source);
            indexList.add(map);
        }
        try (FileWriter out = new FileWriter(new File(linuxPath + "/filebeat.yml"));){
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("inputList", inputList);
            map2.put("hosts", hosts);
            map2.put("username", username);
            map2.put("password", password);
            map2.put("indexList", indexList);
            map2.put("dataPath", dataPath);
            map2.put("logsPath", logsPath);
            filebeatTemplate.process(map2, (Writer)out);
        }
        catch (TemplateException | IOException e) {
            log.error("elasticsearch \u6587\u4ef6\u5bfc\u51fa\u751f\u6210\u5230linuxPath \u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

