/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.config;

import com.ohaotian.abilitylog.service.InitFileBeatYmlService;
import com.ohaotian.abilitylog.util.ResFileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;

@Service
public class InitTransactionGrab {
    private static final Logger log = LoggerFactory.getLogger(InitTransactionGrab.class);
    @Value(value="${ability.transaction.grab:false}")
    private Boolean enabled;
    @Value(value="${ability.transaction.os:linux}")
    private String osName;
    @Value(value="${ability.res.filebeat.path:data/filebeat}")
    private String resPath;
    @Autowired
    private InitFileBeatYmlService initFileBeatYmlService;

    public void start() throws IOException {
        String osNameNow = System.getProperty("os.name").toLowerCase(Locale.US);
        if (Boolean.TRUE.equals(this.enabled) && osNameNow.contains(this.osName)) {
            try {
                ApplicationHome applicationHome = new ApplicationHome(this.getClass());
                String rootPath = applicationHome.getSource().getParentFile().toString();
                String linuxPath = rootPath + "/filebeat";
                log.info("filebeat path\uff1a{}", (Object)linuxPath);
                boolean flag = Boolean.FALSE;
                if (new File(linuxPath).exists()) {
                    InitTransactionGrab.callShell("mv " + linuxPath + "/data_elasticsearch " + rootPath + "/filebeat_data_elasticsearch_bak");
                    flag = Boolean.TRUE;
                    FileSystemUtils.deleteRecursively((File)new File(linuxPath));
                    log.info("\u6e05\u9664\u5386\u53f2\u65e5\u5fd7\u6293\u53d6\u5de5\u5177\u5b8c\u6210\uff01");
                }
                ResFileUtil.batCopyFileFromRes(this.resPath, linuxPath);
                if (Boolean.TRUE.equals(flag)) {
                    InitTransactionGrab.callShell("mv " + rootPath + "/filebeat_data_elasticsearch_bak " + linuxPath + "/data_elasticsearch ");
                }
                this.initFileBeatYmlService.doService(linuxPath, rootPath);
                InitTransactionGrab.callShell("kill -9 `ps -ef|grep " + linuxPath + "/filebeat| grep -v grep |awk '{print $2}'`");
                InitTransactionGrab.callShell("chmod  -R go-w " + linuxPath);
                InitTransactionGrab.callShell("chmod  744 " + linuxPath + "/filebeat");
                InitTransactionGrab.callShell("nohup " + linuxPath + "/filebeat -e -c " + linuxPath + "/filebeat.yml > " + rootPath + "/filebeat.log 2>&1 &");
                log.info("{} \u6d41\u6c34\u65e5\u5fd7\u6293\u53d6\u542f\u52a8\uff01", (Object)osNameNow);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn("{} \u6d41\u6c34\u65e5\u5fd7\u6293\u53d6\u542f\u52a8\u5f02\u5e38\uff01", (Object)osNameNow);
            }
        } else {
            log.warn("{} \u6682\u4e0d\u652f\u6301,\u6d41\u6c34\u65e5\u5fd7\u6293\u53d6\u672a\u542f\u52a8\uff01", (Object)osNameNow);
        }
    }

    public static void callShell(String shellString) {
        log.info("linux exec\uff1a{}", (Object)shellString);
        String[] command = new String[]{"/bin/sh", "-c", shellString};
        try {
            Process process = Runtime.getRuntime().exec(command);
            int exitValue = process.waitFor();
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (0 != exitValue) {
                log.error("call shell failed. error code is : {}, description is : {}.", (Object)exitValue, (Object)error.readLine());
            } else {
                log.info("call shell successes. status code is : {}, description is : {}.", (Object)exitValue, (Object)input.readLine());
            }
            error.close();
            input.close();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

