filebeat.inputs:

<#list inputList as input>
  - type: log
    enabled: true
    paths:
      - ${input.path}
    fields:
      source: ${input.source}
</#list>


output.elasticsearch:
  hosts: ${host}
  username: ${username}
  password: ${password}
  allow_older_versions: "true"
  indices:
    <#list indexList as index>
    - index: "${index.name}-${index.time}"
      when.contains:
        fields:
          source: "${index.source}"
    </#list>


  bulk_max_size: 1000


processors:
  - decode_json_fields:
      fields: ['message']
      target: ''
      overwrite_keys: true

  - drop_fields:
      fields: ["message", "ecs", "agent", "log"]


setup.template.enabled: false
setup.ilm.enabled: false
json.keys_under_root: true
json.overwrite_keys: true