/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class ResFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ResFileUtil.class);

    private ResFileUtil() {
        throw new IllegalStateException("Utility class ResFileUtil");
    }

    public static void batCopyFileFromRes(String path, String targetPath) throws IOException {
        Resource[] resources;
        if (!new File(targetPath).exists()) {
            log.info("\u521b\u5efa\u6587\u4ef6\u5939\uff1a{}", (Object)targetPath);
            new File(targetPath).mkdir();
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : resources = resolver.getResources("classpath*:" + path + "/**")) {
            String uriFileName = resource.getURL().getFile();
            if (uriFileName.endsWith("/")) continue;
            InputStream stream = resource.getInputStream();
            String[] name = uriFileName.split(path);
            if (StringUtils.isNotBlank((CharSequence)targetPath) && !targetPath.startsWith("/")) {
                throw new RuntimeException("path\uff1a" + targetPath + " \u975e\u767d\u540d\u5355\u8def\u5f84\u5df2\u88ab\u62e6\u622a");
            }
            File target = ResourceUtils.getFile((String)(targetPath + "/" + name[1]));
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)target);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void makeFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            return;
        }
        if (path.endsWith(File.separator)) {
            return;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            return;
        }
        try {
            if (!file.createNewFile()) return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void write2File(InputStream is, String filePath) throws IOException {
        try (OutputStream os = Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
            int len = 8192;
            byte[] buffer = new byte[len];
            while ((len = is.read(buffer, 0, len)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        is.close();
    }

    public static File getFileFromClassPath(String path) throws IOException {
        File targetFile = new File(path);
        if (!targetFile.exists()) {
            File parent;
            if (targetFile.getParent() != null && !(parent = new File(targetFile.getParent())).exists()) {
                parent.mkdirs();
            }
            ClassPathResource resource = new ClassPathResource(path);
            try (InputStream initialStream = resource.getInputStream();
                 OutputStream outStream = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
                byte[] buffer = new byte[initialStream.available()];
                initialStream.read(buffer);
                outStream.write(buffer);
            }
        }
        return targetFile;
    }
}

