/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitylog.config;

import com.ohaotian.abilitylog.service.InitFileBeatYmlService;
import com.ohaotian.abilitylog.util.ResFileUtil;
import com.ohaotian.plugin.file.FileClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.ResourceUtils;

@Service
public class InitTransactionGrab {
    private static final Logger log = LoggerFactory.getLogger(InitTransactionGrab.class);
    @Value(value="${ability.transaction.grab:false}")
    private Boolean enabled;
    @Value(value="${ability.transaction.workplace.enabled:true}")
    private Boolean workplaceEnabled;
    @Value(value="${ability.transaction.grab.outs:elasticsearch}")
    private String grabOuts;
    @Value(value="${ability.transaction.os:linux}")
    private String osName;
    @Value(value="${ability.res.filebeat.path:data/filebeat}")
    private String resPath;
    @Autowired
    Map<String, InitFileBeatYmlService> initFileBeatYml = new ConcurrentHashMap<String, InitFileBeatYmlService>();
    @Value(value="${spool.res.filebeat.cloud:}")
    private String resPathCloud;
    @Autowired
    private FileClient fileClient;

    public void start() throws IOException {
        String osNameNow = System.getProperty("os.name").toLowerCase(Locale.US);
        if (Boolean.TRUE.equals(this.enabled) && osNameNow.contains(this.osName)) {
            try {
                File folder;
                ApplicationHome applicationHome = new ApplicationHome(this.getClass());
                String rootPath = applicationHome.getSource().getParentFile().toString();
                log.info("jar\u6839\u8def\u5f84:{}", (Object)rootPath);
                String logRootPath = rootPath;
                if (Boolean.TRUE.equals(this.workplaceEnabled)) {
                    logRootPath = System.getProperty("user.dir");
                }
                if (!(folder = new File(logRootPath + "/logs")).exists() || !folder.isDirectory()) {
                    logRootPath = rootPath;
                }
                log.info("\u65e5\u5fd7\u6839\u8def\u5f84:{}", (Object)(logRootPath + "/logs"));
                String linuxPath = rootPath + "/filebeat";
                log.info("filebeat\u7a0b\u5e8f\u8def\u5f84:{}", (Object)linuxPath);
                boolean flag = Boolean.FALSE;
                String[] fileBeatOuts = this.grabOuts.split(",");
                if (new File(linuxPath).exists()) {
                    for (String out : fileBeatOuts) {
                        InitTransactionGrab.callShell("mv " + linuxPath + "/data_" + out + " " + rootPath + "/filebeat_data_" + out + "_bak");
                        log.info("\u5907\u4efddata_" + out + "\u5b8c\u6210");
                    }
                    flag = Boolean.TRUE;
                    FileSystemUtils.deleteRecursively((File)new File(linuxPath));
                    log.info("\u6e05\u9664\u5386\u53f2\u65e5\u5fd7\u6293\u53d6\u5de5\u5177\u5b8c\u6210\uff01");
                }
                ResFileUtil.batCopyFileFromRes(this.resPath, linuxPath);
                if (StringUtils.isNotBlank((CharSequence)this.resPathCloud)) {
                    try {
                        log.info("\u4e91\u7aef\u4e0b\u8f7dfilebeat......\u4e0b\u8f7d\u8def\u5f84:{}", (Object)this.resPathCloud);
                        InputStream inputStream = this.fileClient.downLoadToInputStream(this.resPathCloud);
                        String resPathCloudStatic = linuxPath + "/filebeat";
                        log.info("\u4e91\u7aef\u4e0b\u8f7dfilebeat......\u4fdd\u5b58\u8def\u5f84:{}", (Object)resPathCloudStatic);
                        if (StringUtils.isNotBlank((CharSequence)resPathCloudStatic) && !resPathCloudStatic.startsWith("/")) {
                            throw new RuntimeException("path\uff1a" + resPathCloudStatic + " \u975e\u767d\u540d\u5355\u8def\u5f84\u5df2\u88ab\u62e6\u622a");
                        }
                        File target = ResourceUtils.getFile((String)resPathCloudStatic);
                        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)target);
                        log.info("\u4e91\u7aef\u4e0b\u8f7dfilebeat,\u4fdd\u5b58\u5b8c\u6210\uff01");
                    }
                    catch (Exception e) {
                        log.error("\u4e91\u7aef\u4e0b\u8f7dfilebeat,\u4fdd\u5b58\u5f02\u5e38\uff01");
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (Boolean.TRUE.equals(flag)) {
                    for (String out : fileBeatOuts) {
                        InitTransactionGrab.callShell("mv " + rootPath + "/filebeat_data_" + out + "_bak " + linuxPath + "/data_" + out);
                        log.info("\u6e05\u9664\u5907\u4efddata_" + out + "\u5b8c\u6210");
                    }
                }
                for (String out : fileBeatOuts) {
                    InitFileBeatYmlService initFileBeatYmlService = this.initFileBeatYml.get(out + "FilebeatService");
                    initFileBeatYmlService.doService(linuxPath, logRootPath);
                    log.info("\u6a21\u677f\u5316\u751f\u6210filebeat_" + out + ".yml\u5b8c\u6210");
                }
                InitTransactionGrab.callShell("kill -9 `ps -ef|grep " + linuxPath + "/filebeat| grep -v grep |awk '{print $2}'`");
                InitTransactionGrab.callShell("chmod  -R go-w " + linuxPath);
                InitTransactionGrab.callShell("chmod  744 " + linuxPath + "/filebeat");
                for (String out : fileBeatOuts) {
                    InitTransactionGrab.callShell("nohup " + linuxPath + "/filebeat -e -c " + linuxPath + "/filebeat_" + out + ".yml > " + rootPath + "/filebeat_" + out + ".log 2>&1 &");
                    log.info("{} \u6d41\u6c34\u65e5\u5fd7\u6293\u53d6\u542f\u52a8\uff01", (Object)out);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn("{} \u6d41\u6c34\u65e5\u5fd7\u6293\u53d6\u542f\u52a8\u5f02\u5e38\uff01", (Object)osNameNow);
            }
        } else {
            log.warn("{} \u6682\u4e0d\u652f\u6301,\u6d41\u6c34\u65e5\u5fd7\u6293\u53d6\u672a\u542f\u52a8\uff01", (Object)osNameNow);
        }
    }

    public static void callShell(String shellString) {
        log.info("linux exec\uff1a{}", (Object)shellString);
        try {
            if (!shellString.contains("/filebeat")) {
                throw new RuntimeException("\u5df2\u62e6\u622a\u672a\u6388\u6743\u547d\u4ee4\uff01tx:" + shellString);
            }
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", shellString);
            Process process = processBuilder.start();
            int exitValue = process.waitFor();
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (0 != exitValue) {
                log.error("call shell failed. error code is : {}, description is : {}.", (Object)exitValue, (Object)error.readLine());
            } else {
                log.info("call shell successes. status code is : {}, description is : {}.", (Object)exitValue, (Object)input.readLine());
            }
            error.close();
            input.close();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

