/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.plugin.PluginC;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.model.po.MultiHpartyCheckTokenPO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="multiTokenHPC")
public class MultiHpartyCheckService
implements PluginC {
    private static final Logger log = LogManager.getLogger(MultiHpartyCheckService.class);
    @Value(value="${multi.default.orgid:1000}")
    private String multiDefaultOrgId;
    @Value(value="${multi.default.param:orgId}")
    private String multiDefaultParam;
    @Resource
    private CacheClient cacheClient;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            log.debug("MultiHpartyCheckService -- > {}", (Object)"\u5f00\u59cb\u8fd0\u884c");
            List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "multiTokenHPC".equalsIgnoreCase(bo.getPluginType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(abilityPluginBOList)) {
                log.debug("multiTokenHPC-\u672a\u8ba2\u8d2d");
                return;
            }
            TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
            String value = ReflectBeanValueUtil.getValue((Object)tlogReqHeader.getReqObj(msgContext), (String)"hsn") + "";
            log.info("multiTokenHPC : \u6267\u884c\u5206\u533a\u63d2\u4ef6 --> {}", (Object)value);
            String pluginId = abilityPluginBOList.stream().map(a -> String.valueOf(a.getPluginId())).findFirst().get();
            MultiHpartyCheckTokenPO queryCondition = new MultiHpartyCheckTokenPO();
            queryCondition.setPluginId(StringUtils.isNotBlank((CharSequence)pluginId) ? Long.parseLong(pluginId) : 0L);
            SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
            RegionBO regionBO = msgContext.getSelfDefHeader().getRegionBO();
            String regionCode = regionBO.getRegionCode();
            HashMap reqMap = Maps.newHashMap();
            Map req = this.json2Map(new String(tlogReqHeader.getReqData(), "UTF-8"));
            Object o = req.get(this.multiDefaultParam);
            if (o != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(o))) {
                String orgId = String.valueOf(o);
                String key = this.constantBaseVersion.getATP() + "multiTokenHPC-" + this.nodeInfoConfig.getClusterId() + "-" + pluginId + "-" + orgId + "-" + regionCode;
                String s = this.cacheClient.get(key).toString();
                if (Objects.isNull(s)) {
                    orgId = this.multiDefaultOrgId;
                }
                queryCondition.setOrgId(orgId);
            } else {
                queryCondition.setOrgId(this.multiDefaultOrgId);
            }
            String key = this.constantBaseVersion.getATP() + "multiTokenHPC-" + this.nodeInfoConfig.getClusterId() + "-" + queryCondition.getPluginId() + "-" + queryCondition.getOrgId() + "-" + regionCode;
            Object data = this.cacheClient.get(key);
            if (ObjectUtils.isEmpty((Object)data)) {
                throw new AbilityException(CodeMsg.REDIS_TOKEN_ERROR.fillArgs(new Object[]{"ordId:" + queryCondition.getOrgId()}));
            }
            AbilityRedisTokenDataBo abilityRedisTokenDataBo = (AbilityRedisTokenDataBo)GsonUtil.fromJson((String)data.toString(), AbilityRedisTokenDataBo.class);
            req.forEach((k, y) -> reqMap.put(k, y));
            reqMap.put("token", abilityRedisTokenDataBo.getToken());
            reqMap.put("appkey", abilityRedisTokenDataBo.getClientId());
            switch (abilityRedisTokenDataBo.getCallProtocol().toString()) {
                case "0": {
                    tlogReqHeader.setReqData(GsonUtil.toJson((Object)reqMap).getBytes("UTF-8"));
                    break;
                }
                case "1": {
                    tlogReqHeader.setReqData(this.map2form(reqMap).getBytes("UTF-8"));
                    selfDefHeader.getSelfDefMap().put("Content-Type", "application/x-www-form-urlencoded");
                    break;
                }
                default: {
                    tlogReqHeader.setReqData(GsonUtil.toJson((Object)reqMap).getBytes("UTF-8"));
                }
            }
            log.debug("\u8c03\u7528\u843d\u5730\u62a5\u6587\u4e3a:" + new String(tlogReqHeader.getReqData(), "UTF-8"));
            msgContext.getEsbAbility().setIsAddToken(Boolean.TRUE);
            msgContext.setTlogReqHeader(tlogReqHeader);
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("multiTokenHPC\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":multiTokenHPCService >>> multiTokenHPC\u63d2\u4ef6\u5f02\u5e38:"}) + e.getMessage());
        }
    }

    private String map2form(Map map) {
        StringBuilder s = new StringBuilder();
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                s.append(k).append("=").append(JSONObject.fromObject((Object)v)).append("&");
            } else if (v instanceof List) {
                s.append(k).append("=").append(JSONArray.fromObject((Object)v)).append("&");
            } else {
                s.append(k).append("=").append(v).append("&");
            }
        });
        return s.toString().substring(0, s.length() - 1);
    }

    private Map json2Map(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.readValue(json, Map.class);
        return map;
    }

    public String getMultiDefaultOrgId() {
        return this.multiDefaultOrgId;
    }

    public String getMultiDefaultParam() {
        return this.multiDefaultParam;
    }

    public CacheClient getCacheClient() {
        return this.cacheClient;
    }

    public NodeInfoConfig getNodeInfoConfig() {
        return this.nodeInfoConfig;
    }

    public ConstantBaseVersion getConstantBaseVersion() {
        return this.constantBaseVersion;
    }

    public void setMultiDefaultOrgId(String multiDefaultOrgId) {
        this.multiDefaultOrgId = multiDefaultOrgId;
    }

    public void setMultiDefaultParam(String multiDefaultParam) {
        this.multiDefaultParam = multiDefaultParam;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public void setNodeInfoConfig(NodeInfoConfig nodeInfoConfig) {
        this.nodeInfoConfig = nodeInfoConfig;
    }

    public void setConstantBaseVersion(ConstantBaseVersion constantBaseVersion) {
        this.constantBaseVersion = constantBaseVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiHpartyCheckService)) {
            return false;
        }
        MultiHpartyCheckService other = (MultiHpartyCheckService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$multiDefaultOrgId = this.getMultiDefaultOrgId();
        String other$multiDefaultOrgId = other.getMultiDefaultOrgId();
        if (this$multiDefaultOrgId == null ? other$multiDefaultOrgId != null : !this$multiDefaultOrgId.equals(other$multiDefaultOrgId)) {
            return false;
        }
        String this$multiDefaultParam = this.getMultiDefaultParam();
        String other$multiDefaultParam = other.getMultiDefaultParam();
        if (this$multiDefaultParam == null ? other$multiDefaultParam != null : !this$multiDefaultParam.equals(other$multiDefaultParam)) {
            return false;
        }
        CacheClient this$cacheClient = this.getCacheClient();
        CacheClient other$cacheClient = other.getCacheClient();
        if (this$cacheClient == null ? other$cacheClient != null : !this$cacheClient.equals(other$cacheClient)) {
            return false;
        }
        NodeInfoConfig this$nodeInfoConfig = this.getNodeInfoConfig();
        NodeInfoConfig other$nodeInfoConfig = other.getNodeInfoConfig();
        if (this$nodeInfoConfig == null ? other$nodeInfoConfig != null : !this$nodeInfoConfig.equals(other$nodeInfoConfig)) {
            return false;
        }
        ConstantBaseVersion this$constantBaseVersion = this.getConstantBaseVersion();
        ConstantBaseVersion other$constantBaseVersion = other.getConstantBaseVersion();
        return !(this$constantBaseVersion == null ? other$constantBaseVersion != null : !this$constantBaseVersion.equals(other$constantBaseVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiHpartyCheckService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $multiDefaultOrgId = this.getMultiDefaultOrgId();
        result = result * 59 + ($multiDefaultOrgId == null ? 43 : $multiDefaultOrgId.hashCode());
        String $multiDefaultParam = this.getMultiDefaultParam();
        result = result * 59 + ($multiDefaultParam == null ? 43 : $multiDefaultParam.hashCode());
        CacheClient $cacheClient = this.getCacheClient();
        result = result * 59 + ($cacheClient == null ? 43 : $cacheClient.hashCode());
        NodeInfoConfig $nodeInfoConfig = this.getNodeInfoConfig();
        result = result * 59 + ($nodeInfoConfig == null ? 43 : $nodeInfoConfig.hashCode());
        ConstantBaseVersion $constantBaseVersion = this.getConstantBaseVersion();
        result = result * 59 + ($constantBaseVersion == null ? 43 : $constantBaseVersion.hashCode());
        return result;
    }

    public String toString() {
        return "MultiHpartyCheckService(multiDefaultOrgId=" + this.getMultiDefaultOrgId() + ", multiDefaultParam=" + this.getMultiDefaultParam() + ", cacheClient=" + this.getCacheClient() + ", nodeInfoConfig=" + this.getNodeInfoConfig() + ", constantBaseVersion=" + this.getConstantBaseVersion() + ")";
    }
}

