/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.oauth2.Oauth2Config;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.plugin.PluginA;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="oauth2PluginService")
public class Oauth2PluginService
implements PluginA {
    private static final Logger log = LogManager.getLogger(Oauth2PluginService.class);
    @Resource
    private CacheClient cacheClient;
    @Resource
    private NodeInfoConfig nodeInfo;
    @Resource
    private Oauth2Config oauth2Config;

    public void doService(MsgContext msgContext) throws AbilityException {
        block6: {
            try {
                AbilityPluginBO abilityPluginBO = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "oauth2".equalsIgnoreCase(bo.getPluginType())).findAny().orElse(null);
                if (Objects.isNull(abilityPluginBO)) {
                    log.debug("oauth2\u6821\u9a8c\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
                    return;
                }
                AppBO appBO = msgContext.getSelfDefHeader().getApp();
                if (appBO != null) {
                    String appCode = appBO.getAppCode();
                    String key = this.nodeInfo.getClusterId() + "|" + appCode;
                    String accessToken = key + "|" + "accessToken";
                    String accesSecret = this.cacheClient.get(accessToken).toString();
                    if (StringUtils.isEmpty((CharSequence)accesSecret)) {
                        log.debug("Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-accessToken\u5df2\u7ecf\u8fc7\u671f");
                        throw new AbilityException("oauth2", ":Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-accessToken\u5df2\u7ecf\u8fc7\u671f");
                    }
                    break block6;
                }
                log.debug("Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-accessToken\u5df2\u7ecf\u8fc7\u671f");
                throw new AbilityException("oauth2", ":Oauth2Plugin >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7-accessToken\u5df2\u7ecf\u8fc7\u671f");
            }
            catch (AbilityException e) {
                log.error(e.codeMsg.getRspDesc());
                throw e;
            }
            catch (Exception e) {
                log.error("oauth2\u6821\u9a8c\u672a\u901a\u8fc7-oauth2\u6821\u9a8c\u5f02\u5e38:{}", (Throwable)e);
                throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":oauth2PluginService >>> oauth2\u6821\u9a8c\u672a\u901a\u8fc7" + e.getMessage()}));
            }
        }
    }
}

