/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.abilitycommon.config.system.SystemMap;
import com.ohaotian.abilitycommon.config.systemcode.SystemCodeMap;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.enums.PriorityEnum;
import com.ohaotian.abilitycommon.enums.SystemCodeTypeEnum;
import com.ohaotian.abilitycommon.enums.SystemCodeValueEnum;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SystemCodeValue;
import com.ohaotian.abilitycommon.plugin.PluginB;
import com.ohaotian.plugin.mapper.PluginPriorityMapper;
import com.ohaotian.plugin.model.po.PluginPriorityPO;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="priorityPluginService")
public class PriorityPluginService
implements PluginB {
    private static final Logger log = LogManager.getLogger(PriorityPluginService.class);
    @Resource
    PluginPriorityMapper pluginPriorityMapper;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            AbilityPluginBO abilityPluginBO = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "priority".equalsIgnoreCase(bo.getPluginType())).findAny().orElse(null);
            if (Objects.isNull(abilityPluginBO)) {
                log.debug("\u4f18\u5148\u7ea7\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
                return;
            }
            PluginPriorityPO pluginPriorityPO = new PluginPriorityPO();
            pluginPriorityPO.setAbilityPluginId(abilityPluginBO.getAbilityPluginId());
            PluginPriorityPO pluginPriorityPO1 = this.pluginPriorityMapper.queryLimitOne(pluginPriorityPO);
            if (Objects.isNull(pluginPriorityPO1)) {
                log.debug("\u8be5\u80fd\u529b\u6ca1\u6709\u914d\u7f6e\u4f18\u5148\u7ea7\u63d2\u4ef6\u8868\uff08\u6269\u5c55\u8868\uff09");
                throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> \u8be5\u80fd\u529b(%s)\u6ca1\u6709\u914d\u7f6e\u4f18\u5148\u7ea7\u63d2\u4ef6\u8868\uff08\u6269\u5c55\u8868\uff09"}).fillArgs(new Object[]{this.getClass().getSimpleName(), msgContext.getEsbAbility().getAbilityEname()}));
            }
            Integer abilityPriority = pluginPriorityPO1.getPriority();
            Integer resUsingRate = SystemMap.getSystemStatus().getResUsingRate();
            SystemCodeValue congestThresholdLow = SystemCodeMap.getSystemCode((String)SystemCodeTypeEnum.CONGEST_THRESHOLD.getCode(), (String)SystemCodeValueEnum.CONGEST_THRESHOLD_LOW.getCode());
            SystemCodeValue congestThresholdMedium = SystemCodeMap.getSystemCode((String)SystemCodeTypeEnum.CONGEST_THRESHOLD.getCode(), (String)SystemCodeValueEnum.CONGEST_THRESHOLD_MEDIUM.getCode());
            Integer congestThresholdLow_ = Integer.valueOf(congestThresholdLow.getDicValue());
            Integer congestThresholdMedium_ = Integer.valueOf(congestThresholdMedium.getDicValue());
            if (resUsingRate <= congestThresholdLow_) {
                log.debug("\u901a\u8fc7\uff0c\u5f53\u524d\u7cfb\u7edf\u62e5\u585e\u7a0b\u5ea6{}\u5c0f\u4e8e\u914d\u7f6e\u7684\u6700\u4f4e\u9608\u503c{}", (Object)resUsingRate, (Object)congestThresholdLow_);
                return;
            }
            if (resUsingRate > congestThresholdLow_ && resUsingRate <= congestThresholdMedium_) {
                if (abilityPriority.equals(Constants.Priority.PRIORITY_MEDIUM) || abilityPriority.equals(Constants.Priority.PRIORITY_HIGH)) {
                    log.debug("\u901a\u8fc7\uff0c\u5f53\u524d\u7cfb\u7edf\u62e5\u585e\u7a0b\u5ea6{}\u5728\u914d\u7f6e\u7684\u9608\u503c{}\u548c{}\u4e4b\u95f4\uff0c\u5f53\u524d\u80fd\u529b\u7684\u4f18\u5148\u7ea7\u4e3a{}", (Object)resUsingRate, (Object)congestThresholdLow_, (Object)congestThresholdMedium_, (Object)PriorityEnum.getPriorityValueByCode((int)abilityPriority));
                    return;
                }
                log.debug("\u4e0d\u901a\u8fc7\uff0c\u5f53\u524d\u7cfb\u7edf\u62e5\u585e\u7a0b\u5ea6{}\u5728\u914d\u7f6e\u7684\u9608\u503c{}\u548c{}\u4e4b\u95f4\uff0c\u5f53\u524d\u80fd\u529b\u7684\u4f18\u5148\u7ea7\u4e3a{}", (Object)resUsingRate, (Object)congestThresholdLow_, (Object)congestThresholdMedium_, (Object)PriorityEnum.getPriorityValueByCode((int)abilityPriority));
                throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> \u5f53\u524d\u80fd\u529b\u914d\u7f6e\u7684\u4f18\u5148\u7ea7(%s)\u672a\u80fd\u901a\u8fc7\u4f18\u5148\u7ea7\u63d2\u4ef6"}).fillArgs(new Object[]{this.getClass().getSimpleName(), PriorityEnum.getPriorityValueByCode((int)abilityPriority)}));
            }
            if (resUsingRate > congestThresholdMedium_) {
                if (abilityPriority.equals(Constants.Priority.PRIORITY_HIGH)) {
                    log.debug("\u901a\u8fc7\uff0c\u5f53\u524d\u7cfb\u7edf\u62e5\u585e\u7a0b\u5ea6{}\u5927\u4e8e\u914d\u7f6e\u7684\u9608\u503c{}\uff0c\u5f53\u524d\u80fd\u529b\u7684\u4f18\u5148\u7ea7\u4e3a{}", (Object)resUsingRate, (Object)congestThresholdMedium_, (Object)PriorityEnum.getPriorityValueByCode((int)abilityPriority));
                    return;
                }
                log.debug("\u4e0d\u901a\u8fc7\uff0c\u5f53\u524d\u7cfb\u7edf\u62e5\u585e\u7a0b\u5ea6{}\u5927\u4e8e\u914d\u7f6e\u7684\u9608\u503c{}\uff0c\u5f53\u524d\u80fd\u529b\u7684\u4f18\u5148\u7ea7\u4e3a{}", (Object)resUsingRate, (Object)congestThresholdMedium_, (Object)PriorityEnum.getPriorityValueByCode((int)abilityPriority));
                throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> \u5f53\u524d\u80fd\u529b\u914d\u7f6e\u7684\u4f18\u5148\u7ea7(%s)\u672a\u80fd\u901a\u8fc7\u4f18\u5148\u7ea7\u63d2\u4ef6"}).fillArgs(new Object[]{this.getClass().getSimpleName(), PriorityEnum.getPriorityValueByCode((int)abilityPriority)}));
            }
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("\u4f18\u5148\u7ea7\u63d2\u4ef6\u6267\u884c\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> " + e.getMessage()}).fillArgs(new Object[]{this.getClass().getSimpleName()}), (Throwable)e);
        }
    }
}

