/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.google.common.collect.Maps;
import com.ohaotian.abilitycommon.api.PluginApi;
import com.ohaotian.abilitycommon.api.RegionApi;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.js.MngHelper;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.plugin.PluginC;
import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import com.ohaotian.plugin.mapper.PluginRouteColumnMapper;
import com.ohaotian.plugin.mapper.PluginRouteExtMapper;
import com.ohaotian.plugin.mapper.PluginRouteMapper;
import com.ohaotian.plugin.model.po.PluginRouteColumnPO;
import com.ohaotian.plugin.model.po.PluginRouteExtPO;
import com.ohaotian.plugin.model.po.PluginRoutePO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="routePluginService")
public class RoutePluginService
implements PluginC {
    private static final Logger log = LogManager.getLogger(RoutePluginService.class);
    @Resource
    PluginRouteMapper pluginRouteMapper;
    @Resource
    PluginRouteColumnMapper pluginRouteColumnMapper;
    @Resource
    private RegionApi regionApi;
    @Resource
    PluginRouteExtMapper pluginRouteExtMapper;
    @Resource
    PluginApi pluginApi;
    @Value(value="${ability.MngHelper.compensation:3}")
    private int compensation;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "route".equalsIgnoreCase(bo.getPluginType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(abilityPluginBOList)) {
                log.debug("\u7070\u5ea6\u8def\u7531\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
                return;
            }
            for (AbilityPluginBO abilityPluginBO : abilityPluginBOList) {
                Integer regionType;
                Object regionCode;
                String argValue;
                PluginRouteColumnPO pluginRouteColumnPO1;
                Long pluginId = abilityPluginBO.getPluginId();
                PluginRoutePO pluginRoutePO = new PluginRoutePO();
                pluginRoutePO.setPluginId(pluginId);
                PluginRoutePO pluginRoutePO1 = this.pluginRouteMapper.queryLimitOne(pluginRoutePO);
                if (Objects.isNull(pluginRoutePO1)) {
                    log.debug("\u8be5\u80fd\u529b\u6ca1\u6709\u914d\u7f6e\u8def\u7531\u63d2\u4ef6\u8868\uff08\u6269\u5c55\u8868\uff09");
                    throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> \u8be5\u80fd\u529b(%s)\u6ca1\u6709\u914d\u7f6e\u8def\u7531\u63d2\u4ef6\u8868\uff08\u6269\u5c55\u8868\uff09"}).fillArgs(new Object[]{this.getClass().getSimpleName(), msgContext.getEsbAbility().getAbilityEname()}));
                }
                PluginRouteColumnPO pluginRouteColumnPO = new PluginRouteColumnPO();
                pluginRouteColumnPO.setAbilityPluginId(abilityPluginBO.getAbilityPluginId());
                HashMap map = Maps.newHashMap();
                Object reqObj = msgContext.getTlogReqHeader().getReqObj(msgContext);
                if (StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsFirst())) {
                    pluginRouteColumnPO.setColumnKey(pluginRoutePO1.getArgsFirst());
                    pluginRouteColumnPO1 = this.pluginRouteColumnMapper.queryLimitOne(pluginRouteColumnPO);
                    Object value1 = ReflectBeanValueUtil.getValue((Object)reqObj, (String)pluginRouteColumnPO1.getColumnPath());
                    argValue = String.valueOf(value1);
                    map.put("args1", argValue);
                }
                if (StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsSecond())) {
                    pluginRouteColumnPO.setColumnKey(pluginRoutePO1.getArgsSecond());
                    pluginRouteColumnPO1 = this.pluginRouteColumnMapper.queryLimitOne(pluginRouteColumnPO);
                    Object value2 = ReflectBeanValueUtil.getValue((Object)reqObj, (String)pluginRouteColumnPO1.getColumnPath());
                    argValue = String.valueOf(value2);
                    map.put("args2", argValue);
                }
                if (StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsThird())) {
                    pluginRouteColumnPO.setColumnKey(pluginRoutePO1.getArgsThird());
                    pluginRouteColumnPO1 = this.pluginRouteColumnMapper.queryLimitOne(pluginRouteColumnPO);
                    Object value3 = ReflectBeanValueUtil.getValue((Object)reqObj, (String)pluginRouteColumnPO1.getColumnPath());
                    argValue = String.valueOf(value3);
                    map.put("args3", argValue);
                }
                if (StringUtils.isNotBlank((CharSequence)pluginRoutePO1.getArgsFourth())) {
                    pluginRouteColumnPO.setColumnKey(pluginRoutePO1.getArgsFourth());
                    pluginRouteColumnPO1 = this.pluginRouteColumnMapper.queryLimitOne(pluginRouteColumnPO);
                    Object value4 = ReflectBeanValueUtil.getValue((Object)reqObj, (String)pluginRouteColumnPO1.getColumnPath());
                    argValue = String.valueOf(value4);
                    map.put("args4", argValue);
                }
                try {
                    String funName = msgContext.getEsbAbility().getAbilityEname() + msgContext.getEsbAbility().getAbilityVersion() + "RouterFun";
                    funName = funName.replace(".", "_");
                    regionCode = MngHelper.evalRoute((String)funName, (String)pluginRoutePO1.getRouteLogic(), (int)this.compensation, (Object[])new Object[]{map});
                }
                catch (Exception e) {
                    log.warn("\u8c03\u7528\u8def\u7531\u903b\u8f91\u811a\u672c\u5f02\u5e38:{}", (Object)e.getMessage());
                    throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> \u8c03\u7528\u8def\u7531\u903b\u8f91\u811a\u672c\u5f02\u5e38(%s)"}).fillArgs(new Object[]{this.getClass().getSimpleName(), e.getMessage()}), (Throwable)e);
                }
                RegionBO regionBO2 = this.regionApi.queryByRegionCode((String)regionCode);
                if (Objects.isNull(regionBO2)) {
                    log.debug("\u8def\u7531\u5206\u533a\u4e0d\u5b58\u5728,\u5206\u533a\u7f16\u7801:{}", regionCode);
                    throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> \u8def\u7531\u5206\u533a\u4e0d\u5b58\u5728,\u5206\u533a\u7f16\u7801:%s"}).fillArgs(new Object[]{this.getClass().getSimpleName(), regionCode}));
                }
                boolean checkRegionDeployFlag = this.pluginApi.checkRegionDeploy(abilityPluginBO.getAbilityId(), regionBO2.getRegionId());
                if (!checkRegionDeployFlag) {
                    log.debug("\u5206\u533a\u672a\u90e8\u7f72,\u5206\u533a\u7f16\u7801:{}", (Object)regionBO2.getRegionCode());
                    throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> \u5206\u533a\u672a\u90e8\u7f72,\u5206\u533a\u7f16\u7801:%s"}).fillArgs(new Object[]{this.getClass().getSimpleName(), regionBO2.getRegionCode()}));
                }
                RegionBO regionBO = msgContext.getSelfDefHeader().getRegionBO();
                if (Objects.isNull(regionBO) || !regionBO.getRegionId().equals(regionBO2.getRegionId())) {
                    msgContext.getSelfDefHeader().setRegionBO(regionBO2);
                }
                if (!Constants.RegionType.GRAY.equals(regionType = regionBO2.getRegionType())) continue;
                PluginRouteExtPO pluginRouteExtPO = new PluginRouteExtPO();
                pluginRouteExtPO.setAbilityPluginId(abilityPluginBO.getAbilityPluginId());
                List<PluginRouteExtPO> pluginRouteExtPOList = this.pluginRouteExtMapper.queryByCond(pluginRouteExtPO);
                Map<String, String> routeMap = pluginRouteExtPOList.stream().collect(Collectors.toMap(PluginRouteExtPO::getExtKey, PluginRouteExtPO::getExtValue));
                Map selfDefMap = msgContext.getSelfDefHeader().getSelfDefMap();
                if (Objects.isNull(selfDefMap)) {
                    msgContext.getSelfDefHeader().setSelfDefMap(routeMap);
                    continue;
                }
                selfDefMap.putAll(routeMap);
            }
            log.debug("\u8def\u7531\u6821\u9a8c\u901a\u8fc7");
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("\u8def\u7531\u63d2\u4ef6\u6267\u884c\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> " + e.getMessage()}).fillArgs(new Object[]{this.getClass().getSimpleName()}), (Throwable)e);
        }
    }
}

