/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.abilitycommon.api.AppApi;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.AppSecretBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.plugin.PluginA;
import com.ohaotian.plugin.config.JwtConfig;
import com.ohaotian.plugin.mapper.AbilityPluginJwtMapper;
import com.ohaotian.plugin.model.po.AbilityPluginJwtPO;
import com.ohaotian.plugin.util.MD5TokenUtil;
import com.ohaotian.plugin.util.RSAUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service(value="tokenPluginService")
public class TokenPluginService
implements PluginA {
    private static final Logger log = LogManager.getLogger(TokenPluginService.class);
    @Resource
    NodeInfoConfig nodeInfoConfig;
    @Resource
    AbilityPluginJwtMapper abilityPluginJwtMapper;
    @Resource
    AppApi appApi;
    @Resource
    JwtConfig jwtConfig;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            AbilityPluginBO abilityPluginBO = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "token".equalsIgnoreCase(bo.getPluginType())).findAny().orElse(null);
            if (Objects.isNull(abilityPluginBO)) {
                log.debug("token\u6821\u9a8c\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
                return;
            }
            AppBO appBO = msgContext.getSelfDefHeader().getApp();
            if (appBO != null) {
                String appCode = null;
                AbilityPluginJwtPO abilityPluginJwtPO = new AbilityPluginJwtPO();
                abilityPluginJwtPO.setAbilityPluginId(abilityPluginBO.getAbilityPluginId());
                abilityPluginJwtPO = this.abilityPluginJwtMapper.queryLimitOne(abilityPluginJwtPO);
                Integer appCodeSource = msgContext.getEsbAbility().getAppCodeSource();
                if (appCodeSource != 2) {
                    long requestTime;
                    long currentTime;
                    Map reqParams = msgContext.getTlogReqHeader().getHeadersMap();
                    String transId = (String)reqParams.get("transId");
                    String timestamp = (String)reqParams.get("timestamp");
                    String token = (String)reqParams.get("token");
                    if (appCodeSource == 0) {
                        appCode = appBO.getAppCode();
                    } else {
                        TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
                        Map req = this.json2Map(new String(tlogReqHeader.getReqData(), StandardCharsets.UTF_8));
                        appCode = String.valueOf(req.get("appcode"));
                    }
                    if (this.jwtConfig.getTimestampEffect().booleanValue() && Math.abs((currentTime = System.currentTimeMillis()) - (requestTime = Long.parseLong(timestamp))) > this.jwtConfig.getValidTime()) {
                        log.debug("Token\u6821\u9a8c\u672a\u901a\u8fc7-token\u5df2\u5931\u6548");
                        throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":TokenPluginService >>> Token\u6821\u9a8c\u672a\u901a\u8fc7"}));
                    }
                    Long appId = appBO.getAppId();
                    AppSecretBO appSecretBO = this.appApi.selectByAppIdandClusterId(appId, this.nodeInfoConfig.getClusterId());
                    TreeMap<String, String> paramTreeMap = new TreeMap<String, String>();
                    paramTreeMap.put("appCode", appCode);
                    paramTreeMap.put("transId", transId);
                    paramTreeMap.put("timestamp", timestamp);
                    paramTreeMap.put("appSecret", appSecretBO.getAppSecret());
                    if (abilityPluginJwtPO.getEnhancedValidation() == 1) {
                        if (RSAUtils.verifySign(token, paramTreeMap, appSecretBO.getPublicSecrets())) {
                            log.debug("Token\u589e\u5f3a\u6821\u9a8c\u901a\u8fc7-token\u5408\u6cd5");
                            return;
                        }
                        log.debug("Token\u589e\u5f3a\u6821\u9a8c\u672a\u901a\u8fc7-token\u4e0d\u5408\u6cd5");
                        throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":TokenPluginService >>> Token\u6821\u9a8c\u672a\u901a\u8fc7"}));
                    }
                    if (MD5TokenUtil.verifySign(token, paramTreeMap)) {
                        log.debug("Token\u6821\u9a8c\u901a\u8fc7-token\u5408\u6cd5");
                        return;
                    }
                    log.debug("Token\u6821\u9a8c\u672a\u901a\u8fc7-token\u4e0d\u5408\u6cd5");
                    throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":TokenPluginService >>> Token\u6821\u9a8c\u672a\u901a\u8fc7"}));
                }
            }
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("Token\u6821\u9a8c\u672a\u901a\u8fc7-Token\u6821\u9a8c\u5f02\u5e38:{}", (Throwable)e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":TokenPluginService >>> Token\u6821\u9a8c\u672a\u901a\u8fc7" + e.getMessage()}));
        }
    }

    private Map json2Map(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.readValue(json, Map.class);
        return map;
    }
}

