/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson.jsonpointer;

import com.fasterxml.jackson.core.TreeNode;
import com.github.fge.jackson.jsonpointer.JsonPointerException;
import com.github.fge.jackson.jsonpointer.JsonPointerMessages;
import com.github.fge.jackson.jsonpointer.ReferenceToken;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class TreePointer<T extends TreeNode>
implements Iterable<TokenResolver<T>> {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPointerMessages.class);
    private static final char SLASH = '/';
    private final T missing;
    protected final List<TokenResolver<T>> tokenResolvers;

    protected TreePointer(T missing, List<TokenResolver<T>> tokenResolvers) {
        this.missing = missing;
        this.tokenResolvers = ImmutableList.copyOf(tokenResolvers);
    }

    protected TreePointer(List<TokenResolver<T>> tokenResolvers) {
        this(null, tokenResolvers);
    }

    public final T get(T node) {
        Object ret = node;
        for (TokenResolver<T> tokenResolver : this.tokenResolvers) {
            if (ret == null) break;
            ret = tokenResolver.get(ret);
        }
        return ret;
    }

    public final T path(T node) {
        T ret = this.get(node);
        return ret == null ? this.missing : ret;
    }

    public final boolean isEmpty() {
        return this.tokenResolvers.isEmpty();
    }

    @Override
    public final Iterator<TokenResolver<T>> iterator() {
        return this.tokenResolvers.iterator();
    }

    public final int hashCode() {
        return this.tokenResolvers.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreePointer other = (TreePointer)obj;
        return this.tokenResolvers.equals(other.tokenResolvers);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (TokenResolver<T> tokenResolver : this.tokenResolvers) {
            sb.append('/').append(tokenResolver);
        }
        return sb.toString();
    }

    public final String getCurrFieldName() {
        if (this.tokenResolvers.size() > 0) {
            return this.tokenResolvers.get(this.tokenResolvers.size() - 1).toString();
        }
        return "/";
    }

    protected static List<ReferenceToken> tokensFromInput(String input) throws JsonPointerException {
        String s = (String)BUNDLE.checkNotNull((Object)input, "nullInput");
        ArrayList ret = Lists.newArrayList();
        while (!s.isEmpty()) {
            char c = s.charAt(0);
            if (c != '/') {
                throw new JsonPointerException(BUNDLE.getMessage("notSlash"));
            }
            int index = (s = s.substring(1)).indexOf(47);
            String cooked = index == -1 ? s : s.substring(0, index);
            ret.add(ReferenceToken.fromCooked((String)cooked));
            if (index == -1) break;
            s = s.substring(index);
        }
        return ret;
    }
}

