/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.report;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public abstract class AbstractProcessingReport
implements ProcessingReport {
    private LogLevel currentLevel = LogLevel.DEBUG;
    private final LogLevel logLevel;
    private final LogLevel exceptionThreshold;

    protected AbstractProcessingReport(LogLevel logLevel, LogLevel exceptionThreshold) {
        this.logLevel = logLevel;
        this.exceptionThreshold = exceptionThreshold;
    }

    protected AbstractProcessingReport(LogLevel logLevel) {
        this(logLevel, LogLevel.FATAL);
    }

    protected AbstractProcessingReport() {
        this(LogLevel.INFO, LogLevel.FATAL);
    }

    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final LogLevel getExceptionThreshold() {
        return this.exceptionThreshold;
    }

    public final void debug(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.DEBUG));
    }

    public final void info(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.INFO));
    }

    public final void warn(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.WARNING));
    }

    public final void error(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.ERROR));
    }

    public final void fatal(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.FATAL));
    }

    public final boolean isSuccess() {
        return this.currentLevel.compareTo((Enum)LogLevel.ERROR) < 0;
    }

    public abstract void log(LogLevel var1, ProcessingMessage var2);

    protected final void dispatch(ProcessingMessage message) throws ProcessingException {
        LogLevel level = message.getLogLevel();
        if (level.compareTo((Enum)this.exceptionThreshold) >= 0) {
            throw message.asException();
        }
        if (level.compareTo((Enum)this.currentLevel) > 0) {
            this.currentLevel = level;
        }
        if (level.compareTo((Enum)this.logLevel) >= 0) {
            this.log(level, message);
        }
    }

    public Iterator<ProcessingMessage> iterator() {
        return Collections.emptyIterator();
    }

    public final void mergeWith(ProcessingReport other) throws ProcessingException {
        if (!other.isSuccess() && this.currentLevel.compareTo((Enum)LogLevel.ERROR) < 0) {
            this.currentLevel = LogLevel.ERROR;
        }
        for (ProcessingMessage message : other) {
            this.dispatch(message);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList messages = Lists.newArrayList((Iterable)((Object)this));
        if (!messages.isEmpty()) {
            for (ProcessingMessage message : messages) {
                sb.append(message).append("\n");
            }
        }
        return sb.toString();
    }
}

