/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb;

import com.ohaotian.plugin.mq.proxy.support.EnablePluginMqProxy;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@EnablePluginMqProxy
@SpringBootApplication
@MapperScan(value={"com.ohaotian.abilityweb.mapper", "com.ohaotian.plugin.mapper", "com.ohaotian.abilitycommon.mapper"})
@ComponentScan(value={"com.ohaotian.abilityweb", "com.ohaotian.abilitycommon", "com.ohaotian.plugin", "com.ohaotian.abilitylog", "com.ohaotian.atp"})
@EnableDiscoveryClient
public class AbilityWebApplication {
    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplication(new Class[]{AbilityWebApplication.class});
        springApplication.setWebApplicationType(WebApplicationType.REACTIVE);
        springApplication.run(args);
    }

    @Bean(value={"currentCount"})
    public AtomicInteger currentCount() {
        return new AtomicInteger(0);
    }

    @Bean
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(10);
        threadPoolTaskScheduler.setThreadNamePrefix("ability-web-taskExecutor-");
        threadPoolTaskScheduler.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        threadPoolTaskScheduler.setWaitForTasksToCompleteOnShutdown(true);
        threadPoolTaskScheduler.setAwaitTerminationSeconds(60);
        return threadPoolTaskScheduler;
    }
}

