/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.component.deploy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Maps;
import com.ohaotian.abilitycommon.config.classload.DynamicJarClassLoader;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.system.SystemParam;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.constant.LimitConstant;
import com.ohaotian.abilitycommon.enums.FisrtLevelEnum;
import com.ohaotian.abilitycommon.enums.SecondLevelEnum;
import com.ohaotian.abilitycommon.model.bo.AbilityExtColumnBO;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.AppExtColumnBO;
import com.ohaotian.abilitycommon.model.bo.RedisSyncDataBo;
import com.ohaotian.abilitycommon.model.bo.SyncDataBO;
import com.ohaotian.abilitycommon.model.bo.SyncServiceBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.util.BeanMapper;
import com.ohaotian.abilitycommon.util.FileUtil;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.JacksonUtil;
import com.ohaotian.abilityweb.config.cluster.WebClusterConfig;
import com.ohaotian.abilityweb.config.esbability.EsbAbilityMap;
import com.ohaotian.abilityweb.mapper.AbilityExtColumnMapper;
import com.ohaotian.abilityweb.mapper.AbilityExtCustomMapper;
import com.ohaotian.abilityweb.mapper.AbilityExtMapper;
import com.ohaotian.abilityweb.mapper.AbilityLogicMapper;
import com.ohaotian.abilityweb.mapper.AbilityMapper;
import com.ohaotian.abilityweb.mapper.AbilityParamMapper;
import com.ohaotian.abilityweb.mapper.AbilityPluginMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityweb.mapper.AbilityTransMapper;
import com.ohaotian.abilityweb.mapper.AppExtColumnMapper;
import com.ohaotian.abilityweb.mapper.AppMapper;
import com.ohaotian.abilityweb.mapper.AppSubscribeDeployMapper;
import com.ohaotian.abilityweb.mapper.RateLimiterAbilityMapper;
import com.ohaotian.abilityweb.model.bo.DeployCallBackBO;
import com.ohaotian.abilityweb.model.po.AbilityExtColumnPO;
import com.ohaotian.abilityweb.model.po.AbilityExtCustomPO;
import com.ohaotian.abilityweb.model.po.AbilityExtPO;
import com.ohaotian.abilityweb.model.po.AbilityLogicPO;
import com.ohaotian.abilityweb.model.po.AbilityPO;
import com.ohaotian.abilityweb.model.po.AbilityParamPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityweb.model.po.AbilityTransPO;
import com.ohaotian.abilityweb.model.po.AppExtColumnPO;
import com.ohaotian.abilityweb.model.po.AppPO;
import com.ohaotian.abilityweb.model.po.AppSubscribeDeployPO;
import com.ohaotian.abilityweb.model.po.RateLimiterAbilityPO;
import com.ohaotian.abilityweb.service.limit.global.RedisRateLimiterKey;
import com.ohaotian.abilityweb.service.limit.single.EsbAbilityAppLimitMap;
import com.ohaotian.abilityweb.service.limit.single.EsbAbilityLimitMap;
import com.ohaotian.abilityweb.service.sync.InitDataService;
import com.ohaotian.abilityweb.service.sync.PluginSyncDataService;
import com.ohaotian.abilityweb.service.sync.SyncDataService;
import com.ohaotian.abilityweb.service.transform.FactoryForTransForm;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.xml.sax.SAXException;

@Component
public class SvcDeployHelp {
    private static Logger log = LogManager.getLogger(SvcDeployHelp.class);
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private AbilityExtMapper abilityExtMapper;
    @Resource
    private AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    private AbilityLogicMapper abilityLogicMapper;
    @Resource
    private AbilityParamMapper abilityParamMapper;
    @Resource
    private AbilityExtCustomMapper abilityExtCustomMapper;
    @Resource
    private AbilityPluginMapper abilityPluginMapper;
    @Resource
    private AbilityExtColumnMapper abilityExtColumnMapper;
    @Resource
    private AppMapper appMapper;
    @Resource
    private AppExtColumnMapper appExtColumnMapper;
    @Resource
    private RateLimiterAbilityMapper rateLimiterAbilityMapper;
    @Resource
    private AppSubscribeDeployMapper appSubscribeDeployMapper;
    @Resource
    private AbilityTransMapper abilityTransMapper;
    @Resource
    private SyncDataService syncDataService;
    @Resource
    private PluginSyncDataService pluginSyncDataService;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Resource
    private SystemParam systemParam;
    @Resource
    FactoryForTransForm factoryForTransForm;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private ReactiveRedisTemplate<String, String> reactiveRedisTemplate;
    @Resource
    private InitDataService initDataService;
    @Autowired
    WebClusterConfig webClusterConfig;
    private static final String CALL_BACK_ADDR = "/abilityDeploy/deployCallBack";

    public void deployAllCustomSvc() {
        AbilityProvideDeployPO abilityProvideDeploy = new AbilityProvideDeployPO();
        abilityProvideDeploy.setDeployStatus(Constants.deployStatus.DEPLOY_SUCC);
        List<AbilityProvideDeployPO> abilityProvideDeployPOS = this.abilityProvideDeployMapper.queryByCond(abilityProvideDeploy);
        if (!CollectionUtils.isEmpty(abilityProvideDeployPOS)) {
            List<Long> collect = abilityProvideDeployPOS.stream().map(a -> a.getAbilityId()).collect(Collectors.toList());
            List<AbilityPO> abilityPOS = this.abilityMapper.queryByAbilityIds(collect);
            for (AbilityPO po : abilityPOS) {
                try {
                    if (po.getInputProtocal().contains("ws")) {
                        this.pubishWsSvc(po);
                        continue;
                    }
                    this.pubishSvc(po);
                }
                catch (Exception e) {
                    log.error("\u670d\u52a1\u90e8\u7f72\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public RedisSyncDataBo deployOneCustomSvcByRedisData(SyncServiceBO syncServiceBO) throws JsonProcessingException {
        Long abilityId = syncServiceBO.getAbilityId();
        Long hirerId = syncServiceBO.getHirerId();
        Long clusterId = this.nodeInfoConfig.getClusterId();
        String traceId = syncServiceBO.getTraceId();
        RedisSyncDataBo syncDataBo = new RedisSyncDataBo();
        syncDataBo.setName(this.webClusterConfig.getName());
        syncDataBo.setCode("DEPLOY_RETURN");
        syncDataBo.setNodeIp(this.nodeInfoConfig.getNodeIp());
        syncDataBo.setPort(this.nodeInfoConfig.getPort());
        syncDataBo.setClusterId(this.nodeInfoConfig.getClusterId());
        syncDataBo.setClusterEname(this.nodeInfoConfig.getClusterEname());
        DeployCallBackBO deployCallBackBO = new DeployCallBackBO();
        try {
            SyncDataBO bo = new SyncDataBO();
            bo.setClusterId(clusterId);
            bo.setHirerId(hirerId);
            bo.setFirstLevel(FisrtLevelEnum.PLUGIN.getName());
            bo.setSecondLevel(SecondLevelEnum.PLUGIN_PLUGIN_EXT.getName());
            bo.setPrimaryId(abilityId);
            try {
                if (ObjectUtils.isEmpty((Object)this.systemParam.getSyncWay()) || this.systemParam.getSyncWay().equals("api")) {
                    log.info("SyncWay\uff1aapi,\u6570\u636e\u5f00\u59cb\u540c\u6b65\uff01");
                    this.pluginSyncDataService.syncIncrementByAbilityId(bo);
                    this.initDataService.initData();
                }
            }
            catch (Exception e) {
                log.error("\u53d1\u5e03\u80fd\u529b\u524d\u5168\u91cf\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (abilityId != null && hirerId != null) {
                AbilityPO abilityPO = new AbilityPO();
                abilityPO.setHirerId(hirerId);
                abilityPO.setAbilityId(abilityId);
                abilityPO = this.abilityMapper.queryLimitOne(abilityPO);
                if (abilityPO != null) {
                    EsbAbilityMap.deleteAbility(abilityPO.getAbilityEname(), abilityPO.getAbilityVersion());
                    if (abilityPO.getInputProtocal().contains("ws")) {
                        this.pubishWsSvc(abilityPO);
                    } else {
                        this.pubishSvc(abilityPO);
                    }
                }
                deployCallBackBO.setTraceId(traceId);
                deployCallBackBO.setDeployStatus(1);
                deployCallBackBO.setClusterId(clusterId);
                syncDataBo.setSuccess(Boolean.TRUE.booleanValue());
                syncDataBo.setMsg(GsonUtil.toJson((Object)deployCallBackBO));
            }
        }
        catch (Exception e) {
            log.error("\u90e8\u7f72\u80fd\u529b\u5931\u8d25", (Throwable)e);
            deployCallBackBO.setTraceId(traceId);
            deployCallBackBO.setDeployStatus(2);
            deployCallBackBO.setClusterId(clusterId);
            syncDataBo.setSuccess(Boolean.FALSE.booleanValue());
            syncDataBo.setMsg(GsonUtil.toJson((Object)deployCallBackBO));
        }
        return this.sendMessages(syncDataBo, deployCallBackBO);
    }

    private RedisSyncDataBo sendMessages(RedisSyncDataBo redisSyncDataBo, DeployCallBackBO deployCallBackBO) {
        try {
            if (this.systemParam.getSyncWay().equals("redis") || this.systemParam.getSyncWay().equals("mq")) {
                return redisSyncDataBo;
            }
            String adminPath = this.systemParam.getAdminPath();
            StringBuilder sb = new StringBuilder(adminPath);
            if (!StringUtils.isEmpty((Object)this.systemParam.getContext())) {
                sb.append(this.systemParam.getContext());
            }
            sb.append(CALL_BACK_ADDR);
            HttpHeaders headers = new HttpHeaders();
            MediaType mediaType = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(mediaType);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            this.restTemplate.postForEntity(sb.toString(), (Object)new HttpEntity((Object)JacksonUtil.toJson((Object)deployCallBackBO), (MultiValueMap)headers), String.class, new Object[0]).getBody();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean deleteOneCustomSvcByRedisData(SyncServiceBO syncServiceBo) {
        if (StringUtils.isEmpty((Object)syncServiceBo.getAbilityEname()) || StringUtils.isEmpty((Object)syncServiceBo.getAbilityVersion())) {
            return false;
        }
        AbilityPO abilityPO = new AbilityPO();
        abilityPO.setHirerId(syncServiceBo.getHirerId());
        abilityPO.setAbilityId(syncServiceBo.getAbilityId());
        abilityPO = this.abilityMapper.queryLimitOne(abilityPO);
        if (abilityPO != null) {
            EsbAbilityMap.deleteAbility(abilityPO.getAbilityEname(), abilityPO.getAbilityVersion());
        }
        EsbAbilityMap.deleteAbility(syncServiceBo.getAbilityEname(), syncServiceBo.getAbilityVersion());
        EsbAbilityLimitMap.removeAbilityRate(syncServiceBo.getAbilityId());
        EsbAbilityAppLimitMap.removeLimitByAbilityId(syncServiceBo.getAbilityId());
        log.info("\u5220\u9664\u670d\u52a1:{}_{}", (Object)syncServiceBo.getAbilityEname(), (Object)syncServiceBo.getAbilityVersion());
        return true;
    }

    private void pubishSvc(AbilityPO abilityPO) throws Exception {
        String serviceName = abilityPO.getAbilityEname().concat("_").concat(abilityPO.getAbilityVersion());
        String svcPath = Constants.SYSTEM_PATH.concat(Constants.SEPA).concat("svcservice").concat(Constants.SEPA).concat(serviceName);
        File file = new File(svcPath);
        EsbAbilityMap.deleteAbility(abilityPO.getAbilityEname(), abilityPO.getAbilityVersion());
        EsbAbility esbAbility = new EsbAbility();
        AbilityExtCustomPO abilityExtCustomPO = new AbilityExtCustomPO();
        abilityExtCustomPO.setAbilityId(abilityPO.getAbilityId());
        List<AbilityExtCustomPO> abilityExtCustomPOList = this.abilityExtCustomMapper.queryByCond(abilityExtCustomPO);
        if (CollectionUtils.isEmpty(abilityExtCustomPOList)) {
            log.info("\u670d\u52a1{}\u90e8\u7f72\u5f02\u5e38[{}]\uff0c\u5f02\u5e38\u4fe1\u606f{}", (Object)abilityPO.getAbilityName(), (Object)serviceName, (Object)"\u670d\u52a1\u83b7\u53d6\u8d85\u65f6\u65f6\u95f4\u548c\u91cd\u8bd5\u6b21\u6570\u5f02\u5e38\uff01");
            return;
        }
        HashMap retryTimeMap = Maps.newHashMap();
        HashMap overTimeMap = Maps.newHashMap();
        abilityExtCustomPOList.forEach(po -> {
            retryTimeMap.put(po.getRegionId(), po.getRetryTime());
            overTimeMap.put(po.getRegionId(), po.getOvertime());
        });
        esbAbility.setRetryTime((Map)retryTimeMap);
        esbAbility.setOvertime((Map)overTimeMap);
        AbilityExtPO abilityExt = new AbilityExtPO();
        abilityExt.setAbilityId(abilityPO.getAbilityId());
        AbilityExtPO abilityExtPO = this.abilityExtMapper.queryLimitOne(abilityExt);
        String reqJarPath = svcPath.concat(Constants.SEPA).concat(abilityExtPO.getReqJarFilename());
        String rspJarPath = svcPath.concat(Constants.SEPA).concat(abilityExtPO.getRspJarFilename());
        EsbAbility ability = EsbAbilityMap.getAbility(abilityPO.getAbilityEname(), abilityPO.getAbilityVersion());
        if (ability != null) {
            ability.getClzLoader().close();
        }
        if (file.exists()) {
            FileUtil.removeDir((File)file);
        }
        byte[] jarContent = Base64Utils.decodeFromString((String)abilityExtPO.getReqJarContent());
        File reqJar = FileUtil.saveFile((byte[])jarContent, (String)svcPath, (String)abilityExtPO.getReqJarFilename());
        byte[] jarContentrsp = Base64Utils.decodeFromString((String)abilityExtPO.getRspJarContent());
        File rspJar = FileUtil.saveFile((byte[])jarContentrsp, (String)svcPath, (String)abilityExtPO.getRspJarFilename());
        log.info("\u670d\u52a1{}\u90e8\u7f72\u5f00\u59cb[{}]", (Object)abilityPO.getAbilityName(), (Object)serviceName);
        esbAbility.setAbilityEname(abilityPO.getAbilityEname());
        esbAbility.setAbilityId(abilityPO.getAbilityId());
        esbAbility.setAbilityName(abilityPO.getAbilityName());
        esbAbility.setAbilityType(abilityPO.getAbilityType());
        esbAbility.setAbilityVersion(abilityPO.getAbilityVersion());
        esbAbility.setInputProtocal(abilityPO.getInputProtocal());
        esbAbility.setOutputProtocal(abilityPO.getOutputProtocal());
        esbAbility.setOutputTransProtocal(abilityPO.getOutputTransProtocal());
        esbAbility.setOutputClient(abilityPO.getOutputClient());
        esbAbility.setAppCodeSource(abilityPO.getAppCodeSource());
        esbAbility.setAppCodePath(abilityPO.getAppCodePath());
        esbAbility.setAttendStatus(abilityPO.getAttendStatus());
        esbAbility.setIsMessageCheck(abilityPO.getIsMessageCheck());
        List<AbilityPluginBO> abilityPluginBOList = this.abilityPluginMapper.qryAbilityBindPlugins(abilityPO.getAbilityId());
        esbAbility.setAbilityPluginBOList(abilityPluginBOList);
        AbilityExtColumnPO abilityExtColumnPO = this.abilityExtColumnMapper.queryLimitOneByAbilityId(abilityPO.getAbilityId());
        AbilityExtColumnBO abilityExtColumnBO = (AbilityExtColumnBO)BeanMapper.map((Object)abilityExtColumnPO, AbilityExtColumnBO.class);
        esbAbility.setAbilityExtColumn(abilityExtColumnBO);
        AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
        abilityProvideDeployPO.setAbilityId(abilityPO.getAbilityId());
        abilityProvideDeployPO = this.abilityProvideDeployMapper.queryLimitOne(abilityProvideDeployPO);
        AppPO appPO = this.appMapper.queryByAppId(abilityProvideDeployPO.getAppId());
        AppBO appBO = (AppBO)BeanMapper.map((Object)appPO, AppBO.class);
        esbAbility.setProviderApp(appBO);
        AppExtColumnPO appExtColumnPO = this.appExtColumnMapper.queryLimitOneByAppId(appPO.getAppId());
        AppExtColumnBO appExtColumnBO = (AppExtColumnBO)BeanMapper.map((Object)appExtColumnPO, AppExtColumnBO.class);
        esbAbility.setProviderAppColumn(appExtColumnBO);
        AbilityLogicPO po2 = new AbilityLogicPO();
        po2.setAbilityId(abilityPO.getAbilityId());
        po2 = this.abilityLogicMapper.queryLimitOne(po2);
        if (!Objects.isNull(po2)) {
            esbAbility.setLogicScript(po2.getLogicScript());
        }
        AbilityTransPO transPO = new AbilityTransPO();
        transPO.setAbilityId(abilityPO.getAbilityId());
        transPO = this.abilityTransMapper.queryLimitOne(transPO);
        if (transPO != null) {
            this.factoryForTransForm.getStrategy(transPO.getReqTransType()).deployEsbServiceReq(esbAbility, transPO);
            this.factoryForTransForm.getStrategy(transPO.getRspTransType()).deployEsbServiceRsp(esbAbility, transPO);
        } else {
            esbAbility.setReqTransType(Integer.valueOf(0));
            esbAbility.setRspTransType(Integer.valueOf(0));
        }
        esbAbility.setInputClassName(abilityExtPO.getReqClassName());
        esbAbility.setOutputClassName(abilityExtPO.getRspClassName());
        DynamicJarClassLoader dynamicJarClassLoader = new DynamicJarClassLoader(new URL[]{reqJar.toURI().toURL(), rspJar.toURI().toURL()}, ClassLoader.getSystemClassLoader());
        esbAbility.setClzLoader((URLClassLoader)dynamicJarClassLoader);
        log.info("\u52a0\u8f7d\u670d\u52a1\u8bf7\u6c42jar\u8def\u5f84{}", (Object)reqJarPath);
        log.info("\u52a0\u8f7d\u670d\u52a1\u8fd4\u56dejar\u8def\u5f84{}", (Object)rspJarPath);
        Class reqClass = dynamicJarClassLoader.loadClass(abilityExtPO.getReqClassName());
        Class rspClass = dynamicJarClassLoader.loadClass(abilityExtPO.getRspClassName());
        JAXBContext contextReq = JAXBContext.newInstance((Class[])new Class[]{reqClass});
        JAXBContext contextRsp = JAXBContext.newInstance((Class[])new Class[]{rspClass});
        esbAbility.setContextReq(contextReq);
        esbAbility.setContextRsp(contextRsp);
        AbilityParamPO abilityParamPO = new AbilityParamPO();
        abilityParamPO.setAbilityId(abilityPO.getAbilityId());
        abilityParamPO = this.abilityParamMapper.queryLimitOne(abilityParamPO);
        esbAbility.setJsonInputSchema(abilityParamPO.getReqJsonschema());
        esbAbility.setJsonOutputSchema(abilityParamPO.getRspJsonschema());
        esbAbility.setXsdInputSchema(SvcDeployHelp.readXMLSchema(abilityParamPO.getReqXsd()));
        esbAbility.setXsdOutputSchema(SvcDeployHelp.readXMLSchema(abilityParamPO.getRespXsd()));
        RateLimiterAbilityPO rateLimiterAbilityPO = new RateLimiterAbilityPO();
        rateLimiterAbilityPO.setAbilityId(abilityPO.getAbilityId());
        rateLimiterAbilityPO = this.rateLimiterAbilityMapper.queryLimitOne(rateLimiterAbilityPO);
        if (rateLimiterAbilityPO != null) {
            AppSubscribeDeployPO appSubscribeDeployPO;
            List<AppSubscribeDeployPO> appSubscribeDeployPOS = null;
            if (LimitConstant.SINGLE_LIMIT_ON.equalsIgnoreCase(rateLimiterAbilityPO.getSingleLimit())) {
                esbAbility.setSingleLimit(rateLimiterAbilityPO.getSingleLimit());
                esbAbility.setSingleMaxRate(rateLimiterAbilityPO.getSingleMaxRate());
                esbAbility.setSingleMaxCount(rateLimiterAbilityPO.getSingleMaxCount());
                esbAbility.setSingleDailyMaxCount(rateLimiterAbilityPO.getSingleDailyMaxCount());
                EsbAbilityLimitMap.putAbilityRate(abilityPO.getAbilityId());
                appSubscribeDeployPO = new AppSubscribeDeployPO();
                appSubscribeDeployPO.setAbilityId(abilityPO.getAbilityId());
                appSubscribeDeployPOS = this.appSubscribeDeployMapper.queryByCond(appSubscribeDeployPO);
                if (appSubscribeDeployPOS != null) {
                    appSubscribeDeployPOS.stream().forEach(appSubscribeDeployPO1 -> {
                        String key = appSubscribeDeployPO1.getAbilityId() + "_" + appSubscribeDeployPO1.getAppId();
                        EsbAbilityAppLimitMap.putLimit(key);
                    });
                }
            } else {
                EsbAbilityLimitMap.removeAbilityRate(abilityPO.getAbilityId());
                EsbAbilityAppLimitMap.removeLimitByAbilityId(abilityPO.getAbilityId());
            }
            if (LimitConstant.GLOBAL_LIMIT_ON.equalsIgnoreCase(rateLimiterAbilityPO.getGlobalLimit())) {
                esbAbility.setGlobalLimit(rateLimiterAbilityPO.getGlobalLimit());
            } else {
                if (appSubscribeDeployPOS == null) {
                    appSubscribeDeployPO = new AppSubscribeDeployPO();
                    appSubscribeDeployPO.setAbilityId(abilityPO.getAbilityId());
                    appSubscribeDeployPOS = this.appSubscribeDeployMapper.queryByCond(appSubscribeDeployPO);
                }
                if (appSubscribeDeployPOS != null) {
                    appSubscribeDeployPOS.stream().forEach(appSubscribeDeployPO1 -> {
                        List<String> keys = RedisRateLimiterKey.getKeys(this.nodeInfoConfig, esbAbility.getAbilityId(), appSubscribeDeployPO1.getAppId());
                        for (String key : keys) {
                            this.reactiveRedisTemplate.opsForValue().delete((Object)key).subscribe(b -> log.info("\u5220\u9664key: " + key));
                        }
                    });
                }
            }
        }
        EsbAbilityMap.pushAbility(esbAbility);
        log.info("\u670d\u52a1{}\u90e8\u7f72\u7ed3\u675f[{}]", (Object)abilityPO.getAbilityName(), (Object)serviceName);
    }

    private void pubishWsSvc(AbilityPO abilityPO) throws Exception {
        String serviceName = abilityPO.getAbilityEname().concat("_").concat(abilityPO.getAbilityVersion());
        String svcPath = Constants.SYSTEM_PATH.concat(Constants.SEPA).concat("svcservice").concat(Constants.SEPA).concat(serviceName);
        File file = new File(svcPath);
        EsbAbilityMap.deleteAbility(abilityPO.getAbilityEname(), abilityPO.getAbilityVersion());
        EsbAbility esbAbility = new EsbAbility();
        AbilityExtCustomPO abilityExtCustomPO = new AbilityExtCustomPO();
        abilityExtCustomPO.setAbilityId(abilityPO.getAbilityId());
        List<AbilityExtCustomPO> abilityExtCustomPOList = this.abilityExtCustomMapper.queryByCond(abilityExtCustomPO);
        if (CollectionUtils.isEmpty(abilityExtCustomPOList)) {
            log.info("\u670d\u52a1{}\u90e8\u7f72\u5f02\u5e38[{}]\uff0c\u5f02\u5e38\u4fe1\u606f{}", (Object)abilityPO.getAbilityName(), (Object)serviceName, (Object)"\u670d\u52a1\u83b7\u53d6\u8d85\u65f6\u65f6\u95f4\u548c\u91cd\u8bd5\u6b21\u6570\u5f02\u5e38\uff01");
            return;
        }
        HashMap retryTimeMap = Maps.newHashMap();
        HashMap overTimeMap = Maps.newHashMap();
        abilityExtCustomPOList.forEach(po -> {
            retryTimeMap.put(po.getRegionId(), po.getRetryTime());
            overTimeMap.put(po.getRegionId(), po.getOvertime());
        });
        esbAbility.setRetryTime((Map)retryTimeMap);
        esbAbility.setOvertime((Map)overTimeMap);
        AbilityExtPO abilityExt = new AbilityExtPO();
        abilityExt.setAbilityId(abilityPO.getAbilityId());
        AbilityExtPO abilityExtPO = this.abilityExtMapper.queryLimitOne(abilityExt);
        String reqJarPath = svcPath.concat(Constants.SEPA).concat(abilityExtPO.getReqJarFilename());
        EsbAbility ability = EsbAbilityMap.getAbility(abilityPO.getAbilityEname(), abilityPO.getAbilityVersion());
        if (ability != null) {
            ability.getClzLoader().close();
        }
        if (file.exists()) {
            FileUtil.removeDir((File)file);
        }
        byte[] jarContent = Base64Utils.decodeFromString((String)abilityExtPO.getReqJarContent());
        File reqJar = FileUtil.saveFile((byte[])jarContent, (String)svcPath, (String)abilityExtPO.getReqJarFilename());
        log.info("\u670d\u52a1{}\u90e8\u7f72\u5f00\u59cb[{}]", (Object)abilityPO.getAbilityName(), (Object)serviceName);
        esbAbility.setAbilityEname(abilityPO.getAbilityEname());
        esbAbility.setAbilityId(abilityPO.getAbilityId());
        esbAbility.setAbilityName(abilityPO.getAbilityName());
        esbAbility.setAbilityType(abilityPO.getAbilityType());
        esbAbility.setAbilityVersion(abilityPO.getAbilityVersion());
        esbAbility.setInputProtocal(abilityPO.getInputProtocal());
        esbAbility.setOutputProtocal(abilityPO.getOutputProtocal());
        esbAbility.setOutputTransProtocal(abilityPO.getOutputTransProtocal());
        esbAbility.setOutputClient(abilityPO.getOutputClient());
        esbAbility.setAppCodeSource(abilityPO.getAppCodeSource());
        esbAbility.setAppCodePath(abilityPO.getAppCodePath());
        esbAbility.setAttendStatus(abilityPO.getAttendStatus());
        esbAbility.setIsMessageCheck(abilityPO.getIsMessageCheck());
        List<AbilityPluginBO> abilityPluginBOList = this.abilityPluginMapper.qryAbilityBindPlugins(abilityPO.getAbilityId());
        esbAbility.setAbilityPluginBOList(abilityPluginBOList);
        AbilityLogicPO po2 = new AbilityLogicPO();
        po2.setAbilityId(abilityPO.getAbilityId());
        po2 = this.abilityLogicMapper.queryLimitOne(po2);
        if (!Objects.isNull(po2)) {
            esbAbility.setLogicScript(po2.getLogicScript());
        }
        AbilityTransPO transPO = new AbilityTransPO();
        transPO.setAbilityId(abilityPO.getAbilityId());
        transPO = this.abilityTransMapper.queryLimitOne(transPO);
        if (transPO != null) {
            this.factoryForTransForm.getStrategy(transPO.getReqTransType()).deployEsbServiceReq(esbAbility, transPO);
            this.factoryForTransForm.getStrategy(transPO.getRspTransType()).deployEsbServiceRsp(esbAbility, transPO);
        } else {
            esbAbility.setReqTransType(Integer.valueOf(0));
            esbAbility.setRspTransType(Integer.valueOf(0));
        }
        esbAbility.setInputClassName(abilityExtPO.getReqClassName());
        esbAbility.setOutputClassName(abilityExtPO.getRspClassName());
        DynamicJarClassLoader dynamicJarClassLoader = new DynamicJarClassLoader(new URL[]{reqJar.toURI().toURL()}, ClassLoader.getSystemClassLoader());
        esbAbility.setClzLoader((URLClassLoader)dynamicJarClassLoader);
        log.info("\u52a0\u8f7d\u670d\u52a1jar\u8def\u5f84{}", (Object)reqJarPath);
        AbilityExtColumnPO abilityExtColumnPO = this.abilityExtColumnMapper.queryLimitOneByAbilityId(abilityPO.getAbilityId());
        AbilityExtColumnBO abilityExtColumnBO = (AbilityExtColumnBO)BeanMapper.map((Object)abilityExtColumnPO, AbilityExtColumnBO.class);
        esbAbility.setAbilityExtColumn(abilityExtColumnBO);
        AbilityProvideDeployPO abilityProvideDeployPO = new AbilityProvideDeployPO();
        abilityProvideDeployPO.setAbilityId(abilityPO.getAbilityId());
        abilityProvideDeployPO = this.abilityProvideDeployMapper.queryLimitOne(abilityProvideDeployPO);
        AppPO appPO = this.appMapper.queryByAppId(abilityProvideDeployPO.getAppId());
        AppBO appBO = (AppBO)BeanMapper.map((Object)appPO, AppBO.class);
        esbAbility.setProviderApp(appBO);
        AppExtColumnPO appExtColumnPO = this.appExtColumnMapper.queryLimitOneByAppId(appPO.getAppId());
        AppExtColumnBO appExtColumnBO = (AppExtColumnBO)BeanMapper.map((Object)appExtColumnPO, AppExtColumnBO.class);
        esbAbility.setProviderAppColumn(appExtColumnBO);
        RateLimiterAbilityPO rateLimiterAbilityPO = new RateLimiterAbilityPO();
        rateLimiterAbilityPO.setAbilityId(abilityPO.getAbilityId());
        rateLimiterAbilityPO = this.rateLimiterAbilityMapper.queryLimitOne(rateLimiterAbilityPO);
        if (rateLimiterAbilityPO != null) {
            if (LimitConstant.SINGLE_LIMIT_ON.equalsIgnoreCase(rateLimiterAbilityPO.getSingleLimit())) {
                esbAbility.setSingleLimit(rateLimiterAbilityPO.getSingleLimit());
                esbAbility.setSingleMaxRate(rateLimiterAbilityPO.getSingleMaxRate());
                esbAbility.setSingleMaxCount(rateLimiterAbilityPO.getSingleMaxCount());
                esbAbility.setSingleDailyMaxCount(rateLimiterAbilityPO.getSingleDailyMaxCount());
                EsbAbilityLimitMap.putAbilityRate(abilityPO.getAbilityId());
                AppSubscribeDeployPO appSubscribeDeployPO = new AppSubscribeDeployPO();
                appSubscribeDeployPO.setAbilityId(abilityPO.getAbilityId());
                List<AppSubscribeDeployPO> appSubscribeDeployPOS = this.appSubscribeDeployMapper.queryByCond(appSubscribeDeployPO);
                if (appSubscribeDeployPOS != null) {
                    appSubscribeDeployPOS.stream().forEach(appSubscribeDeployPO1 -> {
                        String key = appSubscribeDeployPO1.getAbilityId() + "_" + appSubscribeDeployPO1.getAppId();
                        EsbAbilityAppLimitMap.putLimit(key);
                    });
                }
            } else {
                EsbAbilityLimitMap.removeAbilityRate(abilityPO.getAbilityId());
                EsbAbilityAppLimitMap.removeLimitByAbilityId(abilityPO.getAbilityId());
            }
            if (LimitConstant.GLOBAL_LIMIT_ON.equalsIgnoreCase(rateLimiterAbilityPO.getGlobalLimit())) {
                esbAbility.setGlobalLimit(rateLimiterAbilityPO.getGlobalLimit());
            }
        }
        EsbAbilityMap.pushAbility(esbAbility);
        log.info("\u670d\u52a1{}\u90e8\u7f72\u7ed3\u675f[{}]", (Object)abilityPO.getAbilityName(), (Object)serviceName);
    }

    public static Schema readAndWriteXMLSchema(String xsdSchema, String filePath) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        InputStream[] inputStreams = new InputStream[]{new ByteArrayInputStream(xsdSchema.getBytes(StandardCharsets.UTF_8))};
        Source[] sources = new Source[inputStreams.length];
        for (int i = 0; i < inputStreams.length; ++i) {
            sources[i] = new StreamSource(inputStreams[i]);
        }
        Schema schema = factory.newSchema(sources);
        Files.write(Paths.get(filePath, new String[0]), xsdSchema.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return schema;
    }

    public static Schema readXMLSchema(String xsdSchema) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream[] inputStreams = new InputStream[]{new ByteArrayInputStream(xsdSchema.getBytes(StandardCharsets.UTF_8))};
        Source[] sources = new Source[inputStreams.length];
        for (int i = 0; i < inputStreams.length; ++i) {
            sources[i] = new StreamSource(inputStreams[i]);
        }
        return factory.newSchema(sources);
    }
}

