/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.component.error;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.js.MngHelperService;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RedisSyncDataBo;
import com.ohaotian.abilitycommon.model.bo.ResultData;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilitycommon.util.DateUtil;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.HtmlUtil;
import com.ohaotian.abilitycommon.util.HttpUtil;
import com.ohaotian.abilitycommon.util.JacksonUtil;
import com.ohaotian.abilitycommon.util.JaxbUtil;
import com.ohaotian.abilityweb.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityweb.mapper.DefinedExceptionMapper;
import com.ohaotian.abilityweb.model.po.DefinedExceptionPO;
import com.ohaotian.abilityweb.service.abnormal.AbnormalGrabService;
import com.ohaotian.abilityweb.service.transform.FactoryForTransForm;
import com.ohaotian.abilityweb.util.PrintTLogUtil;
import com.ohaotian.atp.base.model.TokenRefreshBo;
import com.ohaotian.plugin.cache.CacheClient;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.script.ScriptException;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Component
public class ErrorReturnComponent {
    private static Logger logger = LogManager.getLogger(ErrorReturnComponent.class);
    @Resource
    private DefinedExceptionMapper definedExceptionMapper;
    @Autowired
    private CacheClient cacheClient;
    @Resource
    private FactoryForTransForm factoryTransformer;
    @Value(value="${ability.error.monitor.time:1}")
    private String time;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    private AbnormalGrabService abnormalGrabService;
    @Resource
    private PubSubRes pubSubRes;
    @Autowired
    private MngHelperService mngHelperService;
    @Value(value="${ability.errorReturn.push:false}")
    private boolean errorReturnPush;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Mono<ServerResponse> doErrorReturn(Throwable e, MsgContext msgContext, MediaType mediaType, String inputProtocol) {
        HashMap<String, Object> abilityData;
        TlogRspHeader tlogRspHeader;
        CodeMsg codeMsg;
        logger.error("\u7cfb\u7edf\u5f02\u5e38", e);
        if (this.errorReturnPush) {
            try {
                if (e instanceof AbilityException) {
                    CodeMsg codeMsg2 = ((AbilityException)e).codeMsg;
                    List<String> list = Arrays.asList(codeMsg2.getRspDesc().split(":"));
                    if (codeMsg2.getRspCode().equals(CodeMsg.E_HP_SVC_ERR.getRspCode()) && list.get(1).equals(HttpStatus.UNAUTHORIZED.value() + "")) {
                        TokenRefreshBo tokenRefreshBo = msgContext.getTokenRefreshBo();
                        RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
                        redisSyncDataBo.setCode("TOKEN_REFRESH");
                        redisSyncDataBo.setTokenRefreshBo(tokenRefreshBo);
                        logger.warn("\u9274\u6743\u8865\u507f\u673a\u5236: \u843d\u5730\u8fd4\u56de\u9274\u6743\u5f02\u5e38\uff0c\u5f02\u5e38\u63d2\u4ef6={}\uff0corgId={}", (Object)tokenRefreshBo.getPluginIds(), (Object)tokenRefreshBo.getOrgId());
                        this.pubSubRes.getClient().publish("", GsonUtil.toJson((Object)redisSyncDataBo));
                    }
                }
            }
            catch (Exception exception) {
                logger.warn("\u9274\u6743\u8865\u507f\u673a\u5236: \u843d\u5730\u8fd4\u56de\u9274\u6743\u5f02\u5e38,\u8fd4\u56de\u6d88\u606f\u63a8\u9001\u5f02\u5e38\uff01 \u5f53\u524d\u5f02\u5e38:{} \u539f\u59cb\u5f02\u5e38:{}", (Object)exception.getMessage(), (Object)e.getMessage());
            }
        }
        HttpUtil.setContentType((MsgContext)msgContext, (String)mediaType.toString());
        ResultData resultData = e instanceof AbilityException ? ((codeMsg = ((AbilityException)e).codeMsg) != null ? ResultData.error((CodeMsg)codeMsg) : ResultData.error((CodeMsg)CodeMsg.ESB_ERROR.fillArgs(new Object[]{":" + e.getMessage()}))) : ResultData.error((CodeMsg)CodeMsg.ESB_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        String outputProtocol = null;
        if (msgContext.getEsbAbility() != null) {
            outputProtocol = msgContext.getEsbAbility().getOutputProtocal();
        }
        if (StringUtils.isEmpty(outputProtocol)) {
            return ((ServerResponse.BodyBuilder)ServerResponse.badRequest().headers(httpHeaders -> msgContext.getSelfDefHeader().getSelfDefRspMap().forEach((k, v) -> httpHeaders.add(k, v)))).body((Publisher)Mono.just((Object)resultData), ResultData.class);
        }
        try {
            Object msg = null;
            if (StringUtils.isNotBlank((CharSequence)outputProtocol)) {
                DefinedExceptionPO definedExceptionPO = new DefinedExceptionPO();
                definedExceptionPO.setInputProtocal(inputProtocol);
                definedExceptionPO.setOutputProtocal(outputProtocol);
                DefinedExceptionPO definedExceptionPO1 = this.definedExceptionMapper.queryLimitOne(definedExceptionPO);
                msg = this.getMsg(msgContext, resultData, definedExceptionPO1, inputProtocol);
            }
            if (ObjectUtils.isEmpty((Object)msgContext.getTlogRspHeader())) {
                tlogRspHeader = new TlogRspHeader();
                tlogRspHeader.setRspData(msg.toString().getBytes(StandardCharsets.UTF_8));
                msgContext.setTlogRspHeader(tlogRspHeader);
            } else {
                msgContext.getTlogRspHeader().setRspData(msg.toString().getBytes(StandardCharsets.UTF_8));
            }
            this.factoryTransformer.getStrategy(msgContext.getEsbAbility().getRspTransType()).invokeTransBack(msgContext);
            msg = new String(msgContext.getTlogRspHeader().getRspData(), Consts.UTF_8);
            PrintTLogUtil.printErrorRequestOutLog(msgContext, msg);
            tlogRspHeader = Mono.just((Object)HtmlUtil.htmlUnescape((String)msg.toString())).flatMap(s -> ((ServerResponse.BodyBuilder)ServerResponse.ok().headers(httpHeaders -> msgContext.getSelfDefHeader().getSelfDefRspMap().forEach((k, v) -> httpHeaders.add(k, v)))).syncBody(s));
            abilityData = new HashMap<String, Object>();
            abilityData.put("resultData", GsonUtil.toJson((Object)resultData));
        }
        catch (JAXBException ex) {
            logger.error("\u8c03\u7528\u81ea\u5b9a\u4e49\u5f02\u5e38\u903b\u8f91\u811a\u672c\u5f02\u5e38", (Throwable)ex);
            tlogRspHeader = ((ServerResponse.BodyBuilder)ServerResponse.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).headers(httpHeaders -> msgContext.getSelfDefHeader().getSelfDefRspMap().forEach((k, v) -> httpHeaders.add(k, v)))).body((Publisher)Mono.just((Object)CodeMsg.E_ESB_ERR), CodeMsg.class);
            HashMap<String, Object> abilityData2 = new HashMap<String, Object>();
            abilityData2.put("resultData", GsonUtil.toJson((Object)resultData));
            abilityData2.put("rspInBody", ObjectUtils.isEmpty((Object)msgContext.getTlogReqHeader().getReqObj()) ? "" : msgContext.getTlogReqHeader().getReqObj());
            abilityData2.put("rspInHeader", ObjectUtils.isEmpty((Object)msgContext.getTlogReqHeader().getHeadersMap()) ? "" : msgContext.getTlogReqHeader().getHeadersMap());
            abilityData2.put("error", GsonUtil.toJson((Object)e));
            String key = this.constantBaseVersion.getABILITY_PLATFORM_ERROR() + msgContext.getEsbAbility().getAbilityEname() + "_" + msgContext.getEsbAbility().getAbilityVersion() + "_" + msgContext.getSelfDefHeader().getSysTransId() + "_" + DateUtil.formatDateWithMS((Date)new Date());
            this.cacheClient.set(key, (Object)GsonUtil.toJson(abilityData2));
            this.cacheClient.expire(key, 60 * Integer.parseInt(this.time));
            this.abnormalGrabService.programError(msgContext, e);
            return tlogRspHeader;
        }
        catch (Exception ex2) {
            logger.error("\u8c03\u7528\u81ea\u5b9a\u4e49\u5f02\u5e38\u903b\u8f91\u811a\u672c\u5f02\u5e38", (Throwable)ex2);
            ResultData resultData_ = ResultData.error((CodeMsg)CodeMsg.ESB_ERROR.fillArgs(new Object[]{":\u8c03\u7528\u81ea\u5b9a\u4e49\u5f02\u5e38\u903b\u8f91\u811a\u672c\u5f02\u5e38(%s)"}).fillArgs(new Object[]{ex2.getMessage()}));
            Mono mono = ((ServerResponse.BodyBuilder)ServerResponse.badRequest().headers(httpHeaders -> msgContext.getSelfDefHeader().getSelfDefRspMap().forEach((k, v) -> httpHeaders.add(k, v)))).body((Publisher)Mono.just((Object)resultData_), ResultData.class);
            HashMap<String, Object> abilityData3 = new HashMap<String, Object>();
            abilityData3.put("resultData", GsonUtil.toJson((Object)resultData));
            {
                catch (Throwable throwable) {
                    HashMap<String, Object> abilityData4 = new HashMap<String, Object>();
                    abilityData4.put("resultData", GsonUtil.toJson((Object)resultData));
                    abilityData4.put("rspInBody", ObjectUtils.isEmpty((Object)msgContext.getTlogReqHeader().getReqObj()) ? "" : msgContext.getTlogReqHeader().getReqObj());
                    abilityData4.put("rspInHeader", ObjectUtils.isEmpty((Object)msgContext.getTlogReqHeader().getHeadersMap()) ? "" : msgContext.getTlogReqHeader().getHeadersMap());
                    abilityData4.put("error", GsonUtil.toJson((Object)e));
                    String key = this.constantBaseVersion.getABILITY_PLATFORM_ERROR() + msgContext.getEsbAbility().getAbilityEname() + "_" + msgContext.getEsbAbility().getAbilityVersion() + "_" + msgContext.getSelfDefHeader().getSysTransId() + "_" + DateUtil.formatDateWithMS((Date)new Date());
                    this.cacheClient.set(key, (Object)GsonUtil.toJson(abilityData4));
                    this.cacheClient.expire(key, 60 * Integer.parseInt(this.time));
                    this.abnormalGrabService.programError(msgContext, e);
                    throw throwable;
                }
            }
            abilityData3.put("rspInBody", ObjectUtils.isEmpty((Object)msgContext.getTlogReqHeader().getReqObj()) ? "" : msgContext.getTlogReqHeader().getReqObj());
            abilityData3.put("rspInHeader", ObjectUtils.isEmpty((Object)msgContext.getTlogReqHeader().getHeadersMap()) ? "" : msgContext.getTlogReqHeader().getHeadersMap());
            abilityData3.put("error", GsonUtil.toJson((Object)e));
            String key2 = this.constantBaseVersion.getABILITY_PLATFORM_ERROR() + msgContext.getEsbAbility().getAbilityEname() + "_" + msgContext.getEsbAbility().getAbilityVersion() + "_" + msgContext.getSelfDefHeader().getSysTransId() + "_" + DateUtil.formatDateWithMS((Date)new Date());
            this.cacheClient.set(key2, (Object)GsonUtil.toJson(abilityData3));
            this.cacheClient.expire(key2, 60 * Integer.parseInt(this.time));
            this.abnormalGrabService.programError(msgContext, e);
            return mono;
        }
        abilityData.put("rspInBody", ObjectUtils.isEmpty((Object)msgContext.getTlogReqHeader().getReqObj()) ? "" : msgContext.getTlogReqHeader().getReqObj());
        abilityData.put("rspInHeader", ObjectUtils.isEmpty((Object)msgContext.getTlogReqHeader().getHeadersMap()) ? "" : msgContext.getTlogReqHeader().getHeadersMap());
        abilityData.put("error", GsonUtil.toJson((Object)e));
        String key = this.constantBaseVersion.getABILITY_PLATFORM_ERROR() + msgContext.getEsbAbility().getAbilityEname() + "_" + msgContext.getEsbAbility().getAbilityVersion() + "_" + msgContext.getSelfDefHeader().getSysTransId() + "_" + DateUtil.formatDateWithMS((Date)new Date());
        this.cacheClient.set(key, (Object)GsonUtil.toJson(abilityData));
        this.cacheClient.expire(key, 60 * Integer.parseInt(this.time));
        this.abnormalGrabService.programError(msgContext, e);
        return tlogRspHeader;
    }

    private Object getMsg(MsgContext msgContext, ResultData resultData, DefinedExceptionPO definedExceptionPO1, String inputProtocol) throws ScriptException, NoSuchMethodException, JAXBException, JsonProcessingException {
        String fromIp = null;
        if (msgContext.getTlogReqHeader() != null) {
            fromIp = msgContext.getTlogReqHeader().getFromIp();
        }
        EsbAbility esbAbility = msgContext.getEsbAbility();
        String funName = esbAbility.getAbilityEname() + esbAbility.getAbilityVersion() + "ErrorFun";
        funName = funName.replace(".", "_");
        if (inputProtocol.equals("json")) {
            return this.mngHelperService.evalException(funName, definedExceptionPO1.getExceptionLogic(), new Object[]{resultData, JacksonUtil.toJson((Object)resultData), fromIp});
        }
        if (inputProtocol.equals("xml")) {
            return this.mngHelperService.evalException(funName, definedExceptionPO1.getExceptionLogic(), new Object[]{resultData, JaxbUtil.beanToXml((Object)resultData, (String)"UTF-8"), fromIp});
        }
        if (inputProtocol.equals("ws")) {
            return this.mngHelperService.evalException(funName, definedExceptionPO1.getExceptionLogic(), new Object[]{JaxbUtil.beanToXml((Object)resultData, (String)"UTF-8"), fromIp});
        }
        return this.mngHelperService.evalException(funName, definedExceptionPO1.getExceptionLogic(), new Object[]{JacksonUtil.toJson((Object)resultData), fromIp});
    }
}

