/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.component.js;

import cn.hutool.core.codec.Base32;
import com.alibaba.fastjson.JSON;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.gson.Gson;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.ResultData;
import com.ohaotian.abilitycommon.model.bo.system.AbilityToVega;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.JsonXmlUtil;
import com.ohaotian.abilitycommon.util.MD5Util;
import com.ohaotian.abilitycommon.util.UUIDUtil;
import com.ohaotian.abilityweb.config.esbability.EsbAbilityMap;
import com.ohaotian.abilityweb.service.esb.EsbServiceImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.dom4j.Document;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

@Component
public class JsHelper {
    public static final Logger log = LogManager.getLogger(JsHelper.class);
    @Resource
    EsbServiceImpl esbService;
    @Resource
    NodeInfoConfig nodeInfo;
    private static EsbServiceImpl staticEsbService;
    private static NodeInfoConfig staticNodeInfo;
    private static final String ALGORITHM = "DESede";
    private static final int KEY_SIZE = 1024;
    private static final String RSA_ALGORITHM = "RSA";

    @PostConstruct
    public void init() {
        staticEsbService = this.esbService;
        staticNodeInfo = this.nodeInfo;
    }

    private static MsgContext buildSubMsgCtx(MsgContext parentMsgCtx, String abilityEname, String version, String reqData) {
        MsgContext subMsgCtx = new MsgContext();
        EsbAbility esbAbility = EsbAbilityMap.getAbility(abilityEname, version);
        if (esbAbility == null) {
            throw new AbilityException(CodeMsg.E_ESB_EXP_SC.fillArgs(new Object[]{":\u8c03\u7528\u5b50\u670d\u52a1,\u5b9e\u4f8b:" + staticNodeInfo.getNodeIp() + ":" + staticNodeInfo.getPort() + "\u672a\u90e8\u7f72\u670d\u52a1:" + abilityEname + "\u7248\u672c:" + version}));
        }
        subMsgCtx.setEsbAbility(esbAbility);
        subMsgCtx.setRequestMode(parentMsgCtx.getRequestMode());
        SelfDefHeader selfDefHeader = new SelfDefHeader();
        selfDefHeader.setParentTransId(parentMsgCtx.getSelfDefHeader().getSysTransId());
        selfDefHeader.setApp(parentMsgCtx.getSelfDefHeader().getApp());
        selfDefHeader.setSysTransId(UUIDUtil.generateUuid());
        selfDefHeader.setClusterId(staticNodeInfo.getClusterId());
        selfDefHeader.setSelfDefMap(parentMsgCtx.getSelfDefHeader().getSelfDefMap());
        subMsgCtx.setSelfDefHeader(selfDefHeader);
        TlogReqHeader tlogReqHeader = new TlogReqHeader();
        tlogReqHeader.setReqData(reqData.getBytes(Consts.UTF_8));
        tlogReqHeader.setReqRecvStartTime(System.currentTimeMillis());
        tlogReqHeader.setHeadersMap(parentMsgCtx.getTlogReqHeader().getHeadersMap());
        subMsgCtx.setTlogReqHeader(tlogReqHeader);
        subMsgCtx.setInputProtocal(esbAbility.getInputProtocal());
        return subMsgCtx;
    }

    public static void setHeader(MsgContext parentMsgCtx, String key, String value) {
        Map selfDefMap = parentMsgCtx.getSelfDefHeader().getSelfDefMap();
        selfDefMap.put(key, value);
    }

    public static void setRspHeader(MsgContext msgContext, String key, String value) {
        HashMap<String, String> selfDefMap = msgContext.getSelfDefHeader().getSelfDefRspMap();
        if (selfDefMap != null) {
            selfDefMap.put(key, value);
        } else {
            selfDefMap = new HashMap<String, String>();
        }
    }

    public static String invoke(MsgContext msgContext, String svcName, String version, String reqData) throws NoSuchFieldException, IllegalAccessException {
        MsgContext ms = JsHelper.buildSubMsgCtx(msgContext, svcName, version, reqData);
        ms.setAbilityToVega(new AbilityToVega());
        ms.getAbilityToVega().setRouterAddress("/" + msgContext.getInputProtocal() + "/" + svcName + "/" + version);
        ms.setInputProtocal(msgContext.getInputProtocal());
        return staticEsbService.callSubService(ms);
    }

    public static String invoke(MsgContext msgContext, String svcName, String version, String reqData, String inputProtocal) throws NoSuchFieldException, IllegalAccessException {
        MsgContext ms = JsHelper.buildSubMsgCtx(msgContext, svcName, version, reqData);
        ms.setAbilityToVega(new AbilityToVega());
        ms.getAbilityToVega().setRouterAddress("/" + inputProtocal + "/" + svcName + "/" + version);
        ms.setInputProtocal(inputProtocal);
        return staticEsbService.callSubService(ms);
    }

    public static String test(String reqData) {
        return UUIDUtil.generateUuid() + reqData;
    }

    public static String getString(byte[] bytes) {
        return new String(bytes, Consts.UTF_8);
    }

    public static void throwExp(String msg) {
        throw new AbilityException(msg);
    }

    public static void throwExp(String errCode, String msg) {
        throw new AbilityException(errCode, msg);
    }

    public static void throwExp(String errCode, String msg, Throwable e) {
        throw new AbilityException(errCode, msg, e);
    }

    public static void throwExp(String errMsg, Throwable e) {
        throw new AbilityException(CodeMsg.E_ESB_ERR.getRspCode(), errMsg, e);
    }

    public static void throwExp(Throwable t) throws Throwable {
        throw t;
    }

    public static void execCmdThrowExp(String[] cmdarray) throws Exception {
        ExecCmdResult ret = JsHelper.execCmd(cmdarray);
        if (ret.retCode == 1) {
            StringBuilder s = new StringBuilder();
            for (String c : cmdarray) {
                s.append(c);
            }
            throw new AbilityException("\u6267\u884c\u547d\u4ee4[" + s.toString() + "]\u51fa\u9519:" + ret.errMsg);
        }
    }

    public static ExecCmdResult execCmd(String[] cmdarray) throws Exception {
        return JsHelper.execCmd(cmdarray, null, null);
    }

    public static ExecCmdResult execCmd(String[] cmdarray, String[] envp, File dir) throws Exception {
        Process process = Runtime.getRuntime().exec(cmdarray, envp, dir);
        BufferedReader stdOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader stdErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder sbOut = new StringBuilder(256);
        StringBuilder sbErr = new StringBuilder(256);
        new Thread(() -> {
            try {
                String line;
                while ((line = stdErr.readLine()) != null) {
                    sbErr.append(Constants.LINE_SEPARATOR).append(line);
                }
            }
            catch (Exception e) {
                sbErr.append(Constants.LINE_SEPARATOR).append("\u8bfb\u53d6\u9519\u8bef\u4fe1\u606f\u65f6\u5f02\u5e38\uff1a" + e.toString());
            }
        }).start();
        new Thread(() -> {
            try {
                String line;
                while ((line = stdOut.readLine()) != null) {
                    sbOut.append(Constants.LINE_SEPARATOR).append(line);
                }
            }
            catch (Exception e) {
                sbErr.append(Constants.LINE_SEPARATOR).append("\u8bfb\u53d6\u8f93\u51fa\u4fe1\u606f\u65f6\u5f02\u5e38\uff1a" + e.toString());
            }
        }).start();
        int retCode = process.waitFor();
        stdErr.close();
        stdOut.close();
        return new ExecCmdResult(retCode, sbOut.toString(), sbErr.toString());
    }

    public static Connection getConn(String url, String username, String password) throws ClassNotFoundException, SQLException {
        String driver = "com.mysql.jdbc.Driver";
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (ClassNotFoundException e) {
            log.error("class not found exception:" + e);
            throw e;
        }
        catch (SQLException e) {
            log.error("sql exception:" + e);
            throw e;
        }
        return conn;
    }

    public static void close(ResultSet rs, Statement ps, Connection conn) throws SQLException {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.error("close ResultSet exception:" + e);
            throw e;
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            log.error("close Statement exception:" + e);
            throw e;
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error("close Connection exception:" + e);
            throw e;
        }
    }

    public static void close(Statement ps, Connection conn) throws SQLException {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            log.error("close Statement exception:" + e);
            throw e;
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error("close Connection exception:" + e);
            throw e;
        }
    }

    public static void close(Connection conn) throws SQLException {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error("close Connection exception:" + e);
            throw e;
        }
    }

    public static String base64Encode(String text) {
        return new BASE64Encoder().encode(text.getBytes());
    }

    public static String base64EncodeByteStr(byte[] text) {
        return new BASE64Encoder().encode(text);
    }

    public static String base64Decode(String text) throws IOException {
        return new String(new BASE64Decoder().decodeBuffer(text));
    }

    public static byte[] base64DecodeToByte(String text) throws IOException {
        return new BASE64Decoder().decodeBuffer(text);
    }

    public static String filterXmlSpecialChar(String srcStr) {
        if (srcStr == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(srcStr.length() * 2);
        block4: for (int i = 0; i < srcStr.length(); ++i) {
            switch (srcStr.charAt(i)) {
                case '<': {
                    result.append("&lt;");
                    continue block4;
                }
                case '&': {
                    result.append("&amp;");
                    continue block4;
                }
                default: {
                    result.append(srcStr.charAt(i));
                }
            }
        }
        return result.toString();
    }

    public static String json2Xml(String json, Document templateDoc) {
        if (templateDoc == null) {
            String xml = null;
            try {
                xml = new String(JsonXmlUtil.callMapToXML((Map)JsHelper.json2Map(json)), "utf-8");
                return xml;
            }
            catch (Exception e) {
                log.error("json\u8f6cXML\u51fa\u9519\uff1a", (Throwable)e);
                throw new AbilityException("json\u8f6cXML\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
        return JsonXmlUtil.json2SortedXml((String)json, (Document)templateDoc);
    }

    public static String xml2Json(String xml, Boolean isRemoveAttribute, Boolean islowercase) {
        return JsonXmlUtil.xml2JSON((String)xml, (Boolean)isRemoveAttribute, (Boolean)islowercase);
    }

    public static Map xml2Map(String xml) {
        return JsHelper.xml2MapLowercase(xml);
    }

    public static Map xml2MapLowercase(String xml) {
        return JsonXmlUtil.xml2Map((String)xml, (Boolean)false);
    }

    public static Map xml2MapUppercase(String xml) {
        return JsonXmlUtil.xml2Map((String)xml, (Boolean)true);
    }

    public static Map json2Map(String json) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.readValue(json, Map.class);
        return map;
    }

    public static String object2ws(Object o, String type) {
        if (o == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        if (o instanceof Map) {
            s = s.append(JsHelper.map2ws((Map)o, type));
        } else if (o instanceof List) {
            for (Object v : (List)o) {
                s = s.append(JsHelper.object2ws(v, type));
            }
        } else {
            return (String)o;
        }
        return s.toString();
    }

    public static String map2ws(Map<String, Object> map, String type) {
        if (map == null || map.size() < 1) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                s = s.append(JsHelper.map2ws((Map)entry.getValue(), type));
                continue;
            }
            if (entry.getValue() instanceof List) {
                JsHelper.object2ws(entry.getValue(), type);
                continue;
            }
            s = s.append("<").append(type).append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(type).append(entry.getKey()).append(">");
        }
        if (s.length() < 1) {
            log.error("map\u8f6cws\u5f02\u5e38\uff0cmap\u4e3a\u7a7a\u3002\u8bf7\u67e5\u8be2...");
            throw new AbilityException("map\u8f6cws\u5f02\u5e38\uff0cmap\u4e3a\u7a7a\u3002\u8bf7\u67e5\u8be2...");
        }
        return s.toString();
    }

    public static Map forms2Map(String forms) {
        if (StringUtils.isEmpty((Object)forms)) {
            return new HashMap(8);
        }
        HashMap map = new HashMap(16);
        String[] split = forms.split("&");
        Arrays.asList(split).forEach(k -> {
            int i = k.indexOf("=", 1);
            map.put(k.substring(0, i), k.substring(i + 1));
        });
        return map;
    }

    public static JSONObject forms2JsonObject(String forms) {
        JSONObject json = new JSONObject();
        if (StringUtils.isEmpty((Object)forms)) {
            return json;
        }
        String[] split = forms.split("&");
        Arrays.asList(split).forEach(k -> {
            int i = k.indexOf("=", 1);
            if (k.substring(i + 1).startsWith("{")) {
                json.put((Object)k.substring(0, i), (Object)JSONObject.fromObject((Object)k.substring(i + 1)));
            } else if (k.substring(i + 1).startsWith("[")) {
                json.put((Object)k.substring(0, i), (Object)JSONArray.fromObject((Object)k.substring(i + 1)));
            } else {
                json.put((Object)k.substring(0, i), (Object)k.substring(i + 1));
            }
        });
        return json;
    }

    public static String map2forms(Map map) {
        if (map == null || map.size() < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        map.forEach((k, v) -> stringBuffer.append(k).append("=").append(v).append("&"));
        if (stringBuffer.length() > 0) {
            return stringBuffer.deleteCharAt(stringBuffer.length() - 1).toString();
        }
        return stringBuffer.toString().endsWith("&") ? stringBuffer.substring(0, stringBuffer.length() - 2).toString() : stringBuffer.toString();
    }

    public static String md5(String str) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return MD5Util.md5((String)str);
    }

    public static String getSha256Sign(String appId, String appKey, String signType, MsgContext msgCtx) throws Exception {
        log.info("\u8fdb\u5165\u7b7e\u540d\u65b9\u6cd5");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = sdf.format(new Date());
        msgCtx.getTlogReqHeader().getHeadersMap().put("req_time", nowTime);
        Map map = JsHelper.json2Map(msgCtx.getReqText());
        String json = JSON.toJSONString((Object)map);
        String encode = URLEncoder.encode(json, "UTF-8");
        String bizContent = Base64.encodeBase64String((byte[])encode.getBytes());
        msgCtx.getTlogReqHeader().getHeadersMap().put("biz_content", bizContent);
        msgCtx.getTlogReqHeader().getHeadersMap().put("Content-Type", "multipart/form-data");
        String waitSign = "appId=" + appId + "&bizContent=" + bizContent + "&signType=" + signType + "&timestamp=" + nowTime;
        String sign = JsHelper.sha256(JsHelper.sha256(waitSign) + appKey);
        sign = Base64.encodeBase64String((byte[])sign.getBytes());
        msgCtx.getTlogReqHeader().getHeadersMap().put("sign", sign);
        HashMap<String, String> rspMap = new HashMap<String, String>();
        rspMap.put("appId", appId);
        rspMap.put("sign", sign);
        rspMap.put("signType", signType);
        rspMap.put("timestamp", nowTime);
        rspMap.put("bizContent", bizContent);
        return JSON.toJSONString(rspMap);
    }

    public static String sha256(String inStr) {
        String sign = null;
        try {
            sign = JsHelper.digest(inStr.getBytes("UTF-8"), "SHA-256");
        }
        catch (Exception e) {
            log.error("sha256\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        if (null == sign) {
            return null;
        }
        return sign;
    }

    public static String digest(byte[] inputBytes, String algorithm) {
        String sign = null;
        try {
            MessageDigest alg = MessageDigest.getInstance(algorithm);
            alg.update(inputBytes);
            byte[] digest = alg.digest();
            sign = JsHelper.byte2Hex(digest);
        }
        catch (Exception ex) {
            log.error("digest\u52a0\u5bc6\u9519\u8bef\uff0c\u52a0\u5bc6\u65b9\u5f0f\uff1a" + algorithm + ",\u9519\u8bef\uff1a" + ex);
        }
        if (null == sign) {
            return null;
        }
        return sign.toUpperCase();
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        String temp = null;
        for (byte aByte : bytes) {
            temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                sb.append("0");
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    private static String map2form(Map map) {
        StringBuffer s = new StringBuffer(16);
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                s.append(k).append("=").append(JSONObject.fromObject((Object)v)).append("&");
            } else if (v instanceof List) {
                s.append(k).append("=").append(JSONArray.fromObject((Object)v)).append("&");
            } else {
                s.append(k).append("=").append(v).append("&");
            }
        });
        return s.toString().substring(0, s.length() - 1);
    }

    public static String json2Form(String jsonStr) {
        Map map = (Map)JSON.parseObject((String)jsonStr, Map.class);
        return JsHelper.map2form(map);
    }

    public static String mergeObj(String key, String value, String jsonString) throws IOException {
        Map map = JsHelper.json2Map(jsonString);
        map.put(key, value);
        return JsHelper.mapToJson(map);
    }

    public static <T> String mapToJson(Map<String, T> map) {
        Gson gson = new Gson();
        String jsonStr = gson.toJson(map);
        return jsonStr;
    }

    public static String HMACSHA256(String message, String secret) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        Mac sha256HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        sha256HMAC.init(secretKey);
        byte[] hash = sha256HMAC.doFinal(message.getBytes(StandardCharsets.UTF_8));
        return JsHelper.base64UrlEncode(Base64.encodeBase64String((byte[])hash));
    }

    public static String base64UrlEncode(String str) {
        while (str.charAt(str.length() - 1) == '=') {
            str = str.substring(0, str.length() - 1);
        }
        str = str.replace("+", "-");
        str = str.replace("/", "_");
        str = str.replace("\r\n", "");
        return str;
    }

    public static String JWT(String header, String body, String secret) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        String headerE = JsHelper.base64UrlEncode(JsHelper.base64Encode(header));
        System.out.println("header : " + header + "     " + headerE);
        String bodyE = JsHelper.base64UrlEncode(JsHelper.base64Encode(body));
        System.out.println("body : " + body + "     " + bodyE);
        String content = headerE + '.' + bodyE + '.' + JsHelper.HMACSHA256(headerE + '.' + bodyE, secret);
        System.out.println("secret: " + secret);
        System.out.println("token: " + content);
        return content;
    }

    public static byte[] desEncryptMode(byte[] keyByte, byte[] src) {
        try {
            SecretKeySpec desKey = new SecretKeySpec(keyByte, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, desKey);
            return cipher.doFinal(src);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static byte[] desDecryptMode(byte[] keyByte, byte[] src) {
        try {
            SecretKeySpec desKey = new SecretKeySpec(keyByte, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, desKey);
            return cipher.doFinal(src);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static void DES() {
        byte[] keyBytes = new byte[]{17, 34, 79, 88, -120, 16, 64, 56, 40, 37, 121, 81, -53, -35, 85, 102, 119, 41, 116, -104, 48, 64, 54, -30};
        String szSrc = "\u4f60\u597d\u963f\u5bcc\u6c57\u7684\u5341\u56db\u5361";
        byte[] encoded = JsHelper.desEncryptMode(keyBytes, szSrc.getBytes());
        System.out.println("\u52a0\u5bc6\u540e\u7684\u6570\u636e\u4e3a:" + new String(encoded));
        byte[] srcBytes = JsHelper.desDecryptMode(keyBytes, encoded);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u6570\u636e\u4e3a:" + new String(srcBytes));
    }

    public static String Sign(HashMap<String, String> map) {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().toString().compareTo(o2.getKey());
            }
        });
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : list) {
            if (entry.getKey() == "" && entry.getKey() == null) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null || value == "") continue;
            sb.append(key + "=" + value + "&");
        }
        String result = sb.toString();
        String result1 = new String(JsHelper.MD5(result).toUpperCase());
        Map<Integer, String> map2 = JsHelper.creatKeys();
        System.out.println("\u968f\u673a\u751f\u6210\u7684\u516c\u94a5\u4e3a:" + map2.get(0));
        System.out.println("\u968f\u673a\u751f\u6210\u7684\u79c1\u94a5\u4e3a:" + map2.get(1));
        String messageEn = JsHelper.rsaEncrypt(result1, map2.get(1));
        System.out.println(result1 + "\nRSA\u79c1\u94a5\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\u4e32\u4e3a:" + messageEn);
        String messageDe = JsHelper.rsaDecrypt(messageEn, map2.get(0));
        System.out.println("RSA\u8fd8\u539f\u540e\u7684\u5b57\u7b26\u4e32\u4e3a:" + messageDe);
        return null;
    }

    public static void signTest() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fdsa", "133");
        map.put("fdksfa", "fdef");
        JsHelper.Sign(map);
    }

    public static String jsonToParams(String json, String ENCODING) throws Exception {
        Map tmp = (Map)GsonUtil.fromJson((String)json, Map.class);
        TreeMap map = new TreeMap(tmp);
        StringBuilder params = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            params.append("&").append(URLEncoder.encode((String)entry.getKey(), ENCODING)).append("=").append(URLEncoder.encode(entry.getValue().toString(), ENCODING));
        }
        params.deleteCharAt(0);
        return params.toString();
    }

    public static String jsonToParams(String json) throws Exception {
        Map tmp = (Map)GsonUtil.fromJson((String)json, TreeMap.class);
        TreeMap map = new TreeMap(tmp);
        StringBuilder params = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            params.append("&").append((String)entry.getKey()).append("=").append(entry.getValue().toString());
        }
        params.deleteCharAt(0);
        return params.toString();
    }

    public static String aluSignature(String json, String http_method, String secret, String ENCODING) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(http_method);
        stringBuilder.append("&");
        stringBuilder.append(URLEncoder.encode("/", ENCODING));
        stringBuilder.append("&");
        String params = JsHelper.jsonToParams(json, ENCODING);
        System.out.println(params);
        stringBuilder.append(URLEncoder.encode(params, ENCODING));
        System.out.println(stringBuilder);
        secret = secret + '&';
        return JsHelper.HMACSHA1(stringBuilder.toString(), secret);
    }

    public static String HMACSHA1(String message, String secret) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        Mac sha1HMAC = Mac.getInstance("HmacSHA1");
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
        sha1HMAC.init(secretKey);
        byte[] hash = sha1HMAC.doFinal(message.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.encodeBase64((byte[])hash), StandardCharsets.UTF_8);
    }

    public static String MD5(String value) {
        if (value == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(value.getBytes(StandardCharsets.UTF_8));
            return new BigInteger(1, messageDigest.digest()).toString(16);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static void aliyunUpdateSynonymsDicts(MsgContext msgContext, String requestBody, String instanceId, String ak, String sk, String zone) {
        DefaultProfile profile = DefaultProfile.getProfile((String)zone, (String)ak, (String)sk);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.PUT);
        request.setDomain("elasticsearch." + zone + ".aliyuncs.com");
        request.setVersion("2017-06-13");
        request.setUriPattern("/openapi/instances/" + instanceId + "/synonymsDict");
        request.putHeadParameter("Content-Type", "application/json");
        request.setHttpContent(requestBody.getBytes(), "utf-8", FormatType.JSON);
        TlogRspHeader tlogRspHeader = new TlogRspHeader();
        try {
            CommonResponse response = client.getCommonResponse(request);
            tlogRspHeader.setHeaders(response.getHttpResponse().getHeaders());
            msgContext.setTlogRspHeader(tlogRspHeader);
            msgContext.getTlogRspHeader().setRspData(response.getData().getBytes(Consts.UTF_8));
        }
        catch (ClientException e) {
            msgContext.setTlogRspHeader(tlogRspHeader);
            CodeMsg codeMsg = new CodeMsg(CodeMsg.E_ESB_ERR.getRspCode(), e.getMessage());
            ResultData resultData = ResultData.error((CodeMsg)codeMsg);
            msgContext.getTlogRspHeader().setRspData(GsonUtil.toJson((Object)resultData).getBytes(Consts.UTF_8));
        }
    }

    public static Map<Integer, String> creatKeys() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_ALGORITHM);
            keyPairGenerator.initialize(1024);
            PrivateKey privateKey = keyPairGenerator.generateKeyPair().getPrivate();
            PublicKey publicKey = keyPairGenerator.generateKeyPair().getPublic();
            String publicKeyString = new String(Base32.encode((byte[])publicKey.getEncoded()));
            String privateKeyString = new String(Base32.encode((byte[])privateKey.getEncoded()));
            HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
            keyMap.put(0, publicKeyString);
            keyMap.put(1, privateKeyString);
            return keyMap;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static String rsaEncrypt(String src, String privateKey) {
        try {
            byte[] keyBytes = Base32.decode((String)privateKey);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, keyFactory.generatePrivate(keySpec));
            String cipherStr = Base32.encode((String)src);
            return cipherStr;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static String rsaDecrypt(String src, String publicKey) {
        try {
            byte[] keyBytes = Base32.decode((String)publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, pubKey);
            String outSrc = new String(Base32.decode((String)src));
            return outSrc;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        SimpleDateFormat gmtDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z ", Locale.ENGLISH);
        gmtDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateStr = gmtDateFormat.format(new Date());
        System.out.println("\u8f6c\u6362\u4e3aGMT\uff1a");
        System.out.println(dateStr);
    }

    public static class ExecCmdResult {
        public int retCode;
        public String retMsg;
        public String errMsg;

        public ExecCmdResult(int retCode, String retMsg, String errMsg) {
            this.retCode = retCode;
            this.retMsg = retMsg;
            this.errMsg = errMsg;
        }
    }
}

