/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.cluster;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.system.SystemMap;
import com.ohaotian.abilitycommon.config.systemcode.SystemCodeMap;
import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.enums.SystemCodeTypeEnum;
import com.ohaotian.abilitycommon.enums.SystemCodeValueEnum;
import com.ohaotian.abilitycommon.model.bo.NodeBO;
import com.ohaotian.abilitycommon.model.bo.RedisSyncDataBo;
import com.ohaotian.abilitycommon.model.bo.WebHeartbeatBo;
import com.ohaotian.abilitycommon.model.bo.system.SystemCodeValue;
import com.ohaotian.abilitycommon.util.DateUtil;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.config.cluster.WebClusterConfig;
import com.ohaotian.abilityweb.config.congestion.CongestionConfig;
import com.ohaotian.abilityweb.config.pubsub.loader.PubSubRes;
import com.ohaotian.plugin.cache.CacheClient;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
public class InitClusterMonitor {
    private static final Logger log = LoggerFactory.getLogger(InitClusterMonitor.class);
    @Autowired
    NodeInfoConfig nodeInfoConfig;
    @Autowired
    WebClusterConfig webClusterConfig;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Resource(name="currentCount")
    AtomicInteger currentCount;
    @Resource
    CongestionConfig congestionConfig;
    @Value(value="${atp.sync.time:10}")
    private Integer syncTimeInterval;
    @Resource
    NodeInfoConfig nodeInfo;
    @Resource
    private PubSubRes pubSubRes;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    private static final Semaphore SEMAPHORE = new Semaphore(2);

    public void run() {
        log.info("\u521d\u59cb\u5316web\u5fc3\u8df3");
        String number = String.valueOf(this.syncTimeInterval);
        try {
            number = String.valueOf(SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.parseInt(number)) + 10);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String cron = "0/" + number + " * * * * ?";
        log.info("\u5fc3\u8df3\u76d1\u6d4bcron:" + cron);
        final String finalNumber = number;
        final String startTime = DateUtil.formatDateWithMS((Date)new Date());
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Date date = new Date(System.currentTimeMillis() + 1000L * (Long.parseLong(finalNumber) + 2L));
                String webHeartbeat = GsonUtil.toJson((Object)WebHeartbeatBo.builder().name(InitClusterMonitor.this.webClusterConfig.getName()).time(DateUtil.formatDateWithMS((Date)new Date())).expired(DateUtil.formatDateWithMS((Date)date)).redisSyncDataBo(InitClusterMonitor.this.congestionMonitor()).build());
                Map webHeartbeatMap = GsonUtil.toObjectMap((String)webHeartbeat);
                webHeartbeatMap.put("startTime", startTime);
                InitClusterMonitor.this.cacheClient.set(InitClusterMonitor.this.webClusterConfig.getName(), (Object)GsonUtil.toJson((Object)webHeartbeatMap));
                InitClusterMonitor.this.cacheClient.expire(InitClusterMonitor.this.webClusterConfig.getName(), Integer.parseInt(finalNumber) + 2);
                Object master = InitClusterMonitor.this.cacheClient.get(InitClusterMonitor.this.constantBaseVersion.getMASTER_NAME());
                if (!ObjectUtils.isEmpty((Object)master)) {
                    Map node = GsonUtil.toStringMap((String)master.toString());
                    if (StringUtils.isEmpty((Object)InitClusterMonitor.this.webClusterConfig.getAdminMasterName())) {
                        log.info("\u5bb9\u5668\u542f\u52a8\uff0c\u5411admin\u8fdb\u884c\u6ce8\u518c!");
                        InitClusterMonitor.this.initRedisNode();
                        InitClusterMonitor.this.webClusterConfig.setAdminMasterName((String)node.get("name"));
                    } else if (!InitClusterMonitor.this.webClusterConfig.getAdminMasterName().equals(node.get("name"))) {
                        log.info("admin\u5f02\u5e38\uff0c\u5411admin\u91cd\u65b0\u8fdb\u884c\u6ce8\u518c!");
                        InitClusterMonitor.this.initRedisNode();
                        InitClusterMonitor.this.webClusterConfig.setAdminMasterName((String)node.get("name"));
                    }
                }
            }
        };
        run.run();
        this.threadPoolTaskScheduler.schedule(run, (Trigger)new CronTrigger(cron));
    }

    private RedisSyncDataBo congestionMonitor() {
        String nodePath = this.nodeInfoConfig.getNodeIp() + ":" + this.nodeInfoConfig.getPort();
        SystemCodeValue congestThresholdLow = SystemCodeMap.getSystemCode((String)SystemCodeTypeEnum.CONGEST_THRESHOLD.getCode(), (String)SystemCodeValueEnum.CONGEST_THRESHOLD_LOW.getCode());
        SystemCodeValue congestThresholdMedium = SystemCodeMap.getSystemCode((String)SystemCodeTypeEnum.CONGEST_THRESHOLD.getCode(), (String)SystemCodeValueEnum.CONGEST_THRESHOLD_MEDIUM.getCode());
        int congestThresholdLowNum = 0;
        int congestThresholdMediumNum = 0;
        if (congestThresholdLow == null) {
            log.error("\u5b57\u5178\u8868\u521d\u59cb\u5316\u672a\u6210\u529f\uff01");
            throw new RuntimeException("\u5b57\u5178\u8868\u521d\u59cb\u5316\u672a\u6210\u529f\uff01");
        }
        congestThresholdLowNum = Integer.parseInt(congestThresholdLow.getDicValue());
        if (congestThresholdMedium == null) {
            log.error("\u5b57\u5178\u8868\u521d\u59cb\u5316\u672a\u6210\u529f\uff01");
            throw new RuntimeException("\u5b57\u5178\u8868\u521d\u59cb\u5316\u672a\u6210\u529f\uff01");
        }
        congestThresholdMediumNum = Integer.parseInt(congestThresholdMedium.getDicValue());
        int resUsingRate = (int)((float)this.currentCount.get() / (float)this.congestionConfig.getMaxCount().intValue() * 100.0f);
        SystemMap.getSystemStatus().setResUsingRate(Integer.valueOf(resUsingRate));
        NodeBO bo = new NodeBO();
        bo.setClusterId(this.nodeInfoConfig.getClusterId());
        bo.setNodeIp(this.nodeInfoConfig.getNodeIp());
        bo.setPort(this.nodeInfoConfig.getPort());
        if (resUsingRate <= congestThresholdLowNum) {
            bo.setCongestedStatus(Constants.Priority.PRIORITY_LOW);
        } else if (resUsingRate <= congestThresholdMediumNum) {
            bo.setCongestedStatus(Constants.Priority.PRIORITY_MEDIUM);
        } else {
            bo.setCongestedStatus(Constants.Priority.PRIORITY_HIGH);
        }
        bo.setResUsingRate(Integer.valueOf(resUsingRate));
        RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
        redisSyncDataBo.setCode("CONGESTION");
        redisSyncDataBo.setNodeBo(bo);
        redisSyncDataBo.setMsg(nodePath);
        redisSyncDataBo.setNodeIp(this.nodeInfoConfig.getNodeIp());
        redisSyncDataBo.setPort(this.nodeInfoConfig.getPort());
        return redisSyncDataBo;
    }

    public String getNodePushChannel() {
        return "atp-push-" + this.nodeInfo.getNodeIp() + ":" + this.nodeInfo.getPort() + "-" + this.nodeInfo.getClusterId();
    }

    private void initRedisNode() {
        NodeBO bo = new NodeBO();
        bo.setClusterId(this.nodeInfoConfig.getClusterId());
        bo.setNodeIp(this.nodeInfoConfig.getNodeIp());
        bo.setPort(this.nodeInfoConfig.getPort());
        bo.setCongestedStatus(Integer.valueOf(0));
        bo.setResUsingRate(SystemMap.getSystemStatus().getResUsingRate());
        RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
        redisSyncDataBo.setName(this.webClusterConfig.getName());
        redisSyncDataBo.setCode("HEARTBEAT");
        redisSyncDataBo.setNodeBo(bo);
        this.pubSubRes.getClient().publish("", GsonUtil.toJson((Object)redisSyncDataBo));
    }
}

