/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.init;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.system.SystemMap;
import com.ohaotian.abilitycommon.config.system.SystemStatus;
import com.ohaotian.abilitycommon.config.systemcode.SystemCodeMap;
import com.ohaotian.abilitycommon.config.systemcol.SystemColMap;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.exception.ErrorInfo;
import com.ohaotian.abilitycommon.exception.RspCode;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.SystemExtColumnBO;
import com.ohaotian.abilitycommon.model.bo.system.SystemCodeType;
import com.ohaotian.abilitycommon.model.bo.system.SystemCodeValue;
import com.ohaotian.abilitycommon.util.BeanMapper;
import com.ohaotian.abilitylog.config.InitTransactionGrab;
import com.ohaotian.abilityweb.component.deploy.SvcDeployHelp;
import com.ohaotian.abilityweb.config.cluster.InitClusterMonitor;
import com.ohaotian.abilityweb.config.cluster.WebClusterConfig;
import com.ohaotian.abilityweb.config.esbability.EsbAbilityMap;
import com.ohaotian.abilityweb.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityweb.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityweb.mapper.RspCodeMapper;
import com.ohaotian.abilityweb.mapper.SystemExtColumnMapper;
import com.ohaotian.abilityweb.model.po.RspCodePO;
import com.ohaotian.abilityweb.model.po.SystemCodeTypePO;
import com.ohaotian.abilityweb.model.po.SystemCodeValuePO;
import com.ohaotian.abilityweb.model.po.SystemExtColumnPO;
import com.ohaotian.abilityweb.service.limit.single.EsbAbilityAppLimitMap;
import com.ohaotian.abilityweb.service.limit.single.EsbAbilityLimitMap;
import com.ohaotian.abilityweb.service.sync.InitDataService;
import com.ohaotian.abilityweb.service.systemcode.SystemCodeTypeService;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

@Configuration
public class InitAbilityConfig
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(InitAbilityConfig.class);
    @Resource
    private SystemCodeTypeService systemCodeTypeService;
    @Resource
    private SvcDeployHelp svcDeployHelp;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Resource
    private InitDataService initDataService;
    @Resource
    private RspCodeMapper rspCodeMapper;
    @Resource
    ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Resource
    SystemExtColumnMapper systemExtColumnMapper;
    @Autowired
    PubSubMsgHandler pubSubMsgHandler;
    @Autowired
    PubSubRes pubSubRes;
    @Autowired
    WebClusterConfig webClusterConfig;
    @Autowired
    ServerProperties serverProperties;
    @Autowired
    InitClusterMonitor initClusterMonitor;
    @Autowired
    private InitTransactionGrab initTransactionGrab;
    @Value(value="${ability.start.reacquire:1}")
    private Integer reacquire;
    @Value(value="${ability.start.reGetInfo.flag:false}")
    private boolean reGetInfo;
    private static boolean isFinished = false;

    public static void setIsFinished(Boolean flag) {
        isFinished = flag;
    }

    public static Boolean getIsFinished() {
        return isFinished;
    }

    public void run(String ... args) throws Exception {
        try {
            this.start();
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    private void start() throws Exception {
        boolean status;
        int count = 1;
        do {
            if (!Boolean.FALSE.equals(status = this.initDataService.initData().booleanValue())) continue;
            log.warn("\u7b2c{}\u6b21\u8bf7\u6c42\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25,{}\u5206\u949f\u540e\u91cd\u65b0\u83b7\u53d6\uff01", (Object)count++, (Object)this.reacquire);
            TimeUnit.MINUTES.sleep(this.reacquire.intValue());
        } while (Boolean.FALSE.equals(status) && Boolean.TRUE.equals(this.reGetInfo));
        this.initTransactionGrab.start();
        this.initSystemCode();
        this.initRspCode();
        this.initSystemCol();
        this.initEsbAbility();
        this.initSystemInfo();
        this.startSecondScheduler();
        this.startDailyScheduler();
        this.initClusterMonitor.run();
        InitAbilityConfig.setIsFinished(true);
        log.info("\u521d\u59cb\u5316\u64cd\u4f5c\u5b8c\u6210");
    }

    private void startDailyScheduler() {
        this.threadPoolTaskScheduler.schedule((Runnable)new Thread(() -> {
            EsbAbilityLimitMap.resetDailyCount();
            EsbAbilityAppLimitMap.resetDailyCount();
        }), (Trigger)new CronTrigger("0 0 0 */1 * ?"));
        this.threadPoolTaskScheduler.schedule((Runnable)new Thread(() -> {
            try {
                this.initDataService.initData();
                this.initSystemCode();
                this.initRspCode();
                this.initSystemCol();
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
            }
        }), (Trigger)new CronTrigger("0 0 0 */1 * ?"));
    }

    private void startSecondScheduler() {
        this.threadPoolTaskScheduler.schedule((Runnable)new Thread(() -> {
            EsbAbilityAppLimitMap.resetRate();
            EsbAbilityLimitMap.resetRate();
        }), (Trigger)new CronTrigger("0/1 * * * * ?"));
    }

    private void initSystemCode() {
        SystemCodeMap.removeAll();
        log.info("\u542f\u52a8\u9879\u76ee\u4eceH2\u8bfb\u53d6\u7cfb\u7edf\u53c2\u6570\u5230jvm");
        List<SystemCodeTypePO> systemCodeTypePOList = this.systemCodeTypeService.findAllSystemCodeTypeWithSystemCodeValue();
        for (SystemCodeTypePO systemCodeTypePO : systemCodeTypePOList) {
            SystemCodeType systemCodeType = new SystemCodeType();
            BeanUtils.copyProperties((Object)systemCodeTypePO, (Object)systemCodeType);
            HashMap<String, SystemCodeValue> stringSystemCodeValueMap = new HashMap<String, SystemCodeValue>();
            List<SystemCodeValuePO> systemCodeValueList = systemCodeTypePO.getSystemCodeValuePOList();
            for (SystemCodeValuePO systemCodeValuePO : systemCodeValueList) {
                SystemCodeValue systemCodeValue = new SystemCodeValue();
                BeanUtils.copyProperties((Object)systemCodeValuePO, (Object)systemCodeValue);
                stringSystemCodeValueMap.put(systemCodeValue.getDicCode(), systemCodeValue);
            }
            systemCodeType.setSystemCodeValueMap(stringSystemCodeValueMap);
            SystemCodeMap.getSystemCodeMap().put(systemCodeType.getTypeCode(), systemCodeType);
        }
        log.info("\u8bfb\u53d6\u7cfb\u7edf\u53c2\u6570\u5230jvm\u5b8c\u6210");
    }

    private void initSystemCol() {
        SystemColMap.removeAll();
        List<SystemExtColumnPO> systemExtColumnPOList = this.systemExtColumnMapper.queryByCond(new SystemExtColumnPO());
        List systemExtColumnBOList = BeanMapper.mapList(systemExtColumnPOList, SystemExtColumnBO.class);
        Map<String, List<SystemExtColumnBO>> map = systemExtColumnBOList.stream().collect(Collectors.groupingBy(SystemExtColumnBO::getColCode));
        if (map != null && map.size() > 0) {
            SystemColMap.getSystemColMap().putAll(map);
        }
    }

    private void initEsbAbility() {
        EsbAbilityMap.removeAll();
        log.info("\u542f\u52a8\u9879\u76ee\u4eceH2\u8bfb\u53d6\u80fd\u529b\u5230jvm");
        try {
            String svcPath = Constants.SYSTEM_PATH.concat(Constants.SEPA).concat("svcservice");
            File file = new File(svcPath);
            if (!file.exists()) {
                file.mkdirs();
                log.info("\u521b\u5efa\u57fa\u7840\u8def\u5f84-->" + svcPath);
            }
            Long clusterId = this.nodeInfoConfig.getClusterId();
            Long hireId = this.nodeInfoConfig.getHireId();
            if (clusterId == null) {
                log.error("\u96c6\u7fa4\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u521b\u5efa\u6b64\u96c6\u7fa4id{},\u670d\u52a1\u90e8\u7f72\u5931\u8d25...", (Object)clusterId);
                return;
            }
            if (hireId == null) {
                log.error("\u96c6\u7fa4\u914d\u7f6e\u9519\u8bef\uff0c\u672a\u521b\u5efa\u6b64\u79df\u6237id{},\u670d\u52a1\u90e8\u7f72\u5931\u8d25...", (Object)hireId);
                return;
            }
            log.info("\u6b64\u8282\u70b9\u6240\u5c5e\u96c6\u7fa4id[{}]", (Object)clusterId);
            this.svcDeployHelp.deployAllCustomSvc();
            log.info("\u8bfb\u53d6\u80fd\u529b\u5230jvm\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u80fd\u529b\u5931\u8d25", (Throwable)e);
        }
    }

    private void initRspCode() {
        ErrorInfo.removeAll();
        log.info("\u521d\u59cb\u5316\u5f02\u5e38\u4fe1\u606f");
        List<RspCodePO> rspCodePOList = this.rspCodeMapper.queryByCond(null);
        for (RspCodePO rspCodePO : rspCodePOList) {
            RspCode rspCode = new RspCode();
            BeanUtils.copyProperties((Object)rspCodePO, (Object)rspCode);
            ErrorInfo.RESULT_MASSAGE_MAP.put(rspCode.getRspName(), rspCode);
        }
        CodeMsg codeMsg = new CodeMsg();
        log.info("\u5f02\u5e38\u4fe1\u606f\u521d\u59cb\u5316\u5b8c\u6210   \u5171\u6709" + ErrorInfo.RESULT_MASSAGE_MAP.size());
    }

    private void initSystemInfo() {
        log.info("\u521d\u59cb\u5316\u7cfb\u7edf\u53d8\u91cf");
        SystemStatus status = new SystemStatus();
        status.setResUsingRate(Integer.valueOf(0));
        SystemMap.setSystemStatus((SystemStatus)status);
    }
}

