/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.pubsub;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.system.SystemParam;
import com.ohaotian.abilitycommon.config.systemcode.SystemCodeMap;
import com.ohaotian.abilitycommon.config.systemcol.SystemColMap;
import com.ohaotian.abilitycommon.enums.FisrtLevelEnum;
import com.ohaotian.abilitycommon.model.bo.ModifyStatusBO;
import com.ohaotian.abilitycommon.model.bo.NodeBO;
import com.ohaotian.abilitycommon.model.bo.NodeDataBO;
import com.ohaotian.abilitycommon.model.bo.RedisSyncDataBo;
import com.ohaotian.abilitycommon.model.bo.SyncDataBO;
import com.ohaotian.abilitycommon.model.bo.SyncServiceBO;
import com.ohaotian.abilitycommon.model.bo.SystemExtColumnBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.SystemCodeType;
import com.ohaotian.abilitycommon.model.bo.system.SystemCodeValue;
import com.ohaotian.abilitycommon.util.BeanMapper;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.component.deploy.SvcDeployHelp;
import com.ohaotian.abilityweb.config.cluster.WebClusterConfig;
import com.ohaotian.abilityweb.config.esbability.EsbAbilityMap;
import com.ohaotian.abilityweb.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityweb.mapper.AbilityMapper;
import com.ohaotian.abilityweb.mapper.SystemCodeTypeMapper;
import com.ohaotian.abilityweb.mapper.SystemExtColumnMapper;
import com.ohaotian.abilityweb.model.po.AbilityPO;
import com.ohaotian.abilityweb.model.po.SystemCodeTypePO;
import com.ohaotian.abilityweb.model.po.SystemCodeValuePO;
import com.ohaotian.abilityweb.model.po.SystemExtColumnPO;
import com.ohaotian.abilityweb.service.sync.PluginSyncDataService;
import com.ohaotian.abilityweb.service.sync.SyncDataService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PubSubMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(PubSubMsgHandler.class);
    @Resource
    private SystemCodeTypeMapper systemCodeTypeMapper;
    @Resource
    private SystemExtColumnMapper systemExtColumnMapper;
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private PluginSyncDataService pluginSyncDataService;
    @Resource
    NodeInfoConfig nodeInfo;
    @Resource
    SvcDeployHelp svcDeployHelp;
    @Resource
    SyncDataService syncDataService;
    @Resource
    SystemParam systemParam;
    @Resource
    PubSubRes pubSubRes;
    @Autowired
    WebClusterConfig webClusterConfig;
    private static boolean firstFinished = false;

    public static void setFirstFinished(Boolean flag) {
        firstFinished = flag;
    }

    public static Boolean getFirstFinished() {
        return firstFinished;
    }

    public void redisCoreNodeDeal(String message) {
        RedisSyncDataBo redisSyncDataBo = (RedisSyncDataBo)GsonUtil.fromJson((String)message, RedisSyncDataBo.class);
        RedisSyncDataBo redisSyncProcessedDataBo = new RedisSyncDataBo();
        redisSyncProcessedDataBo.setCode("PROCESSED");
        redisSyncProcessedDataBo.setName(this.webClusterConfig.getName());
        redisSyncProcessedDataBo.setReceiveMsg(GsonUtil.toJson((Object)redisSyncDataBo));
        redisSyncProcessedDataBo.setSuccess(Boolean.TRUE.booleanValue());
        NodeBO nodeBO = new NodeBO();
        nodeBO.setNodeIp(this.nodeInfo.getNodeIp());
        nodeBO.setPort(this.nodeInfo.getPort());
        nodeBO.setClusterId(this.nodeInfo.getClusterId());
        redisSyncProcessedDataBo.setNodeBo(nodeBO);
        if (!ObjectUtils.isEmpty((Object)redisSyncDataBo)) {
            if (redisSyncDataBo.getCode().equals("SYNC_DATA")) {
                try {
                    log.info("\u6570\u636e\u540c\u6b65\u4e2d...");
                    this.dataSync(redisSyncDataBo, 0);
                    if (Boolean.FALSE.equals(firstFinished)) {
                        firstFinished = Boolean.TRUE;
                    }
                    log.info("\u6570\u636e\u540c\u6b65\u5b8c\u6210");
                }
                catch (Exception e) {
                    log.error("\u6570\u636e\u540c\u6b65\u5931\u8d25\uff01");
                    redisSyncProcessedDataBo.setSuccess(Boolean.FALSE.booleanValue());
                    redisSyncProcessedDataBo.setMsg("\u6570\u636e\u540c\u6b65\u5931\u8d25\uff01" + e.getMessage());
                    e.printStackTrace();
                }
            } else if (redisSyncDataBo.getCode().equals("INCREMENT_SYNC_DATA")) {
                try {
                    log.info("\u589e\u91cf\u6570\u636e\u540c\u6b65\u4e2d...");
                    this.dataSync(redisSyncDataBo, 1);
                    log.info("\u589e\u91cf\u6570\u636e\u540c\u6b65\u5b8c\u6210");
                }
                catch (Exception e) {
                    log.error("\u589e\u91cf\u6570\u636e\u540c\u6b65\u5931\u8d25\uff01");
                    redisSyncProcessedDataBo.setSuccess(Boolean.FALSE.booleanValue());
                    redisSyncProcessedDataBo.setMsg("\u589e\u91cf\u6570\u636e\u540c\u6b65\u5931\u8d25\uff01" + e.getMessage());
                    e.printStackTrace();
                }
            } else if (redisSyncDataBo.getCode().equals("DEPLOY_SERVICE")) {
                try {
                    log.info("\u80fd\u529b\u53d1\u5e03\u4e2d...");
                    this.abilityDeploy(redisSyncDataBo);
                    log.info("\u80fd\u529b\u53d1\u5e03\u5b8c\u6210");
                }
                catch (Exception e) {
                    log.error("\u80fd\u529b\u53d1\u5e03\u5931\u8d25\uff01");
                    redisSyncProcessedDataBo.setSuccess(Boolean.FALSE.booleanValue());
                    redisSyncProcessedDataBo.setMsg("\u80fd\u529b\u53d1\u5e03\u5931\u8d25\uff01" + e.getMessage());
                    e.printStackTrace();
                }
            } else if (redisSyncDataBo.getCode().equals("CHECK_MODIFY")) {
                try {
                    log.info("\u80fd\u529b\u72b6\u6001\u4fee\u6539\u4e2d...");
                    this.abilityCheck(redisSyncDataBo.getModifyStatusBO());
                    log.info("\u80fd\u529b\u72b6\u6001\u4fee\u6539\u5b8c\u6210");
                }
                catch (Exception e) {
                    log.error("\u80fd\u529b\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff01");
                    redisSyncProcessedDataBo.setSuccess(Boolean.FALSE.booleanValue());
                    redisSyncProcessedDataBo.setMsg("\u80fd\u529b\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff01" + e.getMessage());
                    e.printStackTrace();
                }
            } else if (redisSyncDataBo.getCode().equals("PROCESSED")) {
                log.error("\u6570\u636e\u5b58\u5728\u5f02\u5e38\uff01");
                log.error("\u9519\u8bef\u6570\u636e\uff1a{}", (Object)GsonUtil.toJson((Object)redisSyncDataBo));
                redisSyncProcessedDataBo.setSuccess(Boolean.FALSE.booleanValue());
                redisSyncProcessedDataBo.setMsg("\u6570\u636e\u5b58\u5728\u5f02\u5e38\uff01" + GsonUtil.toJson((Object)redisSyncDataBo));
            } else if (redisSyncDataBo.getCode().equals("NOTIFY")) {
                log.info(redisSyncDataBo.getMsg());
            }
        } else {
            redisSyncProcessedDataBo.setSuccess(Boolean.FALSE.booleanValue());
            log.error("publish \u6570\u636e\u83b7\u53d6\u5931\u8d25\uff01");
        }
        if (!redisSyncDataBo.getCode().equals("HEARTBEAT") && !redisSyncDataBo.getCode().equals("NOTIFY")) {
            this.pubSubRes.getClient().publish("", GsonUtil.toJson((Object)redisSyncProcessedDataBo));
        }
    }

    private void abilityCheck(ModifyStatusBO modifyStatusBO) throws Exception {
        if (modifyStatusBO.getHirerId().equals(this.nodeInfo.getHireId())) {
            List<SyncDataBO> list = modifyStatusBO.getPrimaryIds().stream().map(id -> {
                SyncDataBO syncDataBO = new SyncDataBO();
                BeanUtils.copyProperties((Object)modifyStatusBO, (Object)syncDataBO);
                syncDataBO.setPrimaryId(id);
                return syncDataBO;
            }).collect(Collectors.toList());
            List<AbilityPO> abilityPOList = this.abilityMapper.queryByAbilityIds(modifyStatusBO.getPrimaryIds());
            String status = modifyStatusBO.getStatus() == 1 ? "\u7b7e\u5230" : " \u7b7e\u9000";
            abilityPOList.forEach(abilityPO -> log.info("\u80fd\u529b\uff1a{}\uff0c\u5df2{}\uff01", (Object)(abilityPO.getAbilityName() + "-->" + abilityPO.getAbilityEname()), (Object)status));
            this.syncDataService.modifyStatus(list, modifyStatusBO.getStatus());
        }
    }

    private void abilityDeploy(RedisSyncDataBo redisSyncDataBo) throws Exception {
        SyncServiceBO syncServiceBo = redisSyncDataBo.getSyncServiceBO();
        if (!CollectionUtils.isEmpty((Collection)syncServiceBo.getClusterIds()) && syncServiceBo.getHirerId().equals(this.nodeInfo.getHireId())) {
            EsbAbility ability;
            if (syncServiceBo.getClusterIds().contains(this.nodeInfo.getClusterId())) {
                if (syncServiceBo.getDeployType() == 0) {
                    this.svcDeployHelp.deleteOneCustomSvcByRedisData(syncServiceBo);
                } else if (syncServiceBo.getDeployType() == 1) {
                    RedisSyncDataBo syncDataBo;
                    if (this.systemParam.getSyncWay().equals("redis") || this.systemParam.getSyncWay().equals("mq")) {
                        log.info("SyncWay\uff1a{},\u6570\u636e\u5f00\u59cb\u540c\u6b65\uff01", (Object)this.systemParam.getSyncWay());
                        this.dataSyncPubSub(redisSyncDataBo, 0);
                    }
                    if (!ObjectUtils.isEmpty((Object)(syncDataBo = this.svcDeployHelp.deployOneCustomSvcByRedisData(syncServiceBo)))) {
                        this.pubSubRes.getClient().publish("", GsonUtil.toJson((Object)syncDataBo));
                    }
                }
            } else if (!StringUtils.isEmpty((Object)syncServiceBo.getAbilityEname()) && !StringUtils.isEmpty((Object)syncServiceBo.getAbilityVersion()) && (ability = EsbAbilityMap.getAbility(syncServiceBo.getAbilityEname(), syncServiceBo.getAbilityVersion())) != null) {
                this.svcDeployHelp.deleteOneCustomSvcByRedisData(syncServiceBo);
            }
        }
    }

    private void dataSync(RedisSyncDataBo redisSyncDataBo, int type) throws Exception {
        if (ObjectUtils.isEmpty((Object)this.systemParam.getSyncWay()) || this.systemParam.getSyncWay().equals("api")) {
            this.dataSyncApi(redisSyncDataBo.getDataBO());
            this.svcDeployHelp.deployAllCustomSvc();
        } else if (this.systemParam.getSyncWay().equals("redis") || this.systemParam.getSyncWay().equals("mq")) {
            this.dataSyncPubSub(redisSyncDataBo, type);
            this.svcDeployHelp.deployAllCustomSvc();
        } else {
            log.error("\u6570\u636e\u540c\u6b65\u9519\u8bef\uff01");
        }
    }

    private void dataSyncPubSub(RedisSyncDataBo redisSyncDataBo, int type) throws Exception {
        List syncDataList = (List)redisSyncDataBo.getSyncDataMap().get(String.valueOf(this.nodeInfo.getClusterId()));
        if (!CollectionUtils.isEmpty((Collection)syncDataList)) {
            syncDataList.forEach(syncData -> {
                try {
                    this.syncDataService.syncData2H2((String)syncData, type);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private void dataSyncApi(NodeDataBO nodeDataBO) throws Exception {
        if (!CollectionUtils.isEmpty((Collection)nodeDataBO.getClusterIds()) && nodeDataBO.getClusterIds().contains(this.nodeInfo.getClusterId()) && nodeDataBO.getHirerId().equals(this.nodeInfo.getHireId())) {
            List list = nodeDataBO.getSyncBOs().stream().map(bo -> {
                SyncDataBO syncDataBO = new SyncDataBO();
                syncDataBO.setClusterId(this.nodeInfo.getClusterId());
                syncDataBO.setHirerId(this.nodeInfo.getHireId());
                syncDataBO.setTraceId(nodeDataBO.getTraceId());
                syncDataBO.setFirstLevel(bo.getFirstLevel());
                syncDataBO.setSecondLevel(bo.getSecondLevel());
                syncDataBO.setPrimaryId(bo.getPrimaryId());
                return syncDataBO;
            }).collect(Collectors.toList());
            List<SyncDataBO> basicList = list.stream().filter(bo -> !bo.getFirstLevel().equals(FisrtLevelEnum.PLUGIN.getName())).collect(Collectors.toList());
            List<SyncDataBO> pluginList = list.stream().filter(bo -> bo.getFirstLevel().equals(FisrtLevelEnum.PLUGIN.getName())).collect(Collectors.toList());
            List<SyncDataBO> systemList = list.stream().filter(bo -> bo.getFirstLevel().equals(FisrtLevelEnum.SYSTEM_CODE.getName())).collect(Collectors.toList());
            if ("all".equals(nodeDataBO.getFlag())) {
                this.syncDataService.syncAll(basicList);
                this.syncDataService.syncAll(pluginList);
                this.syncDataService.syncAll(systemList);
                this.pluginSyncDataService.syncAll(pluginList);
                if (!CollectionUtils.isEmpty(systemList)) {
                    SystemCodeMap.removeAll();
                    List<SystemCodeTypePO> systemCodeTypePOList = this.systemCodeTypeMapper.findAllSystemCodeTypeWithSystemCodeValue();
                    for (SystemCodeTypePO systemCodeTypePO : systemCodeTypePOList) {
                        SystemCodeType systemCodeType = (SystemCodeType)BeanMapper.map((Object)systemCodeTypePO, SystemCodeType.class);
                        HashMap<String, SystemCodeValue> stringSystemCodeValueMap = new HashMap<String, SystemCodeValue>();
                        List<SystemCodeValuePO> systemCodeValueList = systemCodeTypePO.getSystemCodeValuePOList();
                        for (SystemCodeValuePO systemCodeValuePO : systemCodeValueList) {
                            SystemCodeValue systemCodeValue = (SystemCodeValue)BeanMapper.map((Object)systemCodeValuePO, SystemCodeValue.class);
                            stringSystemCodeValueMap.put(systemCodeValue.getDicCode(), systemCodeValue);
                        }
                        systemCodeType.setSystemCodeValueMap(stringSystemCodeValueMap);
                        SystemCodeMap.getSystemCodeMap().put(systemCodeType.getTypeCode(), systemCodeType);
                    }
                    SystemColMap.removeAll();
                    List<SystemExtColumnPO> systemExtColumnPOList = this.systemExtColumnMapper.queryByCond(new SystemExtColumnPO());
                    List systemExtColumnBOList = BeanMapper.mapList(systemExtColumnPOList, SystemExtColumnBO.class);
                    Map<String, List<SystemExtColumnBO>> map = systemExtColumnBOList.stream().collect(Collectors.groupingBy(SystemExtColumnBO::getColCode));
                    if (map != null && map.size() > 0) {
                        SystemColMap.getSystemColMap().putAll(map);
                    }
                }
            } else {
                this.syncDataService.syncIncrement(basicList);
                this.pluginSyncDataService.syncIncrement(pluginList);
            }
        }
    }

    public SystemCodeTypeMapper getSystemCodeTypeMapper() {
        return this.systemCodeTypeMapper;
    }

    public SystemExtColumnMapper getSystemExtColumnMapper() {
        return this.systemExtColumnMapper;
    }

    public AbilityMapper getAbilityMapper() {
        return this.abilityMapper;
    }

    public PluginSyncDataService getPluginSyncDataService() {
        return this.pluginSyncDataService;
    }

    public NodeInfoConfig getNodeInfo() {
        return this.nodeInfo;
    }

    public SvcDeployHelp getSvcDeployHelp() {
        return this.svcDeployHelp;
    }

    public SyncDataService getSyncDataService() {
        return this.syncDataService;
    }

    public SystemParam getSystemParam() {
        return this.systemParam;
    }

    public PubSubRes getPubSubRes() {
        return this.pubSubRes;
    }

    public WebClusterConfig getWebClusterConfig() {
        return this.webClusterConfig;
    }

    public void setSystemCodeTypeMapper(SystemCodeTypeMapper systemCodeTypeMapper) {
        this.systemCodeTypeMapper = systemCodeTypeMapper;
    }

    public void setSystemExtColumnMapper(SystemExtColumnMapper systemExtColumnMapper) {
        this.systemExtColumnMapper = systemExtColumnMapper;
    }

    public void setAbilityMapper(AbilityMapper abilityMapper) {
        this.abilityMapper = abilityMapper;
    }

    public void setPluginSyncDataService(PluginSyncDataService pluginSyncDataService) {
        this.pluginSyncDataService = pluginSyncDataService;
    }

    public void setNodeInfo(NodeInfoConfig nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public void setSvcDeployHelp(SvcDeployHelp svcDeployHelp) {
        this.svcDeployHelp = svcDeployHelp;
    }

    public void setSyncDataService(SyncDataService syncDataService) {
        this.syncDataService = syncDataService;
    }

    public void setSystemParam(SystemParam systemParam) {
        this.systemParam = systemParam;
    }

    public void setPubSubRes(PubSubRes pubSubRes) {
        this.pubSubRes = pubSubRes;
    }

    public void setWebClusterConfig(WebClusterConfig webClusterConfig) {
        this.webClusterConfig = webClusterConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PubSubMsgHandler)) {
            return false;
        }
        PubSubMsgHandler other = (PubSubMsgHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SystemCodeTypeMapper this$systemCodeTypeMapper = this.getSystemCodeTypeMapper();
        SystemCodeTypeMapper other$systemCodeTypeMapper = other.getSystemCodeTypeMapper();
        if (this$systemCodeTypeMapper == null ? other$systemCodeTypeMapper != null : !this$systemCodeTypeMapper.equals(other$systemCodeTypeMapper)) {
            return false;
        }
        SystemExtColumnMapper this$systemExtColumnMapper = this.getSystemExtColumnMapper();
        SystemExtColumnMapper other$systemExtColumnMapper = other.getSystemExtColumnMapper();
        if (this$systemExtColumnMapper == null ? other$systemExtColumnMapper != null : !this$systemExtColumnMapper.equals(other$systemExtColumnMapper)) {
            return false;
        }
        AbilityMapper this$abilityMapper = this.getAbilityMapper();
        AbilityMapper other$abilityMapper = other.getAbilityMapper();
        if (this$abilityMapper == null ? other$abilityMapper != null : !this$abilityMapper.equals(other$abilityMapper)) {
            return false;
        }
        PluginSyncDataService this$pluginSyncDataService = this.getPluginSyncDataService();
        PluginSyncDataService other$pluginSyncDataService = other.getPluginSyncDataService();
        if (this$pluginSyncDataService == null ? other$pluginSyncDataService != null : !this$pluginSyncDataService.equals(other$pluginSyncDataService)) {
            return false;
        }
        NodeInfoConfig this$nodeInfo = this.getNodeInfo();
        NodeInfoConfig other$nodeInfo = other.getNodeInfo();
        if (this$nodeInfo == null ? other$nodeInfo != null : !this$nodeInfo.equals(other$nodeInfo)) {
            return false;
        }
        SvcDeployHelp this$svcDeployHelp = this.getSvcDeployHelp();
        SvcDeployHelp other$svcDeployHelp = other.getSvcDeployHelp();
        if (this$svcDeployHelp == null ? other$svcDeployHelp != null : !this$svcDeployHelp.equals(other$svcDeployHelp)) {
            return false;
        }
        SyncDataService this$syncDataService = this.getSyncDataService();
        SyncDataService other$syncDataService = other.getSyncDataService();
        if (this$syncDataService == null ? other$syncDataService != null : !this$syncDataService.equals(other$syncDataService)) {
            return false;
        }
        SystemParam this$systemParam = this.getSystemParam();
        SystemParam other$systemParam = other.getSystemParam();
        if (this$systemParam == null ? other$systemParam != null : !this$systemParam.equals(other$systemParam)) {
            return false;
        }
        PubSubRes this$pubSubRes = this.getPubSubRes();
        PubSubRes other$pubSubRes = other.getPubSubRes();
        if (this$pubSubRes == null ? other$pubSubRes != null : !this$pubSubRes.equals(other$pubSubRes)) {
            return false;
        }
        WebClusterConfig this$webClusterConfig = this.getWebClusterConfig();
        WebClusterConfig other$webClusterConfig = other.getWebClusterConfig();
        return !(this$webClusterConfig == null ? other$webClusterConfig != null : !((Object)this$webClusterConfig).equals(other$webClusterConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PubSubMsgHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SystemCodeTypeMapper $systemCodeTypeMapper = this.getSystemCodeTypeMapper();
        result = result * 59 + ($systemCodeTypeMapper == null ? 43 : $systemCodeTypeMapper.hashCode());
        SystemExtColumnMapper $systemExtColumnMapper = this.getSystemExtColumnMapper();
        result = result * 59 + ($systemExtColumnMapper == null ? 43 : $systemExtColumnMapper.hashCode());
        AbilityMapper $abilityMapper = this.getAbilityMapper();
        result = result * 59 + ($abilityMapper == null ? 43 : $abilityMapper.hashCode());
        PluginSyncDataService $pluginSyncDataService = this.getPluginSyncDataService();
        result = result * 59 + ($pluginSyncDataService == null ? 43 : $pluginSyncDataService.hashCode());
        NodeInfoConfig $nodeInfo = this.getNodeInfo();
        result = result * 59 + ($nodeInfo == null ? 43 : $nodeInfo.hashCode());
        SvcDeployHelp $svcDeployHelp = this.getSvcDeployHelp();
        result = result * 59 + ($svcDeployHelp == null ? 43 : $svcDeployHelp.hashCode());
        SyncDataService $syncDataService = this.getSyncDataService();
        result = result * 59 + ($syncDataService == null ? 43 : $syncDataService.hashCode());
        SystemParam $systemParam = this.getSystemParam();
        result = result * 59 + ($systemParam == null ? 43 : $systemParam.hashCode());
        PubSubRes $pubSubRes = this.getPubSubRes();
        result = result * 59 + ($pubSubRes == null ? 43 : $pubSubRes.hashCode());
        WebClusterConfig $webClusterConfig = this.getWebClusterConfig();
        result = result * 59 + ($webClusterConfig == null ? 43 : ((Object)$webClusterConfig).hashCode());
        return result;
    }

    public String toString() {
        return "PubSubMsgHandler(systemCodeTypeMapper=" + this.getSystemCodeTypeMapper() + ", systemExtColumnMapper=" + this.getSystemExtColumnMapper() + ", abilityMapper=" + this.getAbilityMapper() + ", pluginSyncDataService=" + this.getPluginSyncDataService() + ", nodeInfo=" + this.getNodeInfo() + ", svcDeployHelp=" + this.getSvcDeployHelp() + ", syncDataService=" + this.getSyncDataService() + ", systemParam=" + this.getSystemParam() + ", pubSubRes=" + this.getPubSubRes() + ", webClusterConfig=" + this.getWebClusterConfig() + ")";
    }
}

