/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.handler;

import com.ohaotian.abilityweb.config.congestion.CongestionBO;
import com.ohaotian.abilityweb.config.congestion.CongestionConfig;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.reactivestreams.Publisher;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Component
public class SystemInfoHandler {
    @Resource(name="currentCount")
    AtomicInteger currentCount;
    @Resource
    CongestionConfig congestionConfig;

    public Mono<ServerResponse> congestion(ServerRequest serverRequest) {
        Integer cc = this.currentCount.get();
        Integer max = this.congestionConfig.getMaxCount();
        Integer congestion = (int)((float)this.currentCount.get() / (float)this.congestionConfig.getMaxCount().intValue() * 100.0f);
        CongestionBO congestionBO = new CongestionBO();
        congestionBO.setMaxCount(max);
        congestionBO.setCurrentNum(cc);
        congestionBO.setCongestion(congestion);
        return ServerResponse.ok().contentType(MediaType.APPLICATION_JSON_UTF8).body((Publisher)Mono.just((Object)congestionBO), CongestionBO.class);
    }
}

