/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.handler;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.HttpUtil;
import com.ohaotian.abilitycommon.util.UrlUtil;
import com.ohaotian.abilityweb.component.error.ErrorReturnComponent;
import com.ohaotian.abilityweb.config.esbability.EsbAbilityMap;
import com.ohaotian.abilityweb.config.init.InitAbilityConfig;
import com.ohaotian.abilityweb.mapper.AbilityWsExtMapper;
import com.ohaotian.abilityweb.mapper.DefinedExceptionMapper;
import com.ohaotian.abilityweb.model.po.AbilityWsExtPO;
import com.ohaotian.abilityweb.service.esb.EsbService;
import com.ohaotian.abilityweb.util.PrintTLogUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Component
public class WebServiceHandler {
    private static Logger logger = LogManager.getLogger(WebServiceHandler.class);
    @Resource
    private EsbService esbService;
    @Resource(name="currentCount")
    AtomicInteger currentCount;
    @Resource
    AbilityWsExtMapper abilityWsExtMapper;
    @Resource
    private DefinedExceptionMapper definedExceptionMapper;
    @Resource
    ErrorReturnComponent errorReturnComponent;

    public Mono<ServerResponse> doAbility(ServerRequest serverRequest) {
        MsgContext msgContext = new MsgContext();
        if (!InitAbilityConfig.getIsFinished().booleanValue()) {
            HashMap<String, String> result = new HashMap<String, String>(8);
            result.put("rspCode", "9999");
            result.put("rspDesc", "\u8bf7\u6c42\u5931\u8d25\uff01\u8bf7\u7b49\u5f85\u80fd\u529b\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u80fd\u529b\u5e73\u53f0\u542f\u52a8\u4e2d...");
            return ServerResponse.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).contentType(MediaType.TEXT_XML).body((Publisher)Mono.just(result), Map.class);
        }
        if (serverRequest.queryParams().get((Object)"wsdl") != null) {
            String wsdlStr = this.getWsdl(serverRequest);
            return ServerResponse.ok().contentType(MediaType.TEXT_XML).body((Publisher)Mono.just((Object)wsdlStr), String.class);
        }
        if (serverRequest.method().matches("POST")) {
            return this.esbService.doService(serverRequest, msgContext).flatMap(s -> {
                HttpUtil.setContentType((MsgContext)msgContext, (String)"application/xml");
                PrintTLogUtil.printRequestOutLog(msgContext);
                return ((ServerResponse.BodyBuilder)ServerResponse.ok().headers(httpHeaders -> msgContext.getSelfDefHeader().getSelfDefRspMap().forEach((k, v) -> httpHeaders.add(k, v)))).syncBody(s);
            }).doOnCancel(() -> this.currentCount.getAndDecrement()).onErrorResume(e -> this.errorReturnComponent.doErrorReturn((Throwable)e, msgContext, MediaType.TEXT_XML, "ws"));
        }
        return ServerResponse.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).contentType(MediaType.TEXT_XML).body((Publisher)Mono.just((Object)CodeMsg.ESB_REQUEST_ERROR), CodeMsg.class);
    }

    private String getWsdl(ServerRequest request) {
        EsbAbility esbAbility = this.initAbility(request);
        AbilityWsExtPO abilityWsExtPO = new AbilityWsExtPO();
        abilityWsExtPO.setAbilityId(esbAbility.getAbilityId());
        abilityWsExtPO = this.abilityWsExtMapper.queryLimitOne(abilityWsExtPO);
        return abilityWsExtPO.getAbilityWsdl();
    }

    private EsbAbility initAbility(ServerRequest request) {
        try {
            String abilityAliasName = UrlUtil.getAbilityInfo((String)request.path(), (MsgContext)new MsgContext());
            EsbAbility esbAbility = EsbAbilityMap.getAbility(abilityAliasName);
            if (esbAbility == null) {
                throw new AbilityException(CodeMsg.E_REQ_SVC_MARK_ERROR.fillArgs(new Object[]{":" + request.path()}));
            }
            if (esbAbility.getAttendStatus() == 0) {
                throw new AbilityException(CodeMsg.E_SVC_SIGN_OUT.fillArgs(new Object[]{":" + abilityAliasName}));
            }
            return esbAbility;
        }
        catch (AbilityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AbilityException(CodeMsg.E_REQ_SVC_MARK_ERROR.fillArgs(new Object[]{":" + request.path()}));
        }
        catch (Throwable t) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }
}

