/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.router;

import com.ohaotian.abilitycommon.util.UUIDUtil;
import com.ohaotian.abilityweb.handler.FormDataHandler;
import com.ohaotian.abilityweb.handler.JsonHandler;
import com.ohaotian.abilityweb.handler.Oauth2Handler;
import com.ohaotian.abilityweb.handler.PlatHandler;
import com.ohaotian.abilityweb.handler.SystemInfoHandler;
import com.ohaotian.abilityweb.handler.WebServiceHandler;
import com.ohaotian.abilityweb.handler.XmlHandler;
import com.ohaotian.abilityweb.model.bo.EsbDefaultServerRequest;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;

@Configuration
public class RouterConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RouterConfiguration.class);
    @Resource(name="currentCount")
    private AtomicInteger currentCount;
    @Resource
    private JsonHandler jsonHandler;
    @Resource
    private XmlHandler xmlHandler;
    @Resource
    private WebServiceHandler webServiceHandler;
    @Resource
    private Oauth2Handler oauth2Handler;
    @Resource
    private PlatHandler platHandler;
    @Resource
    private SystemInfoHandler systemInfoHandler;
    @Resource
    private FormDataHandler formDataHandler;

    @Bean
    public RouterFunction<ServerResponse> routerService() {
        return RouterFunctions.route().path("", b1 -> b1.nest(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.ALL}), b2 -> b2.POST("/api/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8}), this.jsonHandler::doAbility).POST("/json/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8}), this.jsonHandler::doAbility).POST("/OSN/api/**", this.jsonHandler::doAbility).GET("/OSN/api/**", this.jsonHandler::doGetAbility).POST("/formData/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.MULTIPART_FORM_DATA}), this.formDataHandler::doAbility).POST("/xml/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_XML}), this.xmlHandler::doAbility).POST("/ws/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.TEXT_XML}), this.webServiceHandler::doAbility).GET("/ws/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.TEXT_XML}), this.webServiceHandler::doAbility).POST("/mock/OSN/api/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8}), this.jsonHandler::doAbility).POST("/mock/json/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8}), this.jsonHandler::doAbility).POST("/mock/xml/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_XML}), this.xmlHandler::doAbility).POST("/mock/ws/**", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.TEXT_XML}), this.webServiceHandler::doAbility).GET("/plat/info", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON}), this.platHandler::doAbility).before(request -> {
            String transId = UUIDUtil.generateUuid();
            MDC.put((String)"transId", (String)transId);
            log.info("########> {} <######### (..\u2022\u02d8_\u02d8\u2022..) ####################### START", request);
            return new EsbDefaultServerRequest((ServerRequest)request, transId);
        }).after((request, response) -> {
            this.currentCount.getAndDecrement();
            log.info("########> {} <######### \u250c(;\uffe3\u25c7\uffe3)\u2518 ###################### END", request);
            return response;
        }))).build();
    }

    @Bean
    public RouterFunction<ServerResponse> routerSystem() {
        return RouterFunctions.route().path("", b1 -> b1.nest(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.ALL}), b2 -> b2.POST("/oauth/token", this.oauth2Handler::doService).POST("/system/congestion", RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_UTF8}), this.systemInfoHandler::congestion))).build();
    }
}

