/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.abnormal.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.exception.log.ExceptionLogUtil;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.ErrorMessageBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.util.DateUtil;
import com.ohaotian.abilityweb.service.abnormal.AbnormalGrabService;
import java.text.MessageFormat;
import org.springframework.stereotype.Service;

@Service
public class AbnormalGrabServiceImpl
implements AbnormalGrabService {
    @Override
    public void programError(MsgContext msgContext, Throwable e) throws AbilityException {
        StringBuilder sbException = new StringBuilder();
        for (StackTraceElement ele : e.getStackTrace()) {
            sbException.append(MessageFormat.format("\tat {0}.{1}({2}:{3})\n", ele.getClassName(), ele.getMethodName(), ele.getFileName(), ele.getLineNumber()));
        }
        String exceptionMessage = sbException.toString();
        exceptionMessage = exceptionMessage.replace("\n", "\\n").replace("\t", "\\t").replace("\"", "'");
        String rspText = e.toString();
        rspText = rspText.replace("\n", "\\n").replace("\t", "\\t").replace("\"", "'") + "\\n";
        this.printErrorMessageLog(new CodeMsg("9998", rspText), msgContext, rspText + exceptionMessage, "\u7a0b\u5e8f\u62a5\u9519");
    }

    @Override
    public void landingReturn(MsgContext msgContext) throws AbilityException {
        String rspText = msgContext.getRspText();
        rspText = rspText.replace("\n", "\\n").replace("\t", "\\t").replace("\"", "'");
        this.printErrorMessageLog(new CodeMsg("9999", rspText), msgContext, rspText, "\u5f02\u5e38\u8fd4\u56de");
    }

    @Override
    public void printErrorMessageLog(CodeMsg codeMsg, MsgContext msgContext, String exceptionMessage, String errorType) throws AbilityException {
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        ErrorMessageBO errorMessageBO = new ErrorMessageBO();
        errorMessageBO.setAbilityName(esbAbility.getAbilityName());
        errorMessageBO.setAbilityEname(esbAbility.getAbilityEname());
        errorMessageBO.setTraceId(selfDefHeader.getSysTransId());
        errorMessageBO.setBusinessCenterCode(msgContext.getBusinessCenterCode());
        errorMessageBO.setJoinTime(msgContext.getTlogReqHeader().getJoinTime());
        errorMessageBO.setOccurrenceTime(DateUtil.getCurrentDateSSSTime());
        errorMessageBO.setErrorType(errorType);
        errorMessageBO.setCodeMsg(codeMsg);
        errorMessageBO.setResultMessage(exceptionMessage);
        ExceptionLogUtil.exceptionLog((ErrorMessageBO)errorMessageBO);
    }
}

